/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime;

import cucumber.api.Result;
import cucumber.api.Scenario;
import cucumber.api.event.EmbedEvent;
import cucumber.api.event.WriteEvent;
import cucumber.runner.EventBus;
import gherkin.events.PickleEvent;
import gherkin.pickles.Pickle;
import gherkin.pickles.PickleLocation;
import gherkin.pickles.PickleTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class ScenarioImpl
implements Scenario {
    private final List<Result> stepResults = new ArrayList<Result>();
    private final List<PickleTag> tags;
    private final String uri;
    private final String scenarioName;
    private final String scenarioId;
    private final List<Integer> scenarioLines;
    private final EventBus bus;

    public ScenarioImpl(EventBus bus, PickleEvent pickleEvent) {
        this.bus = bus;
        Pickle pickle = pickleEvent.pickle;
        this.tags = pickle.getTags();
        this.uri = pickleEvent.uri;
        this.scenarioName = pickle.getName();
        List locations = pickle.getLocations();
        this.scenarioId = pickleEvent.uri + ":" + Integer.toString(((PickleLocation)locations.get(0)).getLine());
        ArrayList<Integer> lines = new ArrayList<Integer>();
        for (PickleLocation location : locations) {
            lines.add(location.getLine());
        }
        this.scenarioLines = Collections.unmodifiableList(lines);
    }

    public void add(Result result) {
        this.stepResults.add(result);
    }

    @Override
    public Collection<String> getSourceTagNames() {
        HashSet<String> result = new HashSet<String>();
        for (PickleTag tag : this.tags) {
            result.add(tag.getName());
        }
        return new ArrayList<String>(result);
    }

    @Override
    public Result.Type getStatus() {
        if (this.stepResults.isEmpty()) {
            return Result.Type.UNDEFINED;
        }
        return Collections.max(this.stepResults, Result.SEVERITY).getStatus();
    }

    @Override
    public boolean isFailed() {
        return this.getStatus() == Result.Type.FAILED;
    }

    @Override
    public void embed(byte[] data, String mimeType) {
        if (this.bus != null) {
            this.bus.send(new EmbedEvent(this.bus.getTime(), data, mimeType));
        }
    }

    @Override
    public void write(String text) {
        if (this.bus != null) {
            this.bus.send(new WriteEvent(this.bus.getTime(), text));
        }
    }

    @Override
    public String getName() {
        return this.scenarioName;
    }

    @Override
    public String getId() {
        return this.scenarioId;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public List<Integer> getLines() {
        return this.scenarioLines;
    }

    public Throwable getError() {
        if (this.stepResults.isEmpty()) {
            return null;
        }
        return Collections.max(this.stepResults, Result.SEVERITY).getError();
    }
}

