/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.model;

import cucumber.api.event.TestSourceRead;
import cucumber.runner.EventBus;
import cucumber.runtime.CucumberException;
import cucumber.runtime.io.Resource;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.model.FeatureBuilder;
import cucumber.runtime.model.PathWithLines;
import cucumber.util.Encoding;
import gherkin.ast.GherkinDocument;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CucumberFeature
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String uri;
    private GherkinDocument gherkinDocument;
    private String gherkinSource;
    public static final Pattern RERUN_PATH_SPECIFICATION = Pattern.compile("(?m:^| |)(.*?\\.feature(?:(?::\\d+)*))");

    public static List<CucumberFeature> load(ResourceLoader resourceLoader, List<String> featurePaths, PrintStream out) {
        List<CucumberFeature> cucumberFeatures = CucumberFeature.load(resourceLoader, featurePaths);
        if (cucumberFeatures.isEmpty()) {
            if (featurePaths.isEmpty()) {
                out.println("Got no path to feature directory or feature file");
            } else {
                out.println(String.format("No features found at %s", featurePaths));
            }
        }
        return cucumberFeatures;
    }

    public static List<CucumberFeature> load(ResourceLoader resourceLoader, List<String> featurePaths) {
        ArrayList<CucumberFeature> cucumberFeatures = new ArrayList<CucumberFeature>();
        FeatureBuilder builder = new FeatureBuilder(cucumberFeatures);
        for (String featurePath : featurePaths) {
            if (featurePath.startsWith("@")) {
                CucumberFeature.loadFromRerunFile(builder, resourceLoader, featurePath.substring(1));
                continue;
            }
            CucumberFeature.loadFromFeaturePath(builder, resourceLoader, featurePath, false);
        }
        Collections.sort(cucumberFeatures, new CucumberFeatureUriComparator());
        return cucumberFeatures;
    }

    private static void loadFromRerunFile(FeatureBuilder builder, ResourceLoader resourceLoader, String rerunPath) {
        for (PathWithLines pathWithLines : CucumberFeature.loadRerunFile(resourceLoader, rerunPath)) {
            CucumberFeature.loadFromFileSystemOrClasspath(builder, resourceLoader, pathWithLines.path);
        }
    }

    public static List<PathWithLines> loadRerunFile(ResourceLoader resourceLoader, String rerunPath) {
        ArrayList<PathWithLines> featurePaths = new ArrayList<PathWithLines>();
        Iterable<Resource> resources = resourceLoader.resources(rerunPath, null);
        for (Resource resource : resources) {
            String source = CucumberFeature.read(resource);
            if (source.isEmpty()) continue;
            Matcher matcher = RERUN_PATH_SPECIFICATION.matcher(source);
            while (matcher.find()) {
                featurePaths.add(new PathWithLines(matcher.group(1)));
            }
        }
        return featurePaths;
    }

    private static String read(Resource resource) {
        try {
            return Encoding.readFile(resource);
        }
        catch (IOException e) {
            throw new CucumberException("Failed to read resource:" + resource.getPath(), e);
        }
    }

    private static void loadFromFileSystemOrClasspath(FeatureBuilder builder, ResourceLoader resourceLoader, String featurePath) {
        try {
            CucumberFeature.loadFromFeaturePath(builder, resourceLoader, featurePath, false);
        }
        catch (IllegalArgumentException originalException) {
            if (!featurePath.startsWith("classpath:") && originalException.getMessage().contains("Not a file or directory")) {
                try {
                    CucumberFeature.loadFromFeaturePath(builder, resourceLoader, "classpath:" + featurePath, true);
                }
                catch (IllegalArgumentException secondException) {
                    if (secondException.getMessage().contains("No resource found for")) {
                        throw new IllegalArgumentException("Neither found on file system or on classpath: " + originalException.getMessage() + ", " + secondException.getMessage());
                    }
                    throw secondException;
                }
            }
            throw originalException;
        }
    }

    private static void loadFromFeaturePath(FeatureBuilder builder, ResourceLoader resourceLoader, String featurePath, boolean failOnNoResource) {
        Iterable<Resource> resources = resourceLoader.resources(featurePath, ".feature");
        if (failOnNoResource && !resources.iterator().hasNext()) {
            throw new IllegalArgumentException("No resource found for: " + featurePath);
        }
        for (Resource resource : resources) {
            builder.parse(resource);
        }
    }

    public CucumberFeature(GherkinDocument gherkinDocument, String uri, String gherkinSource) {
        this.gherkinDocument = gherkinDocument;
        this.uri = uri;
        this.gherkinSource = gherkinSource;
    }

    public GherkinDocument getGherkinFeature() {
        return this.gherkinDocument;
    }

    public String getUri() {
        return this.uri;
    }

    public void sendTestSourceRead(EventBus bus) {
        bus.send(new TestSourceRead(bus.getTime(), this.uri, this.gherkinSource));
    }

    private static class CucumberFeatureUriComparator
    implements Comparator<CucumberFeature> {
        private CucumberFeatureUriComparator() {
        }

        @Override
        public int compare(CucumberFeature a, CucumberFeature b) {
            return a.getUri().compareTo(b.getUri());
        }
    }
}

