/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.formatter;

import cucumber.api.Plugin;
import cucumber.api.StepDefinitionReporter;
import cucumber.api.SummaryPrinter;
import cucumber.api.event.ConcurrentEventListener;
import cucumber.api.event.EventListener;
import cucumber.runtime.CucumberException;
import cucumber.runtime.Utils;
import cucumber.runtime.formatter.DefaultSummaryPrinter;
import cucumber.runtime.formatter.HTMLFormatter;
import cucumber.runtime.formatter.JSONFormatter;
import cucumber.runtime.formatter.JUnitFormatter;
import cucumber.runtime.formatter.NullSummaryPrinter;
import cucumber.runtime.formatter.PrettyFormatter;
import cucumber.runtime.formatter.ProgressFormatter;
import cucumber.runtime.formatter.RerunFormatter;
import cucumber.runtime.formatter.TestNGFormatter;
import cucumber.runtime.formatter.TimelineFormatter;
import cucumber.runtime.formatter.UsageFormatter;
import cucumber.runtime.io.URLOutputStream;
import cucumber.runtime.io.UTF8OutputStreamWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PluginFactory {
    private final Class[] CTOR_PARAMETERS = new Class[]{String.class, Appendable.class, URI.class, URL.class, File.class};
    private static final HashMap<String, Class<? extends Plugin>> PLUGIN_CLASSES = new HashMap<String, Class<? extends Plugin>>(){
        {
            this.put("junit", JUnitFormatter.class);
            this.put("testng", TestNGFormatter.class);
            this.put("html", HTMLFormatter.class);
            this.put("pretty", PrettyFormatter.class);
            this.put("progress", ProgressFormatter.class);
            this.put("json", JSONFormatter.class);
            this.put("usage", UsageFormatter.class);
            this.put("rerun", RerunFormatter.class);
            this.put("default_summary", DefaultSummaryPrinter.class);
            this.put("null_summary", NullSummaryPrinter.class);
            this.put("timeline", TimelineFormatter.class);
        }
    };
    private static final Pattern PLUGIN_WITH_ARGUMENT_PATTERN = Pattern.compile("([^:]+):(.*)");
    private String defaultOutFormatter = null;
    private Appendable defaultOut = new PrintStream(System.out){

        @Override
        public void close() {
        }
    };

    public Plugin create(String pluginString) {
        String argument;
        String pluginName;
        Matcher pluginWithArgument = PLUGIN_WITH_ARGUMENT_PATTERN.matcher(pluginString);
        if (pluginWithArgument.matches()) {
            pluginName = pluginWithArgument.group(1);
            argument = pluginWithArgument.group(2);
        } else {
            pluginName = pluginString;
            argument = null;
        }
        Class<? extends Plugin> pluginClass = PluginFactory.pluginClass(pluginName);
        try {
            return this.instantiate(pluginString, pluginClass, argument);
        }
        catch (IOException e) {
            throw new CucumberException(e);
        }
        catch (URISyntaxException e) {
            throw new CucumberException(e);
        }
    }

    private <T extends Plugin> T instantiate(String pluginString, Class<T> pluginClass, String argument) throws IOException, URISyntaxException {
        Object ctorArg;
        Constructor<T> single = this.findSingleArgConstructor(pluginClass);
        Constructor<T> empty = this.findEmptyConstructor(pluginClass);
        if (single != null && (ctorArg = this.convertOrNull(argument, single.getParameterTypes()[0], pluginString)) != null) {
            return this.newInstance(single, ctorArg);
        }
        if (argument == null && empty != null) {
            return this.newInstance(empty, new Object[0]);
        }
        if (single != null) {
            throw new CucumberException(String.format("You must supply an output argument to %s. Like so: %s:output", pluginString, pluginString));
        }
        throw new CucumberException(String.format("%s must have a constructor that is either empty or a single arg of one of: %s", pluginClass, Arrays.asList(this.CTOR_PARAMETERS)));
    }

    private <T extends Plugin> T newInstance(Constructor<T> constructor, Object ... ctorArgs) {
        try {
            return (T)((Plugin)constructor.newInstance(ctorArgs));
        }
        catch (InstantiationException e) {
            throw new CucumberException(e);
        }
        catch (IllegalAccessException e) {
            throw new CucumberException(e);
        }
        catch (InvocationTargetException e) {
            throw new CucumberException(e.getTargetException());
        }
    }

    private Object convertOrNull(String arg, Class ctorArgClass, String formatterString) throws IOException, URISyntaxException {
        if (arg == null) {
            if (ctorArgClass.equals(Appendable.class)) {
                return this.defaultOutOrFailIfAlreadyUsed(formatterString);
            }
            return null;
        }
        if (ctorArgClass.equals(URI.class)) {
            return new URI(arg);
        }
        if (ctorArgClass.equals(URL.class)) {
            return Utils.toURL(arg);
        }
        if (ctorArgClass.equals(File.class)) {
            return new File(arg);
        }
        if (ctorArgClass.equals(String.class)) {
            return arg;
        }
        if (ctorArgClass.equals(Appendable.class)) {
            return new UTF8OutputStreamWriter(new URLOutputStream(Utils.toURL(arg)));
        }
        return null;
    }

    private <T> Constructor<T> findSingleArgConstructor(Class<T> pluginClass) {
        Constructor<T> constructor = null;
        for (Class ctorArgClass : this.CTOR_PARAMETERS) {
            try {
                Constructor<T> candidate = pluginClass.getConstructor(ctorArgClass);
                if (constructor != null) {
                    throw new CucumberException(String.format("Plugin %s should only define a single one-argument constructor", pluginClass.getName()));
                }
                constructor = candidate;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return constructor;
    }

    private <T> Constructor<T> findEmptyConstructor(Class<T> pluginClass) {
        try {
            return pluginClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException ignore) {
            return null;
        }
    }

    private static Class<? extends Plugin> pluginClass(String pluginName) {
        Class<? extends Plugin> pluginClass = PLUGIN_CLASSES.get(pluginName);
        if (pluginClass == null) {
            pluginClass = PluginFactory.loadClass(pluginName);
        }
        return pluginClass;
    }

    private static Class<? extends Plugin> loadClass(String className) {
        try {
            Class<?> aClass = Thread.currentThread().getContextClassLoader().loadClass(className);
            if (Plugin.class.isAssignableFrom(aClass)) {
                return aClass;
            }
            throw new CucumberException("Couldn't load plugin class: " + className + ". It does not implement " + Plugin.class.getName());
        }
        catch (ClassNotFoundException e) {
            throw new CucumberException("Couldn't load plugin class: " + className, e);
        }
    }

    private Appendable defaultOutOrFailIfAlreadyUsed(String formatterString) {
        try {
            if (this.defaultOut != null) {
                this.defaultOutFormatter = formatterString;
                Appendable appendable = this.defaultOut;
                return appendable;
            }
            throw new CucumberException("Only one formatter can use STDOUT, now both " + this.defaultOutFormatter + " and " + formatterString + " use it. If you use more than one formatter you must specify output path with PLUGIN:PATH_OR_URL");
        }
        finally {
            this.defaultOut = null;
        }
    }

    public static boolean isFormatterName(String name) {
        Class pluginClass = PluginFactory.getPluginClass(name);
        return EventListener.class.isAssignableFrom(pluginClass) || ConcurrentEventListener.class.isAssignableFrom(pluginClass);
    }

    public static boolean isStepDefinitionReporterName(String name) {
        Class pluginClass = PluginFactory.getPluginClass(name);
        return StepDefinitionReporter.class.isAssignableFrom(pluginClass);
    }

    public static boolean isSummaryPrinterName(String name) {
        Class pluginClass = PluginFactory.getPluginClass(name);
        return SummaryPrinter.class.isAssignableFrom(pluginClass);
    }

    private static Class getPluginClass(String name) {
        Matcher pluginWithFile = PLUGIN_WITH_ARGUMENT_PATTERN.matcher(name);
        String pluginName = pluginWithFile.matches() ? pluginWithFile.group(1) : name;
        return PluginFactory.pluginClass(pluginName);
    }
}

