/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.formatter;

import cucumber.api.TestCase;
import cucumber.api.event.ConcurrentEventListener;
import cucumber.api.event.EventHandler;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestCaseEvent;
import cucumber.api.event.TestCaseFinished;
import cucumber.api.event.TestCaseStarted;
import cucumber.api.event.TestRunFinished;
import cucumber.api.event.TestSourceRead;
import cucumber.api.formatter.NiceAppendable;
import cucumber.runtime.CucumberException;
import cucumber.runtime.formatter.TestSourcesModel;
import cucumber.runtime.io.URLOutputStream;
import gherkin.deps.com.google.gson.Gson;
import gherkin.deps.com.google.gson.GsonBuilder;
import gherkin.deps.com.google.gson.annotations.SerializedName;
import gherkin.pickles.PickleTag;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class TimelineFormatter
implements ConcurrentEventListener {
    private static final String[] TEXT_ASSETS = new String[]{"/io/cucumber/formatter/timeline/index.html", "/io/cucumber/formatter/timeline/formatter.js", "/io/cucumber/formatter/timeline/report.css", "/io/cucumber/formatter/timeline/jquery-3.3.1.min.js", "/io/cucumber/formatter/timeline/vis.min.css", "/io/cucumber/formatter/timeline/vis.min.js", "/io/cucumber/formatter/timeline/vis.override.css", "/io/cucumber/formatter/timeline/chosen.jquery.min.js", "/io/cucumber/formatter/timeline/chosen.min.css", "/io/cucumber/formatter/timeline/chosen.override.css", "/io/cucumber/formatter/timeline/chosen-sprite.png"};
    private final EventHandler<TestSourceRead> testSourceReadHandler = new EventHandler<TestSourceRead>(){

        @Override
        public void receive(TestSourceRead event) {
            TimelineFormatter.this.testSources.addTestSourceReadEvent(event.uri, event);
        }
    };
    private final EventHandler<TestCaseStarted> caseStartedHandler = new EventHandler<TestCaseStarted>(){

        @Override
        public void receive(TestCaseStarted event) {
            TimelineFormatter.this.handleTestCaseStarted(event);
        }
    };
    private final EventHandler<TestCaseFinished> caseFinishedHandler = new EventHandler<TestCaseFinished>(){

        @Override
        public void receive(TestCaseFinished event) {
            TimelineFormatter.this.handleTestCaseFinished(event);
        }
    };
    private final EventHandler<TestRunFinished> runFinishedHandler = new EventHandler<TestRunFinished>(){

        @Override
        public void receive(TestRunFinished event) {
            TimelineFormatter.this.finishReport(event);
        }
    };
    private final TestSourcesModel testSources = new TestSourcesModel();
    private final Map<String, TestData> allTests = new HashMap<String, TestData>();
    private final Map<Long, GroupData> allGroups = new HashMap<Long, GroupData>();
    private final URL reportDir;
    private final NiceAppendable reportJs;

    public TimelineFormatter(URL reportDir) {
        this(reportDir, TimelineFormatter.createJsonOut(reportDir, "report.js"));
    }

    private TimelineFormatter(URL reportDir, NiceAppendable reportJs) {
        this.reportDir = reportDir;
        this.reportJs = reportJs;
    }

    @Override
    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestSourceRead.class, this.testSourceReadHandler);
        publisher.registerHandlerFor(TestCaseStarted.class, this.caseStartedHandler);
        publisher.registerHandlerFor(TestCaseFinished.class, this.caseFinishedHandler);
        publisher.registerHandlerFor(TestRunFinished.class, this.runFinishedHandler);
    }

    private void handleTestCaseStarted(TestCaseStarted event) {
        Thread currentThread = Thread.currentThread();
        Long threadId = currentThread.getId();
        TestData test = new TestData(event, threadId);
        this.allTests.put(this.getId(event), test);
        if (!this.allGroups.containsKey(threadId)) {
            this.allGroups.put(threadId, new GroupData(currentThread));
        }
    }

    private void handleTestCaseFinished(TestCaseFinished event) {
        String id = this.getId(event);
        this.allTests.get(id).end(event);
    }

    private void finishReport(TestRunFinished event) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        this.reportJs.append("$(document).ready(function() {");
        this.reportJs.println();
        this.appendAsJsonToJs(gson, this.reportJs, "timelineItems", this.allTests.values());
        this.reportJs.println();
        this.appendAsJsonToJs(gson, this.reportJs, "timelineGroups", new TreeMap<Long, GroupData>(this.allGroups).values());
        this.reportJs.println();
        this.reportJs.append("});");
        this.reportJs.close();
        this.copyReportFiles();
    }

    private void appendAsJsonToJs(Gson gson, NiceAppendable out, String pushTo, Collection<?> content) {
        out.append("CucumberHTML." + pushTo + ".pushArray(");
        out.append(gson.toJson(content));
        out.append(");");
    }

    private void copyReportFiles() {
        if (this.reportDir == null) {
            return;
        }
        File outputDir = new File(this.reportDir.getPath());
        for (String textAsset : TEXT_ASSETS) {
            InputStream textAssetStream = this.getClass().getResourceAsStream(textAsset);
            if (textAssetStream == null) {
                throw new CucumberException("Couldn't find " + textAsset);
            }
            String fileName = new File(textAsset).getName();
            TimelineFormatter.copyFile(textAssetStream, new File(outputDir, fileName));
            TimelineFormatter.closeQuietly(textAssetStream);
        }
    }

    private static NiceAppendable createJsonOut(URL dir, String file) {
        File outDir = new File(dir.getPath());
        if (!outDir.exists() && !outDir.mkdirs()) {
            throw new CucumberException("Failed to create dir: " + dir.getPath());
        }
        try {
            URLOutputStream out = new URLOutputStream(new URL(dir, file));
            return new NiceAppendable(new OutputStreamWriter((OutputStream)out, "UTF-8"));
        }
        catch (IOException e) {
            throw new CucumberException(e);
        }
    }

    private static void copyFile(InputStream source, File dest) throws CucumberException {
        FileOutputStream os = null;
        try {
            int length;
            os = new FileOutputStream(dest);
            byte[] buffer = new byte[1024];
            while ((length = source.read(buffer)) > 0) {
                ((OutputStream)os).write(buffer, 0, length);
            }
        }
        catch (IOException e) {
            try {
                throw new CucumberException("Unable to write to report file item: ", e);
            }
            catch (Throwable throwable) {
                TimelineFormatter.closeQuietly(os);
                throw throwable;
            }
        }
        TimelineFormatter.closeQuietly(os);
    }

    private static void closeQuietly(Closeable out) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String getId(TestCaseEvent testCaseEvent) {
        TestCase testCase = testCaseEvent.getTestCase();
        String uri = testCase.getUri();
        TestSourcesModel.AstNode astNode = this.testSources.getAstNode(uri, testCase.getLine());
        return TestSourcesModel.calculateId(astNode);
    }

    class GroupData {
        @SerializedName(value="id")
        final long id;
        @SerializedName(value="content")
        final String content;

        GroupData(Thread thread) {
            this.id = thread.getId();
            this.content = thread.toString();
        }
    }

    class TestData {
        @SerializedName(value="id")
        final String id;
        @SerializedName(value="feature")
        final String feature;
        @SerializedName(value="scenario")
        final String scenario;
        @SerializedName(value="start")
        final long startTime;
        @SerializedName(value="end")
        long endTime;
        @SerializedName(value="group")
        final long threadId;
        @SerializedName(value="content")
        final String content = "";
        @SerializedName(value="className")
        String className;
        @SerializedName(value="tags")
        final String tags;

        TestData(TestCaseStarted started, Long threadId) {
            this.id = TimelineFormatter.this.getId(started);
            TestCase testCase = started.getTestCase();
            String uri = testCase.getUri();
            this.feature = TimelineFormatter.this.testSources.getFeatureName(uri);
            this.scenario = testCase.getName();
            this.startTime = TimeUnit.NANOSECONDS.toMillis(started.getTimeStamp());
            this.threadId = threadId;
            this.tags = this.buildTagsValue(testCase);
        }

        private String buildTagsValue(TestCase testCase) {
            StringBuilder tags = new StringBuilder();
            for (PickleTag tag : testCase.getTags()) {
                tags.append(tag.getName().toLowerCase()).append(",");
            }
            return tags.toString();
        }

        public void end(TestCaseFinished event) {
            this.endTime = TimeUnit.NANOSECONDS.toMillis(event.getTimeStamp());
            this.className = event.result.getStatus().lowerCaseName();
        }
    }
}

