/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.stepexpression;

import cucumber.runtime.CucumberException;
import io.cucumber.cucumberexpressions.Expression;
import io.cucumber.cucumberexpressions.ExpressionFactory;
import io.cucumber.cucumberexpressions.UndefinedParameterTypeException;
import io.cucumber.datatable.DataTable;
import io.cucumber.datatable.DataTableTypeRegistryTableConverter;
import io.cucumber.stepexpression.DocStringTransformer;
import io.cucumber.stepexpression.RawTableTransformer;
import io.cucumber.stepexpression.StepExpression;
import io.cucumber.stepexpression.TypeRegistry;
import io.cucumber.stepexpression.TypeResolver;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;

public final class StepExpressionFactory {
    private final ExpressionFactory expressionFactory;
    private final DataTableTypeRegistryTableConverter tableConverter;
    private static final DocStringTransformer<String> DOC_STRING_IDENTITY = new DocStringTransformer<String>(){

        @Override
        public String transform(String input) {
            return input;
        }
    };

    public StepExpressionFactory(TypeRegistry registry) {
        this.expressionFactory = new ExpressionFactory(registry.parameterTypeRegistry());
        this.tableConverter = new DataTableTypeRegistryTableConverter(registry.dataTableTypeRegistry());
    }

    public StepExpression createExpression(String expressionString) {
        if (expressionString == null) {
            throw new NullPointerException("expression can not be null");
        }
        Expression expression = this.expressionFactory.createExpression(expressionString);
        RawTableTransformer<DataTable> toDataTable = new RawTableTransformer<DataTable>(){

            @Override
            public DataTable transform(List<List<String>> raw) {
                return DataTable.create(raw, (DataTable.TableConverter)StepExpressionFactory.this.tableConverter);
            }
        };
        return new StepExpression(expression, DOC_STRING_IDENTITY, toDataTable);
    }

    public StepExpression createExpression(String expressionString, Type tableOrDocStringType) {
        return this.createExpression(expressionString, new ResolvedType(tableOrDocStringType), false);
    }

    public StepExpression createExpression(String expressionString, TypeResolver tableOrDocStringType) {
        return this.createExpression(expressionString, tableOrDocStringType, false);
    }

    public StepExpression createExpression(String expressionString, Type tableOrDocStringType, boolean transpose) {
        return this.createExpression(expressionString, new ResolvedType(tableOrDocStringType), transpose);
    }

    public StepExpression createExpression(String expressionString, final TypeResolver tableOrDocStringType, final boolean transpose) {
        Expression expression;
        if (expressionString == null) {
            throw new NullPointerException("expressionString can not be null");
        }
        if (tableOrDocStringType == null) {
            throw new NullPointerException("tableOrDocStringType can not be null");
        }
        try {
            expression = this.expressionFactory.createExpression(expressionString);
        }
        catch (UndefinedParameterTypeException e) {
            throw this.registerTypeInConfiguration(expressionString, e);
        }
        RawTableTransformer<Object> tableTransform = new RawTableTransformer<Object>(){

            @Override
            public Object transform(List<List<String>> raw) {
                DataTable dataTable = DataTable.create(raw, (DataTable.TableConverter)StepExpressionFactory.this.tableConverter);
                Type targetType = tableOrDocStringType.resolve();
                return dataTable.convert((Type)(targetType == null ? DataTable.class : targetType), transpose);
            }
        };
        DocStringTransformer<Object> docStringTransform = new DocStringTransformer<Object>(){

            @Override
            public Object transform(String docString) {
                Type targetType = tableOrDocStringType.resolve();
                if (targetType == null) {
                    return docString;
                }
                List<List<String>> raw = Collections.singletonList(Collections.singletonList(docString));
                return DataTable.create(raw, (DataTable.TableConverter)StepExpressionFactory.this.tableConverter).convert(targetType, transpose);
            }
        };
        return new StepExpression(expression, docStringTransform, tableTransform);
    }

    private CucumberException registerTypeInConfiguration(String expressionString, UndefinedParameterTypeException e) {
        return new CucumberException(String.format("Could not create a cucumber expression for '%s'.\nIt appears you did not register parameter type. The details are in the stacktrace below.\nYou can find the documentation here: https://docs.cucumber.io/cucumber/cucumber-expressions/", expressionString), e);
    }

    private static final class ResolvedType
    implements TypeResolver {
        private final Type type;

        private ResolvedType(Type type) {
            this.type = type;
        }

        @Override
        public Type resolve() {
            return this.type;
        }
    }
}

