/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.filter;

import cucumber.runtime.RuntimeOptions;
import cucumber.runtime.filter.LinePredicate;
import cucumber.runtime.filter.NamePredicate;
import cucumber.runtime.filter.PicklePredicate;
import cucumber.runtime.filter.RerunFilters;
import cucumber.runtime.filter.TagPredicate;
import gherkin.events.PickleEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class Filters {
    private final List<PicklePredicate> filters;
    private final RuntimeOptions runtimeOptions;
    private final RerunFilters rerunFilters;

    public Filters(RuntimeOptions runtimeOptions, RerunFilters rerunFilters) {
        List<Pattern> nameFilters;
        this.runtimeOptions = runtimeOptions;
        this.rerunFilters = rerunFilters;
        this.filters = new ArrayList<PicklePredicate>();
        List<String> tagFilters = this.runtimeOptions.getTagFilters();
        if (!tagFilters.isEmpty()) {
            this.filters.add(new TagPredicate(tagFilters));
        }
        if (!(nameFilters = runtimeOptions.getNameFilters()).isEmpty()) {
            this.filters.add(new NamePredicate(nameFilters));
        }
        Map<String, List<Long>> lineFilters = runtimeOptions.getLineFilters();
        Map<String, List<Long>> rerunlineFilters = rerunFilters.processRerunFiles();
        for (Map.Entry<String, List<Long>> line : rerunlineFilters.entrySet()) {
            this.addLineFilters(lineFilters, line.getKey(), line.getValue());
        }
        if (!lineFilters.isEmpty()) {
            this.filters.add(new LinePredicate(lineFilters));
        }
    }

    public boolean matchesFilters(PickleEvent pickleEvent) {
        for (PicklePredicate filter : this.filters) {
            if (filter.apply(pickleEvent)) continue;
            return false;
        }
        return true;
    }

    private void addLineFilters(Map<String, List<Long>> parsedLineFilters, String key, List<Long> lines) {
        if (parsedLineFilters.containsKey(key)) {
            parsedLineFilters.get(key).addAll(lines);
        } else {
            parsedLineFilters.put(key, lines);
        }
    }
}

