/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.io;

import cucumber.runtime.CucumberException;
import cucumber.runtime.io.Resource;
import cucumber.runtime.io.ResourceIteratorFactory;
import java.net.URL;
import java.util.Iterator;
import java.util.ServiceLoader;

class DelegatingResourceIteratorFactory
implements ResourceIteratorFactory {
    private final Iterable<ResourceIteratorFactory> delegates = ServiceLoader.load(ResourceIteratorFactory.class);
    private final ResourceIteratorFactory fallbackResourceIteratorFactory;

    DelegatingResourceIteratorFactory(ResourceIteratorFactory fallbackResourceIteratorFactory) {
        this.fallbackResourceIteratorFactory = fallbackResourceIteratorFactory;
    }

    @Override
    public boolean isFactoryFor(URL url) {
        for (ResourceIteratorFactory delegate : this.delegates) {
            if (!delegate.isFactoryFor(url)) continue;
            return true;
        }
        return this.fallbackResourceIteratorFactory.isFactoryFor(url);
    }

    @Override
    public Iterator<Resource> createIterator(URL url, String path, String suffix) {
        for (ResourceIteratorFactory delegate : this.delegates) {
            if (!delegate.isFactoryFor(url)) continue;
            return delegate.createIterator(url, path, suffix);
        }
        if (this.fallbackResourceIteratorFactory.isFactoryFor(url)) {
            return this.fallbackResourceIteratorFactory.createIterator(url, path, suffix);
        }
        throw new CucumberException("Fallback factory cannot handle URL: " + url);
    }
}

