/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.formatter;

import cucumber.api.SummaryPrinter;
import cucumber.api.event.EventHandler;
import cucumber.api.event.EventListener;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestRunFinished;
import cucumber.api.formatter.ColorAware;
import cucumber.api.formatter.StrictAware;
import cucumber.runtime.UndefinedStepsTracker;
import cucumber.runtime.formatter.Stats;
import java.io.PrintStream;
import java.util.List;

class DefaultSummaryPrinter
implements SummaryPrinter,
ColorAware,
StrictAware,
EventListener {
    private final Stats stats = new Stats();
    private final UndefinedStepsTracker undefinedStepsTracker = new UndefinedStepsTracker();
    private final PrintStream out = System.out;

    private void print() {
        this.out.println();
        this.printStats();
        this.out.println();
        this.printErrors();
        this.printSnippets();
    }

    private void printStats() {
        this.stats.printStats(this.out);
    }

    private void printErrors() {
        for (Throwable error : this.stats.getErrors()) {
            error.printStackTrace(this.out);
            this.out.println();
        }
    }

    private void printSnippets() {
        List<String> snippets = this.undefinedStepsTracker.getSnippets();
        if (!snippets.isEmpty()) {
            this.out.append("\n");
            this.out.println("You can implement missing steps with the snippets below:");
            this.out.println();
            for (String snippet : snippets) {
                this.out.println(snippet);
            }
        }
    }

    @Override
    public void setEventPublisher(EventPublisher publisher) {
        this.stats.setEventPublisher(publisher);
        this.undefinedStepsTracker.setEventPublisher(publisher);
        publisher.registerHandlerFor(TestRunFinished.class, new EventHandler<TestRunFinished>(){

            @Override
            public void receive(TestRunFinished event) {
                DefaultSummaryPrinter.this.print();
            }
        });
    }

    @Override
    public void setMonochrome(boolean monochrome) {
        this.stats.setMonochrome(monochrome);
    }

    @Override
    public void setStrict(boolean strict) {
        this.stats.setStrict(strict);
    }
}

