/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.formatter;

import cucumber.api.HookTestStep;
import cucumber.api.PickleStepTestStep;
import cucumber.api.Result;
import cucumber.api.TestCase;
import cucumber.api.event.EmbedEvent;
import cucumber.api.event.EventHandler;
import cucumber.api.event.EventListener;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestCaseStarted;
import cucumber.api.event.TestRunFinished;
import cucumber.api.event.TestSourceRead;
import cucumber.api.event.TestStepFinished;
import cucumber.api.event.TestStepStarted;
import cucumber.api.event.WriteEvent;
import cucumber.api.formatter.NiceAppendable;
import cucumber.runtime.CucumberException;
import cucumber.runtime.formatter.TestSourcesModel;
import cucumber.runtime.formatter.URLOutputStream;
import gherkin.ast.Background;
import gherkin.ast.DataTable;
import gherkin.ast.DocString;
import gherkin.ast.Examples;
import gherkin.ast.Feature;
import gherkin.ast.Node;
import gherkin.ast.ScenarioDefinition;
import gherkin.ast.ScenarioOutline;
import gherkin.ast.Step;
import gherkin.ast.TableCell;
import gherkin.ast.TableRow;
import gherkin.ast.Tag;
import gherkin.deps.com.google.gson.Gson;
import gherkin.deps.com.google.gson.GsonBuilder;
import gherkin.pickles.Argument;
import gherkin.pickles.PickleCell;
import gherkin.pickles.PickleRow;
import gherkin.pickles.PickleString;
import gherkin.pickles.PickleTable;
import gherkin.pickles.PickleTag;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class HTMLFormatter
implements EventListener {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static final String JS_FORMATTER_VAR = "formatter";
    private static final String JS_REPORT_FILENAME = "report.js";
    private static final String[] TEXT_ASSETS = new String[]{"/io/cucumber/formatter/html/formatter.js", "/io/cucumber/formatter/html/index.html", "/io/cucumber/formatter/html/jquery-3.4.1.min.js", "/io/cucumber/formatter/html/style.css"};
    private static final Map<String, String> MIME_TYPES_EXTENSIONS = new HashMap<String, String>(){
        {
            this.put("image/bmp", "bmp");
            this.put("image/gif", "gif");
            this.put("image/jpeg", "jpg");
            this.put("image/png", "png");
            this.put("image/svg+xml", "svg");
            this.put("video/ogg", "ogg");
        }
    };
    private final TestSourcesModel testSources = new TestSourcesModel();
    private final URL htmlReportDir;
    private NiceAppendable jsOut;
    private boolean firstFeature = true;
    private String currentFeatureFile;
    private Map<String, Object> currentTestCaseMap;
    private ScenarioOutline currentScenarioOutline;
    private Examples currentExamples;
    private int embeddedIndex;
    private EventHandler<TestSourceRead> testSourceReadHandler = new EventHandler<TestSourceRead>(){

        @Override
        public void receive(TestSourceRead event) {
            HTMLFormatter.this.handleTestSourceRead(event);
        }
    };
    private EventHandler<TestCaseStarted> caseStartedHandler = new EventHandler<TestCaseStarted>(){

        @Override
        public void receive(TestCaseStarted event) {
            HTMLFormatter.this.handleTestCaseStarted(event);
        }
    };
    private EventHandler<TestStepStarted> stepStartedHandler = new EventHandler<TestStepStarted>(){

        @Override
        public void receive(TestStepStarted event) {
            HTMLFormatter.this.handleTestStepStarted(event);
        }
    };
    private EventHandler<TestStepFinished> stepFinishedHandler = new EventHandler<TestStepFinished>(){

        @Override
        public void receive(TestStepFinished event) {
            HTMLFormatter.this.handleTestStepFinished(event);
        }
    };
    private EventHandler<EmbedEvent> embedEventhandler = new EventHandler<EmbedEvent>(){

        @Override
        public void receive(EmbedEvent event) {
            HTMLFormatter.this.handleEmbed(event);
        }
    };
    private EventHandler<WriteEvent> writeEventhandler = new EventHandler<WriteEvent>(){

        @Override
        public void receive(WriteEvent event) {
            HTMLFormatter.this.handleWrite(event);
        }
    };
    private EventHandler<TestRunFinished> runFinishedHandler = new EventHandler<TestRunFinished>(){

        @Override
        public void receive(TestRunFinished event) {
            HTMLFormatter.this.finishReport();
        }
    };

    public HTMLFormatter(URL htmlReportDir) {
        this(htmlReportDir, HTMLFormatter.createJsOut(htmlReportDir));
    }

    HTMLFormatter(URL htmlReportDir, NiceAppendable jsOut) {
        this.htmlReportDir = htmlReportDir;
        this.jsOut = jsOut;
    }

    @Override
    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestSourceRead.class, this.testSourceReadHandler);
        publisher.registerHandlerFor(TestCaseStarted.class, this.caseStartedHandler);
        publisher.registerHandlerFor(TestStepStarted.class, this.stepStartedHandler);
        publisher.registerHandlerFor(TestStepFinished.class, this.stepFinishedHandler);
        publisher.registerHandlerFor(EmbedEvent.class, this.embedEventhandler);
        publisher.registerHandlerFor(WriteEvent.class, this.writeEventhandler);
        publisher.registerHandlerFor(TestRunFinished.class, this.runFinishedHandler);
    }

    private void handleTestSourceRead(TestSourceRead event) {
        this.testSources.addTestSourceReadEvent(event.uri, event);
    }

    private void handleTestCaseStarted(TestCaseStarted event) {
        if (this.firstFeature) {
            this.jsOut.append("$(document).ready(function() {").append("var ").append(JS_FORMATTER_VAR).append(" = new CucumberHTML.DOMFormatter($('.cucumber-report'));");
            this.firstFeature = false;
        }
        this.handleStartOfFeature(event.testCase);
        this.handleScenarioOutline(event.testCase);
        this.currentTestCaseMap = this.createTestCase(event.testCase);
        if (this.testSources.hasBackground(this.currentFeatureFile, event.testCase.getLine())) {
            this.jsFunctionCall("background", this.createBackground(event.testCase));
        } else {
            this.jsFunctionCall("scenario", this.currentTestCaseMap);
            this.currentTestCaseMap = null;
        }
    }

    private void handleTestStepStarted(TestStepStarted event) {
        if (event.testStep instanceof PickleStepTestStep) {
            PickleStepTestStep testStep = (PickleStepTestStep)event.testStep;
            if (this.isFirstStepAfterBackground(testStep)) {
                this.jsFunctionCall("scenario", this.currentTestCaseMap);
                this.currentTestCaseMap = null;
            }
            this.jsFunctionCall("step", this.createTestStep(testStep));
            this.jsFunctionCall("match", this.createMatchMap((PickleStepTestStep)event.testStep));
        }
    }

    private void handleTestStepFinished(TestStepFinished event) {
        if (event.testStep instanceof PickleStepTestStep) {
            this.jsFunctionCall("result", this.createResultMap(event.result));
        } else if (event.testStep instanceof HookTestStep) {
            HookTestStep hookTestStep = (HookTestStep)event.testStep;
            this.jsFunctionCall(hookTestStep.getHookType().toString(), this.createResultMap(event.result));
        } else {
            throw new IllegalStateException();
        }
    }

    private void handleEmbed(EmbedEvent event) {
        String mimeType = event.mimeType;
        if (mimeType.startsWith("text/")) {
            this.jsFunctionCall("embedding", mimeType, new String(event.data), event.name);
        } else {
            String extension = MIME_TYPES_EXTENSIONS.get(mimeType);
            if (extension != null) {
                StringBuilder fileName = new StringBuilder("embedded").append(this.embeddedIndex++).append(".").append(extension);
                HTMLFormatter.writeBytesToURL(event.data, this.toUrl(fileName.toString()));
                this.jsFunctionCall("embedding", mimeType, fileName, event.name);
            }
        }
    }

    private void handleWrite(WriteEvent event) {
        this.jsFunctionCall("write", event.text);
    }

    private void finishReport() {
        if (!this.firstFeature) {
            this.jsOut.append("});");
            this.copyReportFiles();
        }
        this.jsOut.close();
    }

    private void handleStartOfFeature(TestCase testCase) {
        if (this.currentFeatureFile == null || !this.currentFeatureFile.equals(testCase.getUri())) {
            this.currentFeatureFile = testCase.getUri();
            this.jsFunctionCall("uri", this.currentFeatureFile);
            this.jsFunctionCall("feature", this.createFeature(testCase));
        }
    }

    private Map<String, Object> createFeature(TestCase testCase) {
        HashMap<String, Object> featureMap = new HashMap<String, Object>();
        Feature feature = this.testSources.getFeature(testCase.getUri());
        if (feature != null) {
            featureMap.put("keyword", feature.getKeyword());
            featureMap.put("name", feature.getName());
            featureMap.put("description", feature.getDescription() != null ? feature.getDescription() : "");
            if (!feature.getTags().isEmpty()) {
                featureMap.put("tags", this.createTagList(feature.getTags()));
            }
        }
        return featureMap;
    }

    private List<Map<String, Object>> createTagList(List<Tag> tags) {
        ArrayList<Map<String, Object>> tagList = new ArrayList<Map<String, Object>>();
        for (Tag tag : tags) {
            HashMap<String, String> tagMap = new HashMap<String, String>();
            tagMap.put("name", tag.getName());
            tagList.add(tagMap);
        }
        return tagList;
    }

    private void handleScenarioOutline(TestCase testCase) {
        TestSourcesModel.AstNode astNode = this.testSources.getAstNode(this.currentFeatureFile, testCase.getLine());
        if (TestSourcesModel.isScenarioOutlineScenario(astNode)) {
            ScenarioOutline scenarioOutline = (ScenarioOutline)TestSourcesModel.getScenarioDefinition(astNode);
            if (this.currentScenarioOutline == null || !this.currentScenarioOutline.equals(scenarioOutline)) {
                this.currentScenarioOutline = scenarioOutline;
                this.jsFunctionCall("scenarioOutline", this.createScenarioOutline(this.currentScenarioOutline));
                this.addOutlineStepsToReport(scenarioOutline);
            }
            Examples examples = (Examples)astNode.parent.node;
            if (this.currentExamples == null || !this.currentExamples.equals(examples)) {
                this.currentExamples = examples;
                this.jsFunctionCall("examples", this.createExamples(this.currentExamples));
            }
        } else {
            this.currentScenarioOutline = null;
            this.currentExamples = null;
        }
    }

    private Map<String, Object> createScenarioOutline(ScenarioOutline scenarioOutline) {
        HashMap<String, Object> scenarioOutlineMap = new HashMap<String, Object>();
        scenarioOutlineMap.put("name", scenarioOutline.getName());
        scenarioOutlineMap.put("keyword", scenarioOutline.getKeyword());
        scenarioOutlineMap.put("description", scenarioOutline.getDescription() != null ? scenarioOutline.getDescription() : "");
        if (!scenarioOutline.getTags().isEmpty()) {
            scenarioOutlineMap.put("tags", this.createTagList(scenarioOutline.getTags()));
        }
        return scenarioOutlineMap;
    }

    private void addOutlineStepsToReport(ScenarioOutline scenarioOutline) {
        for (Step step : scenarioOutline.getSteps()) {
            HashMap<String, Object> stepMap = new HashMap<String, Object>();
            stepMap.put("name", step.getText());
            stepMap.put("keyword", step.getKeyword());
            if (step.getArgument() != null) {
                Node argument = step.getArgument();
                if (argument instanceof DocString) {
                    stepMap.put("doc_string", this.createDocStringMap((DocString)argument));
                } else if (argument instanceof DataTable) {
                    stepMap.put("rows", this.createDataTableList((DataTable)argument));
                }
            }
            this.jsFunctionCall("step", stepMap);
        }
    }

    private Map<String, Object> createDocStringMap(DocString docString) {
        HashMap<String, Object> docStringMap = new HashMap<String, Object>();
        docStringMap.put("value", docString.getContent());
        return docStringMap;
    }

    private List<Map<String, Object>> createDataTableList(DataTable dataTable) {
        ArrayList<Map<String, Object>> rowList = new ArrayList<Map<String, Object>>();
        for (TableRow row : dataTable.getRows()) {
            rowList.add(this.createRowMap(row));
        }
        return rowList;
    }

    private Map<String, Object> createRowMap(TableRow row) {
        HashMap<String, Object> rowMap = new HashMap<String, Object>();
        rowMap.put("cells", this.createCellList(row));
        return rowMap;
    }

    private List<String> createCellList(TableRow row) {
        ArrayList<String> cells = new ArrayList<String>();
        for (TableCell cell : row.getCells()) {
            cells.add(cell.getValue());
        }
        return cells;
    }

    private Map<String, Object> createExamples(Examples examples) {
        HashMap<String, Object> examplesMap = new HashMap<String, Object>();
        examplesMap.put("name", examples.getName());
        examplesMap.put("keyword", examples.getKeyword());
        examplesMap.put("description", examples.getDescription() != null ? examples.getDescription() : "");
        ArrayList<Map<String, Object>> rowList = new ArrayList<Map<String, Object>>();
        rowList.add(this.createRowMap(examples.getTableHeader()));
        for (TableRow row : examples.getTableBody()) {
            rowList.add(this.createRowMap(row));
        }
        examplesMap.put("rows", rowList);
        if (!examples.getTags().isEmpty()) {
            examplesMap.put("tags", this.createTagList(examples.getTags()));
        }
        return examplesMap;
    }

    private Map<String, Object> createTestCase(TestCase testCase) {
        HashMap<String, Object> testCaseMap = new HashMap<String, Object>();
        testCaseMap.put("name", testCase.getName());
        TestSourcesModel.AstNode astNode = this.testSources.getAstNode(this.currentFeatureFile, testCase.getLine());
        if (astNode != null) {
            ScenarioDefinition scenarioDefinition = TestSourcesModel.getScenarioDefinition(astNode);
            testCaseMap.put("keyword", scenarioDefinition.getKeyword());
            testCaseMap.put("description", scenarioDefinition.getDescription() != null ? scenarioDefinition.getDescription() : "");
        }
        if (!testCase.getTags().isEmpty()) {
            ArrayList tagList = new ArrayList();
            for (PickleTag tag : testCase.getTags()) {
                HashMap<String, String> tagMap = new HashMap<String, String>();
                tagMap.put("name", tag.getName());
                tagList.add(tagMap);
            }
            testCaseMap.put("tags", tagList);
        }
        return testCaseMap;
    }

    private Map<String, Object> createBackground(TestCase testCase) {
        TestSourcesModel.AstNode astNode = this.testSources.getAstNode(this.currentFeatureFile, testCase.getLine());
        if (astNode != null) {
            Background background = TestSourcesModel.getBackgroundForTestCase(astNode);
            HashMap<String, Object> testCaseMap = new HashMap<String, Object>();
            testCaseMap.put("name", background.getName());
            testCaseMap.put("keyword", background.getKeyword());
            testCaseMap.put("description", background.getDescription() != null ? background.getDescription() : "");
            return testCaseMap;
        }
        return null;
    }

    private boolean isFirstStepAfterBackground(PickleStepTestStep testStep) {
        TestSourcesModel.AstNode astNode = this.testSources.getAstNode(this.currentFeatureFile, testStep.getStepLine());
        return astNode != null && this.currentTestCaseMap != null && !TestSourcesModel.isBackgroundStep(astNode);
    }

    private Map<String, Object> createTestStep(PickleStepTestStep testStep) {
        TestSourcesModel.AstNode astNode;
        HashMap<String, Object> stepMap = new HashMap<String, Object>();
        stepMap.put("name", testStep.getStepText());
        if (!testStep.getStepArgument().isEmpty()) {
            Argument argument = testStep.getStepArgument().get(0);
            if (argument instanceof PickleString) {
                stepMap.put("doc_string", this.createDocStringMap((PickleString)argument));
            } else if (argument instanceof PickleTable) {
                stepMap.put("rows", this.createDataTableList((PickleTable)argument));
            }
        }
        if ((astNode = this.testSources.getAstNode(this.currentFeatureFile, testStep.getStepLine())) != null) {
            Step step = (Step)astNode.node;
            stepMap.put("keyword", step.getKeyword());
        }
        return stepMap;
    }

    private Map<String, Object> createDocStringMap(PickleString docString) {
        HashMap<String, Object> docStringMap = new HashMap<String, Object>();
        docStringMap.put("value", docString.getContent());
        return docStringMap;
    }

    private List<Map<String, Object>> createDataTableList(PickleTable dataTable) {
        ArrayList<Map<String, Object>> rowList = new ArrayList<Map<String, Object>>();
        for (PickleRow row : dataTable.getRows()) {
            rowList.add(this.createRowMap(row));
        }
        return rowList;
    }

    private Map<String, Object> createRowMap(PickleRow row) {
        HashMap<String, Object> rowMap = new HashMap<String, Object>();
        rowMap.put("cells", this.createCellList(row));
        return rowMap;
    }

    private List<String> createCellList(PickleRow row) {
        ArrayList<String> cells = new ArrayList<String>();
        for (PickleCell cell : row.getCells()) {
            cells.add(cell.getValue());
        }
        return cells;
    }

    private Map<String, Object> createMatchMap(PickleStepTestStep testStep) {
        HashMap<String, Object> matchMap = new HashMap<String, Object>();
        String location = testStep.getCodeLocation();
        if (location != null) {
            matchMap.put("location", location);
        }
        return matchMap;
    }

    private Map<String, Object> createResultMap(Result result) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("status", result.getStatus().lowerCaseName());
        if (result.getErrorMessage() != null) {
            resultMap.put("error_message", result.getErrorMessage());
        }
        return resultMap;
    }

    private void jsFunctionCall(String functionName, Object ... args) {
        NiceAppendable out = this.jsOut.append("formatter.").append(functionName).append("(");
        boolean comma = false;
        for (Object arg : args) {
            if (comma) {
                out.append(", ");
            }
            gson.toJson(arg, (Appendable)out);
            comma = true;
        }
        out.append(");").println();
    }

    private void copyReportFiles() {
        if (this.htmlReportDir == null) {
            return;
        }
        for (String textAsset : TEXT_ASSETS) {
            InputStream textAssetStream = this.getClass().getResourceAsStream(textAsset);
            if (textAssetStream == null) {
                throw new CucumberException("Couldn't find " + textAsset + ". Is cucumber-html on your classpath? Make sure you have the right version.");
            }
            String fileName = new File(textAsset).getName();
            HTMLFormatter.writeStreamToURL(textAssetStream, this.toUrl(fileName));
        }
    }

    private URL toUrl(String fileName) {
        try {
            return new URL(this.htmlReportDir, fileName);
        }
        catch (IOException e) {
            throw new CucumberException(e);
        }
    }

    private static void writeStreamToURL(InputStream in, URL url) {
        OutputStream out = HTMLFormatter.createReportFileOutputStream(url);
        byte[] buffer = new byte[16384];
        try {
            int len = in.read(buffer);
            while (len != -1) {
                out.write(buffer, 0, len);
                len = in.read(buffer);
            }
        }
        catch (IOException e) {
            throw new CucumberException("Unable to write to report file item: ", e);
        }
        finally {
            HTMLFormatter.closeQuietly(out);
        }
    }

    private static void writeBytesToURL(byte[] buf, URL url) throws CucumberException {
        OutputStream out = HTMLFormatter.createReportFileOutputStream(url);
        try {
            out.write(buf);
        }
        catch (IOException e) {
            throw new CucumberException("Unable to write to report file item: ", e);
        }
        finally {
            HTMLFormatter.closeQuietly(out);
        }
    }

    private static NiceAppendable createJsOut(URL htmlReportDir) {
        try {
            return new NiceAppendable(new OutputStreamWriter(HTMLFormatter.createReportFileOutputStream(new URL(htmlReportDir, JS_REPORT_FILENAME)), "UTF-8"));
        }
        catch (IOException e) {
            throw new CucumberException(e);
        }
    }

    private static OutputStream createReportFileOutputStream(URL url) {
        try {
            return new URLOutputStream(url);
        }
        catch (IOException e) {
            throw new CucumberException(e);
        }
    }

    private static void closeQuietly(Closeable out) {
        try {
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

