/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.options;

import io.cucumber.core.exception.CucumberException;
import io.cucumber.core.feature.GluePath;
import io.cucumber.core.logging.Logger;
import io.cucumber.core.logging.LoggerFactory;
import io.cucumber.core.options.BooleanString;
import io.cucumber.core.options.Constants;
import io.cucumber.core.options.CucumberPropertiesProvider;
import io.cucumber.core.options.FeatureWithLinesOrRerunPath;
import io.cucumber.core.options.ObjectFactoryParser;
import io.cucumber.core.options.PickleOrderParser;
import io.cucumber.core.options.RuntimeOptionsBuilder;
import io.cucumber.core.options.SnippetTypeParser;
import io.cucumber.core.options.UuidGeneratorParser;
import io.cucumber.tagexpressions.TagExpressionParser;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class CucumberPropertiesParser {
    private static final Logger log = LoggerFactory.getLogger(CucumberPropertiesParser.class);

    public RuntimeOptionsBuilder parse(Map<String, String> properties) {
        return this.parse(properties::get);
    }

    public RuntimeOptionsBuilder parse(CucumberPropertiesProvider properties) {
        RuntimeOptionsBuilder builder = new RuntimeOptionsBuilder();
        this.parse(properties, "cucumber.ansi-colors.disabled", BooleanString::parseBoolean, builder::setMonochrome);
        this.parse(properties, "cucumber.execution.dry-run", BooleanString::parseBoolean, builder::setDryRun);
        this.parse(properties, "cucumber.execution.limit", Integer::parseInt, builder::setCount);
        this.parse(properties, "cucumber.execution.order", PickleOrderParser::parse, builder::setPickleOrder);
        this.parseAll(properties, "cucumber.features", CucumberPropertiesParser.splitAndMap(FeatureWithLinesOrRerunPath::parse), parsed -> {
            parsed.getFeaturesToRerun().ifPresent(builder::addRerun);
            parsed.getFeatureWithLines().ifPresent(builder::addFeature);
        });
        this.parse(properties, "cucumber.filter.name", Pattern::compile, builder::addNameFilter);
        this.parse(properties, "cucumber.filter.tags", TagExpressionParser::parse, builder::addTagFilter);
        this.parseAll(properties, "cucumber.glue", CucumberPropertiesParser.splitAndMap(GluePath::parse), builder::addGlue);
        this.parse(properties, "cucumber.object-factory", ObjectFactoryParser::parseObjectFactory, builder::setObjectFactoryClass);
        this.parse(properties, "cucumber.uuid-generator", UuidGeneratorParser::parseUuidGenerator, builder::setUuidGeneratorClass);
        this.parse(properties, "cucumber.options", Function.identity(), CucumberPropertiesParser.warnWhenCucumberOptionsIsUsed());
        this.parseAll(properties, "cucumber.plugin", CucumberPropertiesParser.splitAndMap(Function.identity()), builder::addPluginName);
        this.parse(properties, "cucumber.publish.token", Function.identity(), builder::setPublishToken);
        this.parse(properties, "cucumber.publish.enabled", BooleanString::parseBoolean, builder::setPublish);
        this.parse(properties, "cucumber.publish.quiet", BooleanString::parseBoolean, builder::setPublishQuiet);
        this.parse(properties, "cucumber.snippet-type", SnippetTypeParser::parseSnippetType, builder::setSnippetType);
        this.parse(properties, "cucumber.execution.wip", BooleanString::parseBoolean, builder::setWip);
        return builder;
    }

    private static Consumer<String> warnWhenCucumberOptionsIsUsed() {
        return commandLineOptions -> log.warn(() -> String.format("Passing commandline options via the property '%s' is no longer supported. Please use individual properties instead. See the java doc on %s for details.", "cucumber.options", Constants.class.getName()));
    }

    private <T> void parse(CucumberPropertiesProvider properties, String propertyName, Function<String, T> parser, Consumer<T> setter) {
        this.parseAll(properties, propertyName, parser.andThen(Collections::singletonList), setter);
    }

    private <T> void parseAll(CucumberPropertiesProvider properties, String propertyName, Function<String, Collection<T>> parser, Consumer<T> setter) {
        String property = properties.get(propertyName);
        if (property == null || property.isEmpty()) {
            return;
        }
        try {
            Collection<T> parsed = parser.apply(property);
            parsed.forEach(setter);
        }
        catch (Exception e) {
            throw new CucumberException("Failed to parse '" + propertyName + "' with value '" + property + "'", e);
        }
    }

    private static <T> Function<String, Collection<T>> splitAndMap(Function<String, T> parse) {
        return combined -> Arrays.stream(combined.split(",")).map(String::trim).filter(part -> !part.isEmpty()).map(parse).collect(Collectors.toList());
    }
}

