/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.gherkin.messages;

import io.cucumber.core.gherkin.Argument;
import io.cucumber.core.gherkin.Step;
import io.cucumber.core.gherkin.StepType;
import io.cucumber.core.gherkin.messages.GherkinMessagesDataTableArgument;
import io.cucumber.core.gherkin.messages.GherkinMessagesDocStringArgument;
import io.cucumber.core.gherkin.messages.GherkinMessagesLocation;
import io.cucumber.core.gherkin.messages.internal.gherkin.GherkinDialect;
import io.cucumber.messages.Messages;
import io.cucumber.plugin.event.Location;

final class GherkinMessagesStep
implements Step {
    private final Messages.Pickle.PickleStep pickleStep;
    private final Argument argument;
    private final String keyWord;
    private final StepType stepType;
    private final String previousGwtKeyWord;
    private final Messages.Location location;

    GherkinMessagesStep(Messages.Pickle.PickleStep pickleStep, GherkinDialect dialect, String previousGwtKeyWord, Messages.Location location, String keyword) {
        this.pickleStep = pickleStep;
        this.argument = GherkinMessagesStep.extractArgument(pickleStep, location);
        this.keyWord = keyword;
        this.stepType = GherkinMessagesStep.extractKeyWordType(this.keyWord, dialect);
        this.previousGwtKeyWord = previousGwtKeyWord;
        this.location = location;
    }

    private static Argument extractArgument(Messages.Pickle.PickleStep pickleStep, Messages.Location location) {
        Messages.PickleStepArgument argument = pickleStep.getArgument();
        if (argument.hasDocString()) {
            Messages.PickleStepArgument.PickleDocString docString = argument.getDocString();
            return new GherkinMessagesDocStringArgument(docString, location.getLine() + 1);
        }
        if (argument.hasDataTable()) {
            Messages.PickleStepArgument.PickleTable table = argument.getDataTable();
            return new GherkinMessagesDataTableArgument(table, location.getLine() + 1);
        }
        return null;
    }

    private static StepType extractKeyWordType(String keyWord, GherkinDialect dialect) {
        if (StepType.isAstrix((String)keyWord)) {
            return StepType.OTHER;
        }
        if (dialect.getGivenKeywords().contains(keyWord)) {
            return StepType.GIVEN;
        }
        if (dialect.getWhenKeywords().contains(keyWord)) {
            return StepType.WHEN;
        }
        if (dialect.getThenKeywords().contains(keyWord)) {
            return StepType.THEN;
        }
        if (dialect.getAndKeywords().contains(keyWord)) {
            return StepType.AND;
        }
        if (dialect.getButKeywords().contains(keyWord)) {
            return StepType.BUT;
        }
        throw new IllegalStateException("Keyword " + keyWord + " was neither given, when, then, and, but nor *");
    }

    public String getKeyword() {
        return this.keyWord;
    }

    public int getLine() {
        return this.location.getLine();
    }

    public Location getLocation() {
        return GherkinMessagesLocation.from(this.location);
    }

    public StepType getType() {
        return this.stepType;
    }

    public String getPreviousGivenWhenThenKeyword() {
        return this.previousGwtKeyWord;
    }

    public String getId() {
        return this.pickleStep.getId();
    }

    public Argument getArgument() {
        return this.argument;
    }

    public String getText() {
        return this.pickleStep.getText();
    }
}

