/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.gherkin.vintage.internal.gherkin;

import io.cucumber.core.gherkin.vintage.internal.gherkin.AstNode;
import io.cucumber.core.gherkin.vintage.internal.gherkin.GherkinLineSpan;
import io.cucumber.core.gherkin.vintage.internal.gherkin.Parser;
import io.cucumber.core.gherkin.vintage.internal.gherkin.ParserException;
import io.cucumber.core.gherkin.vintage.internal.gherkin.StringUtils;
import io.cucumber.core.gherkin.vintage.internal.gherkin.Token;
import io.cucumber.core.gherkin.vintage.internal.gherkin.ast.Background;
import io.cucumber.core.gherkin.vintage.internal.gherkin.ast.Comment;
import io.cucumber.core.gherkin.vintage.internal.gherkin.ast.DataTable;
import io.cucumber.core.gherkin.vintage.internal.gherkin.ast.DocString;
import io.cucumber.core.gherkin.vintage.internal.gherkin.ast.Examples;
import io.cucumber.core.gherkin.vintage.internal.gherkin.ast.Feature;
import io.cucumber.core.gherkin.vintage.internal.gherkin.ast.GherkinDocument;
import io.cucumber.core.gherkin.vintage.internal.gherkin.ast.Location;
import io.cucumber.core.gherkin.vintage.internal.gherkin.ast.Node;
import io.cucumber.core.gherkin.vintage.internal.gherkin.ast.Scenario;
import io.cucumber.core.gherkin.vintage.internal.gherkin.ast.ScenarioDefinition;
import io.cucumber.core.gherkin.vintage.internal.gherkin.ast.ScenarioOutline;
import io.cucumber.core.gherkin.vintage.internal.gherkin.ast.Step;
import io.cucumber.core.gherkin.vintage.internal.gherkin.ast.TableCell;
import io.cucumber.core.gherkin.vintage.internal.gherkin.ast.TableRow;
import io.cucumber.core.gherkin.vintage.internal.gherkin.ast.Tag;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;

public class AstBuilder
implements Parser.Builder<GherkinDocument> {
    private Deque<AstNode> stack;
    private List<Comment> comments;

    public AstBuilder() {
        this.reset();
    }

    @Override
    public void reset() {
        this.stack = new ArrayDeque<AstNode>();
        this.stack.push(new AstNode(Parser.RuleType.None));
        this.comments = new ArrayList<Comment>();
    }

    private AstNode currentNode() {
        return this.stack.peek();
    }

    @Override
    public void build(Token token) {
        Parser.RuleType ruleType = Parser.RuleType.cast(token.matchedType);
        if (token.matchedType == Parser.TokenType.Comment) {
            this.comments.add(new Comment(this.getLocation(token, 0), token.matchedText));
        } else {
            this.currentNode().add(ruleType, token);
        }
    }

    @Override
    public void startRule(Parser.RuleType ruleType) {
        this.stack.push(new AstNode(ruleType));
    }

    @Override
    public void endRule(Parser.RuleType ruleType) {
        AstNode node = this.stack.pop();
        Object transformedNode = this.getTransformedNode(node);
        this.currentNode().add(node.ruleType, transformedNode);
    }

    private Object getTransformedNode(AstNode node) {
        switch (node.ruleType) {
            case Step: {
                Token stepLine = node.getToken(Parser.TokenType.StepLine);
                Node stepArg = node.getSingle(Parser.RuleType.DataTable, null);
                if (stepArg == null) {
                    stepArg = node.getSingle(Parser.RuleType.DocString, null);
                }
                return new Step(this.getLocation(stepLine, 0), stepLine.matchedKeyword, stepLine.matchedText, stepArg);
            }
            case DocString: {
                Token separatorToken = node.getTokens(Parser.TokenType.DocStringSeparator).get(0);
                String contentType = separatorToken.matchedText.length() > 0 ? separatorToken.matchedText : null;
                List<Token> lineTokens = node.getTokens(Parser.TokenType.Other);
                StringBuilder content = new StringBuilder();
                boolean newLine = false;
                for (Token lineToken : lineTokens) {
                    if (newLine) {
                        content.append("\n");
                    }
                    newLine = true;
                    content.append(lineToken.matchedText);
                }
                return new DocString(this.getLocation(separatorToken, 0), contentType, content.toString());
            }
            case DataTable: {
                List<TableRow> rows = this.getTableRows(node);
                return new DataTable(rows);
            }
            case Background: {
                Token backgroundLine = node.getToken(Parser.TokenType.BackgroundLine);
                String description = this.getDescription(node);
                List<Step> steps = this.getSteps(node);
                return new Background(this.getLocation(backgroundLine, 0), backgroundLine.matchedKeyword, backgroundLine.matchedText, description, steps);
            }
            case Scenario_Definition: {
                List<Tag> tags = this.getTags(node);
                AstNode scenarioNode = node.getSingle(Parser.RuleType.Scenario, null);
                if (scenarioNode != null) {
                    Token scenarioLine = scenarioNode.getToken(Parser.TokenType.ScenarioLine);
                    String description = this.getDescription(scenarioNode);
                    List<Step> steps = this.getSteps(scenarioNode);
                    return new Scenario(tags, this.getLocation(scenarioLine, 0), scenarioLine.matchedKeyword, scenarioLine.matchedText, description, steps);
                }
                AstNode scenarioOutlineNode = node.getSingle(Parser.RuleType.ScenarioOutline, null);
                if (scenarioOutlineNode == null) {
                    throw new RuntimeException("Internal grammar error");
                }
                Token scenarioOutlineLine = scenarioOutlineNode.getToken(Parser.TokenType.ScenarioOutlineLine);
                String description = this.getDescription(scenarioOutlineNode);
                List<Step> steps = this.getSteps(scenarioOutlineNode);
                List<Examples> examplesList = scenarioOutlineNode.getItems(Parser.RuleType.Examples_Definition);
                return new ScenarioOutline(tags, this.getLocation(scenarioOutlineLine, 0), scenarioOutlineLine.matchedKeyword, scenarioOutlineLine.matchedText, description, steps, examplesList);
            }
            case Examples_Definition: {
                List<Tag> tags = this.getTags(node);
                AstNode examplesNode = node.getSingle(Parser.RuleType.Examples, null);
                Token examplesLine = examplesNode.getToken(Parser.TokenType.ExamplesLine);
                String description = this.getDescription(examplesNode);
                List rows = examplesNode.getSingle(Parser.RuleType.Examples_Table, null);
                TableRow tableHeader = rows != null && !rows.isEmpty() ? (TableRow)rows.get(0) : null;
                List<TableRow> tableBody = rows != null && !rows.isEmpty() ? rows.subList(1, rows.size()) : null;
                return new Examples(this.getLocation(examplesLine, 0), tags, examplesLine.matchedKeyword, examplesLine.matchedText, description, tableHeader, tableBody);
            }
            case Examples_Table: {
                return this.getTableRows(node);
            }
            case Description: {
                int end;
                List<Token> lineTokens = node.getTokens(Parser.TokenType.Other);
                for (end = lineTokens.size(); end > 0 && lineTokens.get((int)(end - 1)).matchedText.matches("\\s*"); --end) {
                }
                lineTokens = lineTokens.subList(0, end);
                return StringUtils.join(new StringUtils.ToString<Token>(){

                    @Override
                    public String toString(Token t) {
                        return t.matchedText;
                    }
                }, "\n", lineTokens);
            }
            case Feature: {
                AstNode header = node.getSingle(Parser.RuleType.Feature_Header, new AstNode(Parser.RuleType.Feature_Header));
                if (header == null) {
                    return null;
                }
                List<Tag> tags = this.getTags(header);
                Token featureLine = header.getToken(Parser.TokenType.FeatureLine);
                if (featureLine == null) {
                    return null;
                }
                ArrayList<ScenarioDefinition> scenarioDefinitions = new ArrayList<ScenarioDefinition>();
                Background background = node.getSingle(Parser.RuleType.Background, null);
                if (background != null) {
                    scenarioDefinitions.add(background);
                }
                scenarioDefinitions.addAll(node.getItems(Parser.RuleType.Scenario_Definition));
                String description = this.getDescription(header);
                if (featureLine.matchedGherkinDialect == null) {
                    return null;
                }
                String language = featureLine.matchedGherkinDialect.getLanguage();
                return new Feature(tags, this.getLocation(featureLine, 0), language, featureLine.matchedKeyword, featureLine.matchedText, description, scenarioDefinitions);
            }
            case GherkinDocument: {
                Feature feature = node.getSingle(Parser.RuleType.Feature, null);
                return new GherkinDocument(feature, this.comments);
            }
        }
        return node;
    }

    private List<TableRow> getTableRows(AstNode node) {
        ArrayList<TableRow> rows = new ArrayList<TableRow>();
        for (Token token : node.getTokens(Parser.TokenType.TableRow)) {
            rows.add(new TableRow(this.getLocation(token, 0), this.getCells(token)));
        }
        this.ensureCellCount(rows);
        return rows;
    }

    private void ensureCellCount(List<TableRow> rows) {
        if (rows.isEmpty()) {
            return;
        }
        int cellCount = rows.get(0).getCells().size();
        for (TableRow row : rows) {
            if (row.getCells().size() == cellCount) continue;
            throw new ParserException.AstBuilderException("inconsistent cell count within the table", row.getLocation());
        }
    }

    private List<TableCell> getCells(Token token) {
        ArrayList<TableCell> cells = new ArrayList<TableCell>();
        for (GherkinLineSpan cellItem : token.mathcedItems) {
            cells.add(new TableCell(this.getLocation(token, cellItem.column), cellItem.text));
        }
        return cells;
    }

    private List<Step> getSteps(AstNode node) {
        return node.getItems(Parser.RuleType.Step);
    }

    private Location getLocation(Token token, int column) {
        return column == 0 ? token.location : new Location(token.location.getLine(), column);
    }

    private String getDescription(AstNode node) {
        return node.getSingle(Parser.RuleType.Description, null);
    }

    private List<Tag> getTags(AstNode node) {
        AstNode tagsNode = node.getSingle(Parser.RuleType.Tags, new AstNode(Parser.RuleType.None));
        if (tagsNode == null) {
            return new ArrayList<Tag>();
        }
        List<Token> tokens = tagsNode.getTokens(Parser.TokenType.TagLine);
        ArrayList<Tag> tags = new ArrayList<Tag>();
        for (Token token : tokens) {
            for (GherkinLineSpan tagItem : token.mathcedItems) {
                tags.add(new Tag(this.getLocation(token, tagItem.column), tagItem.text));
            }
        }
        return tags;
    }

    @Override
    public GherkinDocument getResult() {
        return this.currentNode().getSingle(Parser.RuleType.GherkinDocument, null);
    }
}

