/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.gherkin.vintage;

import io.cucumber.core.gherkin.DataTableArgument;
import io.cucumber.core.gherkin.vintage.internal.gherkin.pickles.PickleTable;
import java.util.AbstractList;
import java.util.List;

final class GherkinVintageDataTableArgument
implements DataTableArgument {
    private final CellView cells;
    private final int line;

    GherkinVintageDataTableArgument(PickleTable table, int lineHint) {
        this.cells = new CellView(table);
        this.line = table.getRows().size() > 0 && table.getRows().get(0).getCells().size() > 0 ? table.getLocation().getLine() : lineHint;
    }

    public List<List<String>> cells() {
        return this.cells;
    }

    public int getLine() {
        return this.line;
    }

    private static class CellView
    extends AbstractList<List<String>> {
        private final PickleTable table;

        CellView(PickleTable table) {
            this.table = table;
        }

        @Override
        public List<String> get(final int row) {
            return new AbstractList<String>(){

                @Override
                public String get(int column) {
                    return table.getRows().get(row).getCells().get(column).getValue();
                }

                @Override
                public int size() {
                    return table.getRows().get(row).getCells().size();
                }
            };
        }

        @Override
        public int size() {
            return this.table.getRows().size();
        }
    }
}

