/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.gherkin.vintage;

import io.cucumber.core.gherkin.Example;
import io.cucumber.core.gherkin.Location;
import io.cucumber.core.gherkin.vintage.GherkinVintageExample;
import io.cucumber.core.gherkin.vintage.GherkinVintageLocation;
import io.cucumber.core.gherkin.vintage.internal.gherkin.ast.Examples;
import io.cucumber.core.gherkin.vintage.internal.gherkin.ast.TableRow;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

final class GherkinVintageExamples
implements io.cucumber.core.gherkin.Examples {
    private final List<Example> children;
    private final Examples examples;

    GherkinVintageExamples(Examples examples) {
        this.examples = examples;
        if (examples.getTableBody() == null) {
            this.children = Collections.emptyList();
        } else {
            AtomicInteger rowCounter = new AtomicInteger(1);
            this.children = examples.getTableBody().stream().map(tableRow -> new GherkinVintageExample((TableRow)tableRow, rowCounter.getAndIncrement())).collect(Collectors.toList());
        }
    }

    public Collection<Example> children() {
        return this.children;
    }

    public Location getLocation() {
        return GherkinVintageLocation.from(this.examples.getLocation());
    }

    public String getKeyWord() {
        return this.examples.getKeyword();
    }

    public String getName() {
        return this.examples.getName();
    }
}

