/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.gherkin.vintage;

import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.gherkin.Located;
import io.cucumber.core.gherkin.Location;
import io.cucumber.core.gherkin.Node;
import io.cucumber.core.gherkin.Pickle;
import io.cucumber.core.gherkin.vintage.GherkinVintageLocation;
import io.cucumber.core.gherkin.vintage.GherkinVintageScenario;
import io.cucumber.core.gherkin.vintage.GherkinVintageScenarioOutline;
import io.cucumber.core.gherkin.vintage.internal.gherkin.ast.GherkinDocument;
import io.cucumber.core.gherkin.vintage.internal.gherkin.ast.Scenario;
import io.cucumber.core.gherkin.vintage.internal.gherkin.ast.ScenarioDefinition;
import io.cucumber.core.gherkin.vintage.internal.gherkin.ast.ScenarioOutline;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collectors;

final class GherkinVintageFeature
implements Feature {
    private final URI uri;
    private final List<Pickle> pickles;
    private final GherkinDocument gherkinDocument;
    private final String gherkinSource;
    private final List<Node> children;

    GherkinVintageFeature(GherkinDocument gherkinDocument, URI uri, String gherkinSource, List<Pickle> pickles) {
        this.gherkinDocument = gherkinDocument;
        this.uri = uri;
        this.gherkinSource = gherkinSource;
        this.pickles = pickles;
        this.children = gherkinDocument.getFeature().getChildren().stream().filter(scenarioDefinition -> scenarioDefinition instanceof ScenarioOutline || scenarioDefinition instanceof Scenario).map(scenarioDefinition -> {
            if (scenarioDefinition instanceof ScenarioOutline) {
                ScenarioOutline outline = (ScenarioOutline)scenarioDefinition;
                return new GherkinVintageScenarioOutline(outline);
            }
            return new GherkinVintageScenario((ScenarioDefinition)scenarioDefinition);
        }).map(Node.class::cast).collect(Collectors.toList());
    }

    public Collection<Node> children() {
        return this.children;
    }

    public String getKeyword() {
        return this.gherkinDocument.getFeature().getKeyword();
    }

    public Pickle getPickleAt(Located located) {
        Location location = located.getLocation();
        return this.pickles.stream().filter(pickle -> pickle.getLocation().equals(location)).findFirst().orElseThrow(() -> new NoSuchElementException("No pickle in " + this.uri + " at " + location));
    }

    public Location getLocation() {
        return GherkinVintageLocation.from(this.gherkinDocument.getFeature().getLocation());
    }

    public List<Pickle> getPickles() {
        return this.pickles;
    }

    public String getKeyWord() {
        return null;
    }

    public String getName() {
        return this.gherkinDocument.getFeature().getName();
    }

    public URI getUri() {
        return this.uri;
    }

    public String getSource() {
        return this.gherkinSource;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GherkinVintageFeature that = (GherkinVintageFeature)o;
        return this.uri.equals(that.uri);
    }

    public int hashCode() {
        return Objects.hash(this.uri);
    }
}

