/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.gherkin.vintage;

import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.gherkin.FeatureParser;
import io.cucumber.core.gherkin.FeatureParserException;
import io.cucumber.core.gherkin.vintage.GherkinVintageFeature;
import io.cucumber.core.gherkin.vintage.GherkinVintagePickle;
import io.cucumber.core.gherkin.vintage.internal.gherkin.AstBuilder;
import io.cucumber.core.gherkin.vintage.internal.gherkin.GherkinDialect;
import io.cucumber.core.gherkin.vintage.internal.gherkin.GherkinDialectProvider;
import io.cucumber.core.gherkin.vintage.internal.gherkin.Parser;
import io.cucumber.core.gherkin.vintage.internal.gherkin.ParserException;
import io.cucumber.core.gherkin.vintage.internal.gherkin.TokenMatcher;
import io.cucumber.core.gherkin.vintage.internal.gherkin.ast.GherkinDocument;
import io.cucumber.core.gherkin.vintage.internal.gherkin.pickles.Compiler;
import io.cucumber.core.gherkin.vintage.internal.gherkin.pickles.Pickle;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class GherkinVintageFeatureParser
implements FeatureParser {
    private static Optional<Feature> parseGherkin5(URI path, String source) {
        try {
            Parser<GherkinDocument> parser = new Parser<GherkinDocument>(new AstBuilder());
            TokenMatcher matcher = new TokenMatcher();
            GherkinDocument gherkinDocument = parser.parse(source, (Parser.ITokenMatcher)matcher);
            if (gherkinDocument.getFeature() == null) {
                return Optional.empty();
            }
            List<io.cucumber.core.gherkin.Pickle> pickles = GherkinVintageFeatureParser.compilePickles(path, gherkinDocument);
            if (pickles.isEmpty()) {
                return Optional.empty();
            }
            GherkinVintageFeature feature = new GherkinVintageFeature(gherkinDocument, path, source, pickles);
            return Optional.of(feature);
        }
        catch (ParserException e) {
            throw new FeatureParserException("Failed to parse resource at: " + path.toString(), (Throwable)e);
        }
    }

    private static List<io.cucumber.core.gherkin.Pickle> compilePickles(URI path, GherkinDocument document) {
        GherkinDialectProvider dialectProvider = new GherkinDialectProvider();
        String language = document.getFeature().getLanguage();
        GherkinDialect dialect = dialectProvider.getDialect(language, null);
        return new Compiler().compile(document).stream().map(pickle -> new GherkinVintagePickle((Pickle)pickle, path, document, dialect)).collect(Collectors.toList());
    }

    public Optional<Feature> parse(URI path, String source, Supplier<UUID> idGenerator) {
        return GherkinVintageFeatureParser.parseGherkin5(path, source);
    }

    public String version() {
        return "5";
    }
}

