/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.gherkin.vintage;

import io.cucumber.core.gherkin.Location;
import io.cucumber.core.gherkin.vintage.internal.gherkin.pickles.PickleLocation;
import java.util.Objects;

final class GherkinVintageLocation
implements Location {
    private final int line;
    private final int column;

    private GherkinVintageLocation(int line, int column) {
        this.line = line;
        this.column = column;
    }

    static Location from(PickleLocation location) {
        return new GherkinVintageLocation(location.getLine(), location.getColumn());
    }

    public static Location from(io.cucumber.core.gherkin.vintage.internal.gherkin.ast.Location location) {
        return new GherkinVintageLocation(location.getLine(), location.getColumn());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GherkinVintageLocation that = (GherkinVintageLocation)o;
        return this.line == that.line && this.column == that.column;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public int hashCode() {
        return Objects.hash(this.line, this.column);
    }

    public String toString() {
        return "Location{line=" + this.line + ", column=" + this.column + '}';
    }
}

