/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.gherkin.vintage;

import io.cucumber.core.gherkin.Location;
import io.cucumber.core.gherkin.Pickle;
import io.cucumber.core.gherkin.Step;
import io.cucumber.core.gherkin.StepType;
import io.cucumber.core.gherkin.vintage.GherkinVintageLocation;
import io.cucumber.core.gherkin.vintage.GherkinVintageStep;
import io.cucumber.core.gherkin.vintage.internal.gherkin.GherkinDialect;
import io.cucumber.core.gherkin.vintage.internal.gherkin.ast.GherkinDocument;
import io.cucumber.core.gherkin.vintage.internal.gherkin.ast.ScenarioDefinition;
import io.cucumber.core.gherkin.vintage.internal.gherkin.pickles.PickleStep;
import io.cucumber.core.gherkin.vintage.internal.gherkin.pickles.PickleTag;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

final class GherkinVintagePickle
implements Pickle {
    private final io.cucumber.core.gherkin.vintage.internal.gherkin.pickles.Pickle pickle;
    private final List<Step> steps;
    private final URI uri;
    private final String keyWord;
    private final String id;

    GherkinVintagePickle(io.cucumber.core.gherkin.vintage.internal.gherkin.pickles.Pickle pickle, URI uri, GherkinDocument document, GherkinDialect dialect) {
        this.pickle = pickle;
        this.uri = uri;
        this.steps = GherkinVintagePickle.createCucumberSteps(pickle, document, dialect, uri.toString());
        this.keyWord = document.getFeature().getChildren().stream().filter(scenarioDefinition -> scenarioDefinition.getLocation().getLine() == this.getScenarioLocation().getLine()).map(ScenarioDefinition::getKeyword).findFirst().orElse("Scenario");
        this.id = pickle.getName() + ":" + pickle.getLocations().stream().map(l -> String.valueOf(l.getLine())).collect(Collectors.joining(":"));
    }

    private static List<Step> createCucumberSteps(io.cucumber.core.gherkin.vintage.internal.gherkin.pickles.Pickle pickle, GherkinDocument document, GherkinDialect dialect, String uri) {
        ArrayList<Step> list = new ArrayList<Step>();
        String previousGivenWhenThen = dialect.getGivenKeywords().stream().filter(s -> !StepType.isAstrix((String)s)).findFirst().orElseThrow(() -> new IllegalStateException("No Given keyword for dialect: " + dialect.getName()));
        for (PickleStep step : pickle.getSteps()) {
            GherkinVintageStep cucumberStep = new GherkinVintageStep(step, document, dialect, previousGivenWhenThen, uri);
            if (cucumberStep.getType().isGivenWhenThen()) {
                previousGivenWhenThen = cucumberStep.getKeyWord();
            }
            list.add(cucumberStep);
        }
        return list;
    }

    public String getKeyword() {
        return this.keyWord;
    }

    public String getLanguage() {
        return this.pickle.getLanguage();
    }

    public String getName() {
        return this.pickle.getName();
    }

    public Location getLocation() {
        return GherkinVintageLocation.from(this.pickle.getLocations().get(0));
    }

    public Location getScenarioLocation() {
        int last = this.pickle.getLocations().size() - 1;
        return GherkinVintageLocation.from(this.pickle.getLocations().get(last));
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public List<String> getTags() {
        return this.pickle.getTags().stream().map(PickleTag::getName).collect(Collectors.toList());
    }

    public URI getUri() {
        return this.uri;
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GherkinVintagePickle that = (GherkinVintagePickle)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

