/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.gherkin.vintage;

import io.cucumber.core.gherkin.Argument;
import io.cucumber.core.gherkin.Step;
import io.cucumber.core.gherkin.StepType;
import io.cucumber.core.gherkin.vintage.GherkinVintageDataTableArgument;
import io.cucumber.core.gherkin.vintage.GherkinVintageDocStringArgument;
import io.cucumber.core.gherkin.vintage.internal.gherkin.GherkinDialect;
import io.cucumber.core.gherkin.vintage.internal.gherkin.ast.GherkinDocument;
import io.cucumber.core.gherkin.vintage.internal.gherkin.pickles.PickleStep;
import io.cucumber.core.gherkin.vintage.internal.gherkin.pickles.PickleString;
import io.cucumber.core.gherkin.vintage.internal.gherkin.pickles.PickleTable;
import java.util.stream.Collectors;

final class GherkinVintageStep
implements Step {
    private final PickleStep step;
    private final Argument argument;
    private final String keyWord;
    private final StepType stepType;
    private final String previousGwtKeyWord;
    private final String uri;

    GherkinVintageStep(PickleStep step, GherkinDocument document, GherkinDialect dialect, String previousGwtKeyWord, String uri) {
        this.step = step;
        this.argument = GherkinVintageStep.extractArgument(step, this.getLine());
        this.keyWord = GherkinVintageStep.extractKeyWord(document, this.getLine());
        this.stepType = this.extractKeyWordType(this.keyWord, dialect);
        this.previousGwtKeyWord = previousGwtKeyWord;
        this.uri = uri;
    }

    private static String extractKeyWord(GherkinDocument document, int stepLine) {
        return document.getFeature().getChildren().stream().flatMap(scenarioDefinition -> scenarioDefinition.getSteps().stream()).filter(step -> step.getLocation().getLine() == stepLine).findFirst().map(io.cucumber.core.gherkin.vintage.internal.gherkin.ast.Step::getKeyword).orElseThrow(() -> new IllegalStateException("GherkinDocument did not contain PickleStep"));
    }

    private static Argument extractArgument(PickleStep pickleStep, int stepLine) {
        if (pickleStep.getArgument().isEmpty()) {
            return null;
        }
        io.cucumber.core.gherkin.vintage.internal.gherkin.pickles.Argument argument = pickleStep.getArgument().get(0);
        if (argument instanceof PickleString) {
            PickleString docString = (PickleString)argument;
            return new GherkinVintageDocStringArgument(docString);
        }
        if (argument instanceof PickleTable) {
            PickleTable table = (PickleTable)argument;
            return new GherkinVintageDataTableArgument(table, stepLine + 1);
        }
        return null;
    }

    private StepType extractKeyWordType(String keyWord, GherkinDialect dialect) {
        if (StepType.isAstrix((String)keyWord)) {
            return StepType.OTHER;
        }
        if (dialect.getGivenKeywords().contains(keyWord)) {
            return StepType.GIVEN;
        }
        if (dialect.getWhenKeywords().contains(keyWord)) {
            return StepType.WHEN;
        }
        if (dialect.getThenKeywords().contains(keyWord)) {
            return StepType.THEN;
        }
        if (dialect.getAndKeywords().contains(keyWord)) {
            return StepType.AND;
        }
        if (dialect.getButKeywords().contains(keyWord)) {
            return StepType.BUT;
        }
        throw new IllegalStateException("Keyword " + keyWord + " was neither given, when, then, and, but nor *");
    }

    public int getLine() {
        int last = this.step.getLocations().size() - 1;
        return this.step.getLocations().get(last).getLine();
    }

    public Argument getArgument() {
        return this.argument;
    }

    public String getKeyWord() {
        return this.keyWord;
    }

    public StepType getType() {
        return this.stepType;
    }

    public String getPreviousGivenWhenThenKeyWord() {
        return this.previousGwtKeyWord;
    }

    public String getText() {
        return this.step.getText();
    }

    public String getId() {
        String lineNumbers = this.step.getLocations().stream().map(s -> String.valueOf(s.getLine())).collect(Collectors.joining(":"));
        return this.uri + ":" + lineNumbers;
    }
}

