/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.gherkin.vintage.internal.gherkin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GherkinDialect {
    private final Map<String, Object> keywords;
    private String language;

    public GherkinDialect(String language, Map<String, Object> keywords) {
        this.language = language;
        this.keywords = keywords;
    }

    public List<String> getFeatureKeywords() {
        return (List)this.keywords.get("feature");
    }

    public String getName() {
        return (String)this.keywords.get("name");
    }

    public String getNativeName() {
        return (String)this.keywords.get("native");
    }

    public List<String> getScenarioKeywords() {
        return (List)this.keywords.get("scenario");
    }

    public List<String> getStepKeywords() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.getGivenKeywords());
        result.addAll(this.getWhenKeywords());
        result.addAll(this.getThenKeywords());
        result.addAll(this.getAndKeywords());
        result.addAll(this.getButKeywords());
        return result;
    }

    public List<String> getBackgroundKeywords() {
        return (List)this.keywords.get("background");
    }

    public List<String> getScenarioOutlineKeywords() {
        return (List)this.keywords.get("scenarioOutline");
    }

    public List<String> getExamplesKeywords() {
        return (List)this.keywords.get("examples");
    }

    public List<String> getGivenKeywords() {
        return (List)this.keywords.get("given");
    }

    public List<String> getWhenKeywords() {
        return (List)this.keywords.get("when");
    }

    public List<String> getThenKeywords() {
        return (List)this.keywords.get("then");
    }

    public List<String> getAndKeywords() {
        return (List)this.keywords.get("and");
    }

    public List<String> getButKeywords() {
        return (List)this.keywords.get("but");
    }

    public String getLanguage() {
        return this.language;
    }
}

