/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.gherkin.vintage.internal.gherkin;

import io.cucumber.core.gherkin.vintage.internal.gherkin.GherkinLineSpan;
import io.cucumber.core.gherkin.vintage.internal.gherkin.StringUtils;
import io.cucumber.core.gherkin.vintage.internal.gherkin.Token;

public class TokenFormatter {
    private static final StringUtils.ToString<GherkinLineSpan> SPAN_TO_STRING = new StringUtils.ToString<GherkinLineSpan>(){

        @Override
        public String toString(GherkinLineSpan o) {
            return o.column + ":" + o.text;
        }
    };

    public String formatToken(Token token) {
        if (token.isEOF()) {
            return "EOF";
        }
        return String.format("(%s:%s)%s:%s/%s/%s", this.toString(token.location.getLine()), this.toString(token.location.getColumn()), this.toString((Object)token.matchedType), this.toString(token.matchedKeyword), this.toString(token.matchedText), this.toString(token.mathcedItems == null ? "" : StringUtils.join(SPAN_TO_STRING, ",", token.mathcedItems)));
    }

    private String toString(Object o) {
        return o == null ? "" : o.toString();
    }
}

