/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.testng;

import io.cucumber.core.runtime.TestCaseResultObserver;
import java.util.List;
import java.util.stream.Collectors;
import org.testng.SkipException;

final class UndefinedStepException
extends SkipException {
    private static final long serialVersionUID = 1L;

    UndefinedStepException(List<TestCaseResultObserver.Suggestion> suggestions) {
        super(UndefinedStepException.createMessage(suggestions));
    }

    private static String createMessage(List<TestCaseResultObserver.Suggestion> suggestions) {
        return suggestions.stream().map(suggestion -> UndefinedStepException.createStepMessage(suggestion.getStep(), suggestion.getSnippets())).collect(Collectors.joining("\n", UndefinedStepException.createPreAmble(suggestions), ""));
    }

    private static String createStepMessage(String stepText, List<String> snippets) {
        StringBuilder sb = new StringBuilder("The step \"" + stepText + "\" is undefined");
        UndefinedStepException.appendSnippets(snippets, sb);
        return sb.toString();
    }

    private static String createPreAmble(List<TestCaseResultObserver.Suggestion> suggestions) {
        return suggestions.size() < 2 ? "" : "There were " + suggestions.size() + " undefined steps\n";
    }

    private static void appendSnippets(List<String> snippets, StringBuilder sb) {
        if (snippets.isEmpty()) {
            return;
        }
        sb.append(". You can implement it using the snippet(s) below:\n\n");
        sb.append(snippets.stream().collect(Collectors.joining("\n---\n", "", "\n")));
    }

    public boolean isSkip() {
        return false;
    }
}

