/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.datatable;

import io.cucumber.datatable.CucumberDataTableException;
import io.cucumber.datatable.DataTable;
import io.cucumber.datatable.DataTableType;
import io.cucumber.datatable.DataTableTypeRegistry;
import io.cucumber.datatable.TypeFactory;
import io.cucumber.datatable.UndefinedDataTableTypeException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public final class DataTableTypeRegistryTableConverter
implements DataTable.TableConverter {
    private final DataTableTypeRegistry registry;

    public DataTableTypeRegistryTableConverter(DataTableTypeRegistry registry) {
        this.registry = registry;
    }

    @Override
    public <T> T convert(DataTable dataTable, Type type) {
        return this.convert(dataTable, type, false);
    }

    @Override
    public <T> T convert(DataTable dataTable, Type type, boolean transposed) {
        TypeFactory.JavaType javaType;
        DataTableType tableType;
        Objects.requireNonNull(dataTable, "dataTable may not be null");
        Objects.requireNonNull(type, "type may not be null");
        if (transposed) {
            dataTable = dataTable.transpose();
        }
        if ((tableType = this.registry.lookupTableTypeByType(javaType = TypeFactory.constructType(type))) != null) {
            return (T)tableType.transform(dataTable.cells());
        }
        if (type.equals(DataTable.class)) {
            return (T)dataTable;
        }
        if (javaType instanceof TypeFactory.MapType) {
            TypeFactory.MapType mapType = (TypeFactory.MapType)javaType;
            return (T)this.toMap(dataTable, mapType.getKeyType(), mapType.getValueType());
        }
        if (javaType instanceof TypeFactory.OtherType) {
            return this.toSingleton(dataTable, javaType);
        }
        assert (javaType instanceof TypeFactory.ListType);
        TypeFactory.ListType listType = (TypeFactory.ListType)javaType;
        TypeFactory.JavaType listElementType = listType.getElementType();
        if (listElementType instanceof TypeFactory.MapType) {
            TypeFactory.MapType mapElement = (TypeFactory.MapType)listElementType;
            return (T)this.toMaps(dataTable, mapElement.getKeyType(), mapElement.getValueType());
        }
        if (listElementType instanceof TypeFactory.ListType) {
            TypeFactory.ListType listElement = (TypeFactory.ListType)listElementType;
            return (T)this.toLists(dataTable, listElement.getElementType());
        }
        assert (listElementType instanceof TypeFactory.OtherType);
        return (T)this.toList(dataTable, listElementType);
    }

    private <T> T toSingleton(DataTable dataTable, Type type) {
        if (dataTable.isEmpty()) {
            return null;
        }
        List<T> singletonList = this.toListOrNull(dataTable, type);
        if (singletonList == null) {
            DataTableType cellValueType = this.registry.lookupTableTypeByType(TypeFactory.aListOf(TypeFactory.aListOf(type)));
            if (cellValueType != null) {
                throw UndefinedDataTableTypeException.singletonTableTooWide(type, "TableEntryConverter or TableCellConverter", type);
            }
            throw UndefinedDataTableTypeException.singletonNoConverterDefined(type);
        }
        if (singletonList.size() == 1) {
            return singletonList.get(0);
        }
        throw CucumberDataTableException.cantConvertTo(type, "The table contained more then one item: " + singletonList);
    }

    @Override
    public <T> List<T> toList(DataTable dataTable, Type itemType) {
        Objects.requireNonNull(dataTable, "dataTable may not be null");
        Objects.requireNonNull(itemType, "itemType may not be null");
        if (dataTable.isEmpty()) {
            return Collections.emptyList();
        }
        List<T> list = this.toListOrNull(dataTable, itemType);
        if (list != null) {
            return Collections.unmodifiableList(list);
        }
        if (dataTable.width() == 1) {
            throw UndefinedDataTableTypeException.listNoConverterDefined(itemType, "TableEntryTransformer, TableRowTransformer or TableCellTransformer", itemType);
        }
        DataTableType cellValueType = this.registry.lookupTableTypeByType(TypeFactory.aListOf(TypeFactory.aListOf(itemType)));
        if (cellValueType != null) {
            throw UndefinedDataTableTypeException.listTableTooWide(itemType, "TableEntryTransformer or TableRowTransformer", itemType);
        }
        throw UndefinedDataTableTypeException.listNoConverterDefined(itemType, "TableEntryTransformer or TableRowTransformer", itemType);
    }

    private <T> List<T> toListOrNull(DataTable dataTable, Type itemType) {
        DataTableType defaultCellValueType;
        DataTableType defaultTableType;
        DataTableType cellValueType;
        DataTableType tableType = this.registry.lookupTableTypeByType(TypeFactory.aListOf(itemType));
        List<List<String>> cells = dataTable.cells();
        if (tableType != null) {
            return (List)tableType.transform(cells);
        }
        if (dataTable.width() == 1 && (cellValueType = this.registry.lookupTableTypeByType(TypeFactory.aListOf(TypeFactory.aListOf(itemType)))) != null) {
            return DataTableTypeRegistryTableConverter.unpack((List)cellValueType.transform(cells));
        }
        if (dataTable.height() > 1 && (defaultTableType = this.registry.getDefaultTableEntryTransformer(itemType)) != null) {
            return (List)defaultTableType.transform(cells);
        }
        if (dataTable.width() == 1 && (defaultCellValueType = this.registry.getDefaultTableCellTransformer(itemType)) != null) {
            return DataTableTypeRegistryTableConverter.unpack((List)defaultCellValueType.transform(cells));
        }
        defaultTableType = this.registry.getDefaultTableEntryTransformer(itemType);
        if (defaultTableType != null) {
            return (List)defaultTableType.transform(cells);
        }
        return null;
    }

    @Override
    public <T> List<List<T>> toLists(DataTable dataTable, Type itemType) {
        Objects.requireNonNull(dataTable, "dataTable may not be null");
        Objects.requireNonNull(itemType, "itemType may not be null");
        if (dataTable.isEmpty()) {
            return Collections.emptyList();
        }
        DataTableType tableType = this.registry.lookupTableTypeByType(TypeFactory.aListOf(TypeFactory.aListOf(itemType)));
        if (tableType == null) {
            tableType = this.registry.getDefaultTableCellTransformer(itemType);
        }
        if (tableType != null) {
            return Collections.unmodifiableList((List)tableType.transform(dataTable.cells()));
        }
        throw UndefinedDataTableTypeException.listsNoConverterDefined(itemType);
    }

    @Override
    public <K, V> Map<K, V> toMap(DataTable dataTable, Type keyType, Type valueType) {
        Objects.requireNonNull(dataTable, "dataTable may not be null");
        Objects.requireNonNull(keyType, "keyType may not be null");
        Objects.requireNonNull(valueType, "valueType may not be null");
        if (dataTable.isEmpty()) {
            return Collections.emptyMap();
        }
        DataTable keyColumn = dataTable.columns(0, 1);
        DataTable valueColumns = dataTable.columns(1);
        String firstHeaderCell = keyColumn.cell(0, 0);
        boolean firstHeaderCellIsBlank = firstHeaderCell == null || firstHeaderCell.isEmpty();
        List<K> keys = this.convertEntryKeys(keyType, keyColumn, valueType, firstHeaderCellIsBlank);
        if (valueColumns.isEmpty()) {
            return DataTableTypeRegistryTableConverter.createMap(keyType, keys, valueType, Collections.nCopies(keys.size(), null));
        }
        boolean keysImplyTableRowTransformer = keys.size() == dataTable.height() - 1;
        List<V> values = this.convertEntryValues(valueColumns, keyType, valueType, keysImplyTableRowTransformer);
        if (keys.size() != values.size()) {
            throw CucumberDataTableException.keyValueMismatchException(firstHeaderCellIsBlank, keys.size(), keyType, values.size(), valueType);
        }
        return DataTableTypeRegistryTableConverter.createMap(keyType, keys, valueType, values);
    }

    private static <K, V> Map<K, V> createMap(Type keyType, List<K> keys, Type valueType, List<V> values) {
        Iterator<K> keyIterator = keys.iterator();
        Iterator<V> valueIterator = values.iterator();
        LinkedHashMap<K, V> result = new LinkedHashMap<K, V>();
        while (keyIterator.hasNext() && valueIterator.hasNext()) {
            K key = keyIterator.next();
            V value = valueIterator.next();
            if (result.containsKey(key)) {
                Object wouldBeReplaced = result.get(key);
                throw CucumberDataTableException.duplicateKeyException(keyType, valueType, key, value, wouldBeReplaced);
            }
            result.put(key, value);
        }
        return Collections.unmodifiableMap(result);
    }

    private <K> List<K> convertEntryKeys(Type keyType, DataTable keyColumn, Type valueType, boolean firstHeaderCellIsBlank) {
        if (firstHeaderCellIsBlank) {
            DataTableType keyConverter = this.registry.lookupTableTypeByType(TypeFactory.aListOf(TypeFactory.aListOf(keyType)));
            if (keyConverter == null) {
                keyConverter = this.registry.getDefaultTableCellTransformer(keyType);
            }
            if (keyConverter == null) {
                throw UndefinedDataTableTypeException.mapNoConverterDefined(keyType, valueType, "TableCellTransformer", keyType);
            }
            return DataTableTypeRegistryTableConverter.unpack((List)keyConverter.transform(keyColumn.rows(1, keyColumn.height()).cells()));
        }
        List list = this.toListOrNull(keyColumn, keyType);
        if (list != null) {
            return list;
        }
        throw UndefinedDataTableTypeException.mapNoConverterDefined(keyType, valueType, "TableEntryTransformer or TableCellTransformer", keyType);
    }

    private <V> List<V> convertEntryValues(DataTable dataTable, Type keyType, Type valueType, boolean keysImplyTableEntryTransformer) {
        TypeFactory.JavaType javaType = TypeFactory.constructType(valueType);
        if (javaType instanceof TypeFactory.ListType) {
            TypeFactory.ListType listType = (TypeFactory.ListType)javaType;
            DataTableType cellValueConverter = this.registry.lookupTableTypeByType(TypeFactory.aListOf(TypeFactory.aListOf(listType.getElementType())));
            if (cellValueConverter == null) {
                cellValueConverter = this.registry.getDefaultTableCellTransformer(listType.getElementType());
            }
            if (cellValueConverter == null) {
                throw UndefinedDataTableTypeException.mapNoConverterDefined(keyType, valueType, "TableCellTransformer", valueType);
            }
            return (List)cellValueConverter.transform(dataTable.cells());
        }
        if (javaType instanceof TypeFactory.MapType) {
            TypeFactory.MapType mapType = (TypeFactory.MapType)javaType;
            return this.toMaps(dataTable, mapType.getKeyType(), mapType.getValueType());
        }
        DataTableType entryValueConverter = this.registry.lookupTableTypeByType(TypeFactory.aListOf(valueType));
        if (entryValueConverter != null) {
            return (List)entryValueConverter.transform(dataTable.cells());
        }
        if (keysImplyTableEntryTransformer) {
            DataTableType defaultEntryValueConverter = this.registry.getDefaultTableEntryTransformer(valueType);
            if (defaultEntryValueConverter != null) {
                return (List)defaultEntryValueConverter.transform(dataTable.cells());
            }
            throw CucumberDataTableException.keysImplyTableEntryTransformer(keyType, valueType);
        }
        DataTableType cellValueConverter = this.registry.lookupTableTypeByType(TypeFactory.aListOf(TypeFactory.aListOf(valueType)));
        if (cellValueConverter != null) {
            return DataTableTypeRegistryTableConverter.unpack((List)cellValueConverter.transform(dataTable.cells()));
        }
        DataTableType defaultCellValueConverter = this.registry.getDefaultTableCellTransformer(valueType);
        if (defaultCellValueConverter != null) {
            return DataTableTypeRegistryTableConverter.unpack((List)defaultCellValueConverter.transform(dataTable.cells()));
        }
        throw UndefinedDataTableTypeException.mapNoConverterDefined(keyType, valueType, "TableEntryTransformer or TableCellTransformer", valueType);
    }

    @Override
    public <K, V> List<Map<K, V>> toMaps(DataTable dataTable, Type keyType, Type valueType) {
        Objects.requireNonNull(dataTable, "dataTable may not be null");
        Objects.requireNonNull(keyType, "keyType may not be null");
        Objects.requireNonNull(valueType, "valueType may not be null");
        if (dataTable.isEmpty()) {
            return Collections.emptyList();
        }
        DataTableType keyConverter = this.registry.lookupTableTypeByType(TypeFactory.aListOf(TypeFactory.aListOf(keyType)));
        DataTableType valueConverter = this.registry.lookupTableTypeByType(TypeFactory.aListOf(TypeFactory.aListOf(valueType)));
        if (keyConverter == null) {
            throw UndefinedDataTableTypeException.mapsNoConverterDefined(keyType, valueType, keyType);
        }
        if (valueConverter == null) {
            throw UndefinedDataTableTypeException.mapsNoConverterDefined(keyType, valueType, valueType);
        }
        DataTable header = dataTable.rows(0, 1);
        ArrayList result = new ArrayList();
        List keys = DataTableTypeRegistryTableConverter.unpack((List)keyConverter.transform(header.cells()));
        DataTable rows = dataTable.rows(1);
        if (rows.isEmpty()) {
            return Collections.emptyList();
        }
        List transform = (List)valueConverter.transform(rows.cells());
        for (List values : transform) {
            result.add(DataTableTypeRegistryTableConverter.createMap(keyType, keys, valueType, values));
        }
        return Collections.unmodifiableList(result);
    }

    private static <T> List<T> unpack(List<List<T>> cells) {
        ArrayList<T> unpacked = new ArrayList<T>(cells.size());
        for (List<T> row : cells) {
            unpacked.addAll(row);
        }
        return unpacked;
    }
}

