/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.gherkin;

import io.cucumber.gherkin.Locations;
import io.cucumber.gherkin.Token;
import io.cucumber.messages.types.Location;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;

class TokenScanner {
    private final BufferedReader reader;
    private int lineNumber;

    TokenScanner(String source) {
        this.reader = new BufferedReader(new StringReader(source));
    }

    Token read() {
        try {
            String rawText = this.reader.readLine();
            if (rawText == null) {
                Location location = Locations.atLine(++this.lineNumber);
                return Token.createEOF(location);
            }
            Location location = Locations.atLine(++this.lineNumber);
            return Token.createGherkinLine(rawText, location);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

