/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.gherkin;

import io.cucumber.gherkin.KeywordMatcher;
import io.cucumber.gherkin.Line;
import io.cucumber.messages.types.StepKeywordType;
import java.util.Objects;

final class KeywordMatchers {
    KeywordMatchers() {
    }

    static KeywordMatcher of(String language) {
        Objects.requireNonNull(language);
        switch (language) {
            case "af": {
                return new Af();
            }
            case "am": {
                return new Am();
            }
            case "amh": {
                return new Amh();
            }
            case "an": {
                return new An();
            }
            case "ar": {
                return new Ar();
            }
            case "ast": {
                return new Ast();
            }
            case "az": {
                return new Az();
            }
            case "be": {
                return new Be();
            }
            case "bg": {
                return new Bg();
            }
            case "bm": {
                return new Bm();
            }
            case "bs": {
                return new Bs();
            }
            case "ca": {
                return new Ca();
            }
            case "cs": {
                return new Cs();
            }
            case "cy-GB": {
                return new Cy_gb();
            }
            case "da": {
                return new Da();
            }
            case "de": {
                return new De();
            }
            case "el": {
                return new El();
            }
            case "em": {
                return new Em();
            }
            case "en": {
                return new En();
            }
            case "en-Scouse": {
                return new En_scouse();
            }
            case "en-au": {
                return new En_au();
            }
            case "en-lol": {
                return new En_lol();
            }
            case "en-old": {
                return new En_old();
            }
            case "en-pirate": {
                return new En_pirate();
            }
            case "en-tx": {
                return new En_tx();
            }
            case "eo": {
                return new Eo();
            }
            case "es": {
                return new Es();
            }
            case "et": {
                return new Et();
            }
            case "fa": {
                return new Fa();
            }
            case "fi": {
                return new Fi();
            }
            case "fr": {
                return new Fr();
            }
            case "ga": {
                return new Ga();
            }
            case "gj": {
                return new Gj();
            }
            case "gl": {
                return new Gl();
            }
            case "he": {
                return new He();
            }
            case "hi": {
                return new Hi();
            }
            case "hr": {
                return new Hr();
            }
            case "ht": {
                return new Ht();
            }
            case "hu": {
                return new Hu();
            }
            case "id": {
                return new Id();
            }
            case "is": {
                return new Is();
            }
            case "it": {
                return new It();
            }
            case "ja": {
                return new Ja();
            }
            case "jv": {
                return new Jv();
            }
            case "ka": {
                return new Ka();
            }
            case "kn": {
                return new Kn();
            }
            case "ko": {
                return new Ko();
            }
            case "lt": {
                return new Lt();
            }
            case "lu": {
                return new Lu();
            }
            case "lv": {
                return new Lv();
            }
            case "mk-Cyrl": {
                return new Mk_cyrl();
            }
            case "mk-Latn": {
                return new Mk_latn();
            }
            case "ml": {
                return new Ml();
            }
            case "mn": {
                return new Mn();
            }
            case "mr": {
                return new Mr();
            }
            case "ne": {
                return new Ne();
            }
            case "nl": {
                return new Nl();
            }
            case "no": {
                return new No();
            }
            case "pa": {
                return new Pa();
            }
            case "pl": {
                return new Pl();
            }
            case "pt": {
                return new Pt();
            }
            case "ro": {
                return new Ro();
            }
            case "ru": {
                return new Ru();
            }
            case "sk": {
                return new Sk();
            }
            case "sl": {
                return new Sl();
            }
            case "sr-Cyrl": {
                return new Sr_cyrl();
            }
            case "sr-Latn": {
                return new Sr_latn();
            }
            case "sv": {
                return new Sv();
            }
            case "ta": {
                return new Ta();
            }
            case "te": {
                return new Te();
            }
            case "th": {
                return new Th();
            }
            case "tlh": {
                return new Tlh();
            }
            case "tr": {
                return new Tr();
            }
            case "tt": {
                return new Tt();
            }
            case "uk": {
                return new Uk();
            }
            case "ur": {
                return new Ur();
            }
            case "uz": {
                return new Uz();
            }
            case "vi": {
                return new Vi();
            }
            case "zh-CN": {
                return new Zh_cn();
            }
            case "zh-TW": {
                return new Zh_tw();
            }
        }
        return null;
    }

    private static final class Af
    implements KeywordMatcher {
        private Af() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Besigheid Behoefte")) {
                return new KeywordMatcher.Match("Besigheid Behoefte", 19);
            }
            if (line.startsWithTitleKeyword("Funksie")) {
                return new KeywordMatcher.Match("Funksie", 8);
            }
            if (line.startsWithTitleKeyword("Vermo\u00eb")) {
                return new KeywordMatcher.Match("Vermo\u00eb", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Agtergrond")) {
                return new KeywordMatcher.Match("Agtergrond", 11);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Re\u00ebl")) {
                return new KeywordMatcher.Match("Re\u00ebl", 5);
            }
            if (line.startsWithTitleKeyword("Reel")) {
                return new KeywordMatcher.Match("Reel", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Situasie Uiteensetting")) {
                return new KeywordMatcher.Match("Situasie Uiteensetting", 23);
            }
            if (line.startsWithTitleKeyword("Voorbeeld")) {
                return new KeywordMatcher.Match("Voorbeeld", 10);
            }
            if (line.startsWithTitleKeyword("Situasie")) {
                return new KeywordMatcher.Match("Situasie", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Voorbeelde")) {
                return new KeywordMatcher.Match("Voorbeelde", 11);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Wanneer ")) {
                return new KeywordMatcher.StepMatch("Wanneer ", 8, StepKeywordType.ACTION);
            }
            if (line.startsWith("Gegewe ")) {
                return new KeywordMatcher.StepMatch("Gegewe ", 7, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Maar ")) {
                return new KeywordMatcher.StepMatch("Maar ", 5, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Dan ")) {
                return new KeywordMatcher.StepMatch("Dan ", 4, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("En ")) {
                return new KeywordMatcher.StepMatch("En ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class Am
    implements KeywordMatcher {
        private Am() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0556\u0578\u0582\u0576\u056f\u0581\u056b\u0578\u0576\u0561\u056c\u0578\u0582\u0569\u0575\u0578\u0582\u0576")) {
                return new KeywordMatcher.Match("\u0556\u0578\u0582\u0576\u056f\u0581\u056b\u0578\u0576\u0561\u056c\u0578\u0582\u0569\u0575\u0578\u0582\u0576", 19);
            }
            if (line.startsWithTitleKeyword("\u0540\u0561\u057f\u056f\u0578\u0582\u0569\u0575\u0578\u0582\u0576")) {
                return new KeywordMatcher.Match("\u0540\u0561\u057f\u056f\u0578\u0582\u0569\u0575\u0578\u0582\u0576", 12);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u053f\u0578\u0576\u057f\u0565\u0584\u057d\u057f")) {
                return new KeywordMatcher.Match("\u053f\u0578\u0576\u057f\u0565\u0584\u057d\u057f", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u054d\u0581\u0565\u0576\u0561\u0580\u056b \u056f\u0561\u057c\u0578\u0582\u0581\u057e\u0561\u0581\u0584\u0568")) {
                return new KeywordMatcher.Match("\u054d\u0581\u0565\u0576\u0561\u0580\u056b \u056f\u0561\u057c\u0578\u0582\u0581\u057e\u0561\u0581\u0584\u0568", 20);
            }
            if (line.startsWithTitleKeyword("\u0555\u0580\u056b\u0576\u0561\u056f")) {
                return new KeywordMatcher.Match("\u0555\u0580\u056b\u0576\u0561\u056f", 7);
            }
            if (line.startsWithTitleKeyword("\u054d\u0581\u0565\u0576\u0561\u0580")) {
                return new KeywordMatcher.Match("\u054d\u0581\u0565\u0576\u0561\u0580", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0555\u0580\u056b\u0576\u0561\u056f\u0576\u0565\u0580")) {
                return new KeywordMatcher.Match("\u0555\u0580\u056b\u0576\u0561\u056f\u0576\u0565\u0580", 10);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("\u0534\u056b\u0581\u0578\u0582\u0584 ")) {
                return new KeywordMatcher.StepMatch("\u0534\u056b\u0581\u0578\u0582\u0584 ", 7, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u0532\u0561\u0575\u0581 ")) {
                return new KeywordMatcher.StepMatch("\u0532\u0561\u0575\u0581 ", 5, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u0531\u057a\u0561 ")) {
                return new KeywordMatcher.StepMatch("\u0531\u057a\u0561 ", 4, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("\u0535\u0580\u0562 ")) {
                return new KeywordMatcher.StepMatch("\u0535\u0580\u0562 ", 4, StepKeywordType.ACTION);
            }
            if (line.startsWith("\u0535\u0569\u0565 ")) {
                return new KeywordMatcher.StepMatch("\u0535\u0569\u0565 ", 4, StepKeywordType.ACTION);
            }
            if (line.startsWith("\u0535\u057e ")) {
                return new KeywordMatcher.StepMatch("\u0535\u057e ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class Amh
    implements KeywordMatcher {
        private Amh() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u12e8\u121a\u1348\u1208\u1308\u12cd \u12f5\u122d\u130a\u1275")) {
                return new KeywordMatcher.Match("\u12e8\u121a\u1348\u1208\u1308\u12cd \u12f5\u122d\u130a\u1275", 12);
            }
            if (line.startsWithTitleKeyword("\u12e8\u1270\u1348\u1208\u1308\u12cd \u1235\u122b")) {
                return new KeywordMatcher.Match("\u12e8\u1270\u1348\u1208\u1308\u12cd \u1235\u122b", 10);
            }
            if (line.startsWithTitleKeyword("\u1235\u122b")) {
                return new KeywordMatcher.Match("\u1235\u122b", 3);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u1218\u1290\u123b \u1200\u1233\u1265")) {
                return new KeywordMatcher.Match("\u1218\u1290\u123b \u1200\u1233\u1265", 8);
            }
            if (line.startsWithTitleKeyword("\u1245\u12f5\u1218 \u1201\u1294\u1273")) {
                return new KeywordMatcher.Match("\u1245\u12f5\u1218 \u1201\u1294\u1273", 8);
            }
            if (line.startsWithTitleKeyword("\u1218\u1290\u123b")) {
                return new KeywordMatcher.Match("\u1218\u1290\u123b", 4);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u1205\u130d")) {
                return new KeywordMatcher.Match("\u1205\u130d", 3);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u1201\u1293\u1274 \u12dd\u122d\u12dd\u122d")) {
                return new KeywordMatcher.Match("\u1201\u1293\u1274 \u12dd\u122d\u12dd\u122d", 9);
            }
            if (line.startsWithTitleKeyword("\u1201\u1293\u1274 \u12a0\u1265\u1290\u1275")) {
                return new KeywordMatcher.Match("\u1201\u1293\u1274 \u12a0\u1265\u1290\u1275", 9);
            }
            if (line.startsWithTitleKeyword("\u1201\u1293\u1274")) {
                return new KeywordMatcher.Match("\u1201\u1293\u1274", 4);
            }
            if (line.startsWithTitleKeyword("\u121d\u1233\u120c")) {
                return new KeywordMatcher.Match("\u121d\u1233\u120c", 4);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u121d\u1233\u120c\u12ce\u127d")) {
                return new KeywordMatcher.Match("\u121d\u1233\u120c\u12ce\u127d", 6);
            }
            if (line.startsWithTitleKeyword("\u1201\u1293\u1274\u12ce\u127d")) {
                return new KeywordMatcher.Match("\u1201\u1293\u1274\u12ce\u127d", 6);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("\u12e8\u1270\u1230\u1320 ")) {
                return new KeywordMatcher.StepMatch("\u12e8\u1270\u1230\u1320 ", 5, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u12a8\u12da\u12eb ")) {
                return new KeywordMatcher.StepMatch("\u12a8\u12da\u12eb ", 4, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("\u130d\u1295 ")) {
                return new KeywordMatcher.StepMatch("\u130d\u1295 ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u1218\u127c ")) {
                return new KeywordMatcher.StepMatch("\u1218\u127c ", 3, StepKeywordType.ACTION);
            }
            if (line.startsWith("\u12a5\u1293 ")) {
                return new KeywordMatcher.StepMatch("\u12a5\u1293 ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class An
    implements KeywordMatcher {
        private An() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Caracteristica")) {
                return new KeywordMatcher.Match("Caracteristica", 15);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Antecedents")) {
                return new KeywordMatcher.Match("Antecedents", 12);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Esquema del caso")) {
                return new KeywordMatcher.Match("Esquema del caso", 17);
            }
            if (line.startsWithTitleKeyword("Eixemplo")) {
                return new KeywordMatcher.Match("Eixemplo", 9);
            }
            if (line.startsWithTitleKeyword("Caso")) {
                return new KeywordMatcher.Match("Caso", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Eixemplos")) {
                return new KeywordMatcher.Match("Eixemplos", 10);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Antonces ")) {
                return new KeywordMatcher.StepMatch("Antonces ", 9, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Alavez ")) {
                return new KeywordMatcher.StepMatch("Alavez ", 7, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Allora ")) {
                return new KeywordMatcher.StepMatch("Allora ", 7, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Dadas ")) {
                return new KeywordMatcher.StepMatch("Dadas ", 6, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Cuan ")) {
                return new KeywordMatcher.StepMatch("Cuan ", 5, StepKeywordType.ACTION);
            }
            if (line.startsWith("Daus ")) {
                return new KeywordMatcher.StepMatch("Daus ", 5, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Dada ")) {
                return new KeywordMatcher.StepMatch("Dada ", 5, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Pero ")) {
                return new KeywordMatcher.StepMatch("Pero ", 5, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Dau ")) {
                return new KeywordMatcher.StepMatch("Dau ", 4, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Y ")) {
                return new KeywordMatcher.StepMatch("Y ", 2, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            if (line.startsWith("E ")) {
                return new KeywordMatcher.StepMatch("E ", 2, StepKeywordType.CONJUNCTION);
            }
            return null;
        }
    }

    private static final class Ar
    implements KeywordMatcher {
        private Ar() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u062e\u0627\u0635\u064a\u0629")) {
                return new KeywordMatcher.Match("\u062e\u0627\u0635\u064a\u0629", 6);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0627\u0644\u062e\u0644\u0641\u064a\u0629")) {
                return new KeywordMatcher.Match("\u0627\u0644\u062e\u0644\u0641\u064a\u0629", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0633\u064a\u0646\u0627\u0631\u064a\u0648 \u0645\u062e\u0637\u0637")) {
                return new KeywordMatcher.Match("\u0633\u064a\u0646\u0627\u0631\u064a\u0648 \u0645\u062e\u0637\u0637", 13);
            }
            if (line.startsWithTitleKeyword("\u0633\u064a\u0646\u0627\u0631\u064a\u0648")) {
                return new KeywordMatcher.Match("\u0633\u064a\u0646\u0627\u0631\u064a\u0648", 8);
            }
            if (line.startsWithTitleKeyword("\u0645\u062b\u0627\u0644")) {
                return new KeywordMatcher.Match("\u0645\u062b\u0627\u0644", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0627\u0645\u062b\u0644\u0629")) {
                return new KeywordMatcher.Match("\u0627\u0645\u062b\u0644\u0629", 6);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("\u0639\u0646\u062f\u0645\u0627 ")) {
                return new KeywordMatcher.StepMatch("\u0639\u0646\u062f\u0645\u0627 ", 6, StepKeywordType.ACTION);
            }
            if (line.startsWith("\u0627\u0630\u0627\u064b ")) {
                return new KeywordMatcher.StepMatch("\u0627\u0630\u0627\u064b ", 5, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("\u0628\u0641\u0631\u0636 ")) {
                return new KeywordMatcher.StepMatch("\u0628\u0641\u0631\u0636 ", 5, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u0644\u0643\u0646 ")) {
                return new KeywordMatcher.StepMatch("\u0644\u0643\u0646 ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u0645\u062a\u0649 ")) {
                return new KeywordMatcher.StepMatch("\u0645\u062a\u0649 ", 4, StepKeywordType.ACTION);
            }
            if (line.startsWith("\u062b\u0645 ")) {
                return new KeywordMatcher.StepMatch("\u062b\u0645 ", 3, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            if (line.startsWith("\u0648 ")) {
                return new KeywordMatcher.StepMatch("\u0648 ", 2, StepKeywordType.CONJUNCTION);
            }
            return null;
        }
    }

    private static final class Ast
    implements KeywordMatcher {
        private Ast() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Carauter\u00edstica")) {
                return new KeywordMatcher.Match("Carauter\u00edstica", 15);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Antecedentes")) {
                return new KeywordMatcher.Match("Antecedentes", 13);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Esbozu del casu")) {
                return new KeywordMatcher.Match("Esbozu del casu", 16);
            }
            if (line.startsWithTitleKeyword("Exemplo")) {
                return new KeywordMatcher.Match("Exemplo", 8);
            }
            if (line.startsWithTitleKeyword("Casu")) {
                return new KeywordMatcher.Match("Casu", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Exemplos")) {
                return new KeywordMatcher.Match("Exemplos", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Cuando ")) {
                return new KeywordMatcher.StepMatch("Cuando ", 7, StepKeywordType.ACTION);
            }
            if (line.startsWith("Ent\u00f3s ")) {
                return new KeywordMatcher.StepMatch("Ent\u00f3s ", 6, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Dada ")) {
                return new KeywordMatcher.StepMatch("Dada ", 5, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Daos ")) {
                return new KeywordMatcher.StepMatch("Daos ", 5, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Daes ")) {
                return new KeywordMatcher.StepMatch("Daes ", 5, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Peru ")) {
                return new KeywordMatcher.StepMatch("Peru ", 5, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("D\u00e1u ")) {
                return new KeywordMatcher.StepMatch("D\u00e1u ", 4, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Ya ")) {
                return new KeywordMatcher.StepMatch("Ya ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Y ")) {
                return new KeywordMatcher.StepMatch("Y ", 2, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class Az
    implements KeywordMatcher {
        private Az() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u00d6z\u0259llik")) {
                return new KeywordMatcher.Match("\u00d6z\u0259llik", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Kontekst")) {
                return new KeywordMatcher.Match("Kontekst", 9);
            }
            if (line.startsWithTitleKeyword("Ke\u00e7mi\u015f")) {
                return new KeywordMatcher.Match("Ke\u00e7mi\u015f", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Ssenarinin strukturu")) {
                return new KeywordMatcher.Match("Ssenarinin strukturu", 21);
            }
            if (line.startsWithTitleKeyword("Ssenari")) {
                return new KeywordMatcher.Match("Ssenari", 8);
            }
            if (line.startsWithTitleKeyword("N\u00fcmun\u0259")) {
                return new KeywordMatcher.Match("N\u00fcmun\u0259", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("N\u00fcmun\u0259l\u0259r")) {
                return new KeywordMatcher.Match("N\u00fcmun\u0259l\u0259r", 10);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("N\u0259 vaxt ki ")) {
                return new KeywordMatcher.StepMatch("N\u0259 vaxt ki ", 11, StepKeywordType.ACTION);
            }
            if (line.startsWith("Tutaq ki ")) {
                return new KeywordMatcher.StepMatch("Tutaq ki ", 9, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("O halda ")) {
                return new KeywordMatcher.StepMatch("O halda ", 8, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Verilir ")) {
                return new KeywordMatcher.StepMatch("Verilir ", 8, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Ancaq ")) {
                return new KeywordMatcher.StepMatch("Ancaq ", 6, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u018fg\u0259r ")) {
                return new KeywordMatcher.StepMatch("\u018fg\u0259r ", 5, StepKeywordType.ACTION);
            }
            if (line.startsWith("Amma ")) {
                return new KeywordMatcher.StepMatch("Amma ", 5, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("H\u0259m ")) {
                return new KeywordMatcher.StepMatch("H\u0259m ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("V\u0259 ")) {
                return new KeywordMatcher.StepMatch("V\u0259 ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class Be
    implements KeywordMatcher {
        private Be() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0424\u0443\u043d\u043a\u0446\u044b\u044f\u043d\u0430\u043b\u044c\u043d\u0430\u0441\u0446\u044c")) {
                return new KeywordMatcher.Match("\u0424\u0443\u043d\u043a\u0446\u044b\u044f\u043d\u0430\u043b\u044c\u043d\u0430\u0441\u0446\u044c", 17);
            }
            if (line.startsWithTitleKeyword("\u0424\u0456\u0447\u0430")) {
                return new KeywordMatcher.Match("\u0424\u0456\u0447\u0430", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u041a\u0430\u043d\u0442\u044d\u043a\u0441\u0442")) {
                return new KeywordMatcher.Match("\u041a\u0430\u043d\u0442\u044d\u043a\u0441\u0442", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u041f\u0440\u0430\u0432\u0456\u043b\u044b")) {
                return new KeywordMatcher.Match("\u041f\u0440\u0430\u0432\u0456\u043b\u044b", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0428\u0430\u0431\u043b\u043e\u043d \u0441\u0446\u044d\u043d\u0430\u0440\u044b\u044f")) {
                return new KeywordMatcher.Match("\u0428\u0430\u0431\u043b\u043e\u043d \u0441\u0446\u044d\u043d\u0430\u0440\u044b\u044f", 16);
            }
            if (line.startsWithTitleKeyword("\u0423\u0437\u043e\u0440 \u0441\u0446\u044d\u043d\u0430\u0440\u0430")) {
                return new KeywordMatcher.Match("\u0423\u0437\u043e\u0440 \u0441\u0446\u044d\u043d\u0430\u0440\u0430", 13);
            }
            if (line.startsWithTitleKeyword("\u0421\u0446\u044d\u043d\u0430\u0440\u044b\u0439")) {
                return new KeywordMatcher.Match("\u0421\u0446\u044d\u043d\u0430\u0440\u044b\u0439", 9);
            }
            if (line.startsWithTitleKeyword("C\u0446\u044d\u043d\u0430\u0440")) {
                return new KeywordMatcher.Match("C\u0446\u044d\u043d\u0430\u0440", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u041f\u0440\u044b\u043a\u043b\u0430\u0434\u044b")) {
                return new KeywordMatcher.Match("\u041f\u0440\u044b\u043a\u043b\u0430\u0434\u044b", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("\u0422\u0430\u043a\u0441\u0430\u043c\u0430 ")) {
                return new KeywordMatcher.StepMatch("\u0422\u0430\u043a\u0441\u0430\u043c\u0430 ", 8, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u0414\u0430\u0434\u0437\u0435\u043d\u0430 ")) {
                return new KeywordMatcher.StepMatch("\u0414\u0430\u0434\u0437\u0435\u043d\u0430 ", 8, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u0406\u043d\u0430\u043a\u0448 ")) {
                return new KeywordMatcher.StepMatch("\u0406\u043d\u0430\u043a\u0448 ", 6, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u041d\u044f\u0445\u0430\u0439 ")) {
                return new KeywordMatcher.StepMatch("\u041d\u044f\u0445\u0430\u0439 ", 6, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u041a\u0430\u043b\u0456 ")) {
                return new KeywordMatcher.StepMatch("\u041a\u0430\u043b\u0456 ", 5, StepKeywordType.ACTION);
            }
            if (line.startsWith("\u0422\u0430\u0434\u044b ")) {
                return new KeywordMatcher.StepMatch("\u0422\u0430\u0434\u044b ", 5, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("\u0410\u043b\u0435 ")) {
                return new KeywordMatcher.StepMatch("\u0410\u043b\u0435 ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u0414\u044b ")) {
                return new KeywordMatcher.StepMatch("\u0414\u044b ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            if (line.startsWith("I ")) {
                return new KeywordMatcher.StepMatch("I ", 2, StepKeywordType.CONJUNCTION);
            }
            return null;
        }
    }

    private static final class Bg
    implements KeywordMatcher {
        private Bg() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0424\u0443\u043d\u043a\u0446\u0438\u043e\u043d\u0430\u043b\u043d\u043e\u0441\u0442")) {
                return new KeywordMatcher.Match("\u0424\u0443\u043d\u043a\u0446\u0438\u043e\u043d\u0430\u043b\u043d\u043e\u0441\u0442", 15);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u041f\u0440\u0435\u0434\u0438\u0441\u0442\u043e\u0440\u0438\u044f")) {
                return new KeywordMatcher.Match("\u041f\u0440\u0435\u0434\u0438\u0441\u0442\u043e\u0440\u0438\u044f", 12);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u041f\u0440\u0430\u0432\u0438\u043b\u043e")) {
                return new KeywordMatcher.Match("\u041f\u0440\u0430\u0432\u0438\u043b\u043e", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0420\u0430\u043c\u043a\u0430 \u043d\u0430 \u0441\u0446\u0435\u043d\u0430\u0440\u0438\u0439")) {
                return new KeywordMatcher.Match("\u0420\u0430\u043c\u043a\u0430 \u043d\u0430 \u0441\u0446\u0435\u043d\u0430\u0440\u0438\u0439", 18);
            }
            if (line.startsWithTitleKeyword("\u0421\u0446\u0435\u043d\u0430\u0440\u0438\u0439")) {
                return new KeywordMatcher.Match("\u0421\u0446\u0435\u043d\u0430\u0440\u0438\u0439", 9);
            }
            if (line.startsWithTitleKeyword("\u041f\u0440\u0438\u043c\u0435\u0440")) {
                return new KeywordMatcher.Match("\u041f\u0440\u0438\u043c\u0435\u0440", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u041f\u0440\u0438\u043c\u0435\u0440\u0438")) {
                return new KeywordMatcher.Match("\u041f\u0440\u0438\u043c\u0435\u0440\u0438", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("\u041a\u043e\u0433\u0430\u0442\u043e ")) {
                return new KeywordMatcher.StepMatch("\u041a\u043e\u0433\u0430\u0442\u043e ", 7, StepKeywordType.ACTION);
            }
            if (line.startsWith("\u0414\u0430\u0434\u0435\u043d\u043e ")) {
                return new KeywordMatcher.StepMatch("\u0414\u0430\u0434\u0435\u043d\u043e ", 7, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u041d\u043e ")) {
                return new KeywordMatcher.StepMatch("\u041d\u043e ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u0422\u043e ")) {
                return new KeywordMatcher.StepMatch("\u0422\u043e ", 3, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("\u0418 ")) {
                return new KeywordMatcher.StepMatch("\u0418 ", 2, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class Bm
    implements KeywordMatcher {
        private Bm() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Fungsi")) {
                return new KeywordMatcher.Match("Fungsi", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Latar Belakang")) {
                return new KeywordMatcher.Match("Latar Belakang", 15);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Garis Panduan Senario")) {
                return new KeywordMatcher.Match("Garis Panduan Senario", 22);
            }
            if (line.startsWithTitleKeyword("Kerangka Senario")) {
                return new KeywordMatcher.Match("Kerangka Senario", 17);
            }
            if (line.startsWithTitleKeyword("Kerangka Keadaan")) {
                return new KeywordMatcher.Match("Kerangka Keadaan", 17);
            }
            if (line.startsWithTitleKeyword("Kerangka Situasi")) {
                return new KeywordMatcher.Match("Kerangka Situasi", 17);
            }
            if (line.startsWithTitleKeyword("Keadaan")) {
                return new KeywordMatcher.Match("Keadaan", 8);
            }
            if (line.startsWithTitleKeyword("Senario")) {
                return new KeywordMatcher.Match("Senario", 8);
            }
            if (line.startsWithTitleKeyword("Situasi")) {
                return new KeywordMatcher.Match("Situasi", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Contoh")) {
                return new KeywordMatcher.Match("Contoh", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Kemudian ")) {
                return new KeywordMatcher.StepMatch("Kemudian ", 9, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Apabila ")) {
                return new KeywordMatcher.StepMatch("Apabila ", 8, StepKeywordType.ACTION);
            }
            if (line.startsWith("Diberi ")) {
                return new KeywordMatcher.StepMatch("Diberi ", 7, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Tetapi ")) {
                return new KeywordMatcher.StepMatch("Tetapi ", 7, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Bagi ")) {
                return new KeywordMatcher.StepMatch("Bagi ", 5, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Tapi ")) {
                return new KeywordMatcher.StepMatch("Tapi ", 5, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Maka ")) {
                return new KeywordMatcher.StepMatch("Maka ", 5, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Dan ")) {
                return new KeywordMatcher.StepMatch("Dan ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class Bs
    implements KeywordMatcher {
        private Bs() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Karakteristika")) {
                return new KeywordMatcher.Match("Karakteristika", 15);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Pozadina")) {
                return new KeywordMatcher.Match("Pozadina", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Scenario-outline")) {
                return new KeywordMatcher.Match("Scenario-outline", 17);
            }
            if (line.startsWithTitleKeyword("Scenariju-obris")) {
                return new KeywordMatcher.Match("Scenariju-obris", 16);
            }
            if (line.startsWithTitleKeyword("Scenariju")) {
                return new KeywordMatcher.Match("Scenariju", 10);
            }
            if (line.startsWithTitleKeyword("Scenario")) {
                return new KeywordMatcher.Match("Scenario", 9);
            }
            if (line.startsWithTitleKeyword("Primjer")) {
                return new KeywordMatcher.Match("Primjer", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Primjeri")) {
                return new KeywordMatcher.Match("Primjeri", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Zatim ")) {
                return new KeywordMatcher.StepMatch("Zatim ", 6, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Kada ")) {
                return new KeywordMatcher.StepMatch("Kada ", 5, StepKeywordType.ACTION);
            }
            if (line.startsWith("Dato ")) {
                return new KeywordMatcher.StepMatch("Dato ", 5, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Ali ")) {
                return new KeywordMatcher.StepMatch("Ali ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            if (line.startsWith("I ")) {
                return new KeywordMatcher.StepMatch("I ", 2, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("A ")) {
                return new KeywordMatcher.StepMatch("A ", 2, StepKeywordType.CONJUNCTION);
            }
            return null;
        }
    }

    private static final class Ca
    implements KeywordMatcher {
        private Ca() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Caracter\u00edstica")) {
                return new KeywordMatcher.Match("Caracter\u00edstica", 15);
            }
            if (line.startsWithTitleKeyword("Funcionalitat")) {
                return new KeywordMatcher.Match("Funcionalitat", 14);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Antecedents")) {
                return new KeywordMatcher.Match("Antecedents", 12);
            }
            if (line.startsWithTitleKeyword("Rerefons")) {
                return new KeywordMatcher.Match("Rerefons", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Esquema de l'escenari")) {
                return new KeywordMatcher.Match("Esquema de l'escenari", 22);
            }
            if (line.startsWithTitleKeyword("Escenari")) {
                return new KeywordMatcher.Match("Escenari", 9);
            }
            if (line.startsWithTitleKeyword("Exemple")) {
                return new KeywordMatcher.Match("Exemple", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Exemples")) {
                return new KeywordMatcher.Match("Exemples", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Aleshores ")) {
                return new KeywordMatcher.StepMatch("Aleshores ", 10, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Donada ")) {
                return new KeywordMatcher.StepMatch("Donada ", 7, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Donat ")) {
                return new KeywordMatcher.StepMatch("Donat ", 6, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Atesa ")) {
                return new KeywordMatcher.StepMatch("Atesa ", 6, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Quan ")) {
                return new KeywordMatcher.StepMatch("Quan ", 5, StepKeywordType.ACTION);
            }
            if (line.startsWith("At\u00e8s ")) {
                return new KeywordMatcher.StepMatch("At\u00e8s ", 5, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Per\u00f2 ")) {
                return new KeywordMatcher.StepMatch("Per\u00f2 ", 5, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Cal ")) {
                return new KeywordMatcher.StepMatch("Cal ", 4, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            if (line.startsWith("I ")) {
                return new KeywordMatcher.StepMatch("I ", 2, StepKeywordType.CONJUNCTION);
            }
            return null;
        }
    }

    private static final class Cs
    implements KeywordMatcher {
        private Cs() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Po\u017eadavek")) {
                return new KeywordMatcher.Match("Po\u017eadavek", 10);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Kontext")) {
                return new KeywordMatcher.Match("Kontext", 8);
            }
            if (line.startsWithTitleKeyword("Pozad\u00ed")) {
                return new KeywordMatcher.Match("Pozad\u00ed", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Pravidlo")) {
                return new KeywordMatcher.Match("Pravidlo", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Osnova sc\u00e9n\u00e1\u0159e")) {
                return new KeywordMatcher.Match("Osnova sc\u00e9n\u00e1\u0159e", 15);
            }
            if (line.startsWithTitleKeyword("N\u00e1\u010drt Sc\u00e9n\u00e1\u0159e")) {
                return new KeywordMatcher.Match("N\u00e1\u010drt Sc\u00e9n\u00e1\u0159e", 14);
            }
            if (line.startsWithTitleKeyword("P\u0159\u00edklad")) {
                return new KeywordMatcher.Match("P\u0159\u00edklad", 8);
            }
            if (line.startsWithTitleKeyword("Sc\u00e9n\u00e1\u0159")) {
                return new KeywordMatcher.Match("Sc\u00e9n\u00e1\u0159", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("P\u0159\u00edklady")) {
                return new KeywordMatcher.Match("P\u0159\u00edklady", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Za p\u0159edpokladu ")) {
                return new KeywordMatcher.StepMatch("Za p\u0159edpokladu ", 15, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("A tak\u00e9 ")) {
                return new KeywordMatcher.StepMatch("A tak\u00e9 ", 7, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Pokud ")) {
                return new KeywordMatcher.StepMatch("Pokud ", 6, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Kdy\u017e ")) {
                return new KeywordMatcher.StepMatch("Kdy\u017e ", 5, StepKeywordType.ACTION);
            }
            if (line.startsWith("Pak ")) {
                return new KeywordMatcher.StepMatch("Pak ", 4, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Ale ")) {
                return new KeywordMatcher.StepMatch("Ale ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            if (line.startsWith("A ")) {
                return new KeywordMatcher.StepMatch("A ", 2, StepKeywordType.CONJUNCTION);
            }
            return null;
        }
    }

    private static final class Cy_gb
    implements KeywordMatcher {
        private Cy_gb() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Arwedd")) {
                return new KeywordMatcher.Match("Arwedd", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Cefndir")) {
                return new KeywordMatcher.Match("Cefndir", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Scenario Amlinellol")) {
                return new KeywordMatcher.Match("Scenario Amlinellol", 20);
            }
            if (line.startsWithTitleKeyword("Enghraifft")) {
                return new KeywordMatcher.Match("Enghraifft", 11);
            }
            if (line.startsWithTitleKeyword("Scenario")) {
                return new KeywordMatcher.Match("Scenario", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Enghreifftiau")) {
                return new KeywordMatcher.Match("Enghreifftiau", 14);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Anrhegedig a ")) {
                return new KeywordMatcher.StepMatch("Anrhegedig a ", 13, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Pryd ")) {
                return new KeywordMatcher.StepMatch("Pryd ", 5, StepKeywordType.ACTION);
            }
            if (line.startsWith("Yna ")) {
                return new KeywordMatcher.StepMatch("Yna ", 4, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Ond ")) {
                return new KeywordMatcher.StepMatch("Ond ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            if (line.startsWith("A ")) {
                return new KeywordMatcher.StepMatch("A ", 2, StepKeywordType.CONJUNCTION);
            }
            return null;
        }
    }

    private static final class Da
    implements KeywordMatcher {
        private Da() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Egenskab")) {
                return new KeywordMatcher.Match("Egenskab", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Baggrund")) {
                return new KeywordMatcher.Match("Baggrund", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Regel")) {
                return new KeywordMatcher.Match("Regel", 6);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Abstrakt Scenario")) {
                return new KeywordMatcher.Match("Abstrakt Scenario", 18);
            }
            if (line.startsWithTitleKeyword("Eksempel")) {
                return new KeywordMatcher.Match("Eksempel", 9);
            }
            if (line.startsWithTitleKeyword("Scenarie")) {
                return new KeywordMatcher.Match("Scenarie", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Eksempler")) {
                return new KeywordMatcher.Match("Eksempler", 10);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Givet ")) {
                return new KeywordMatcher.StepMatch("Givet ", 6, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("N\u00e5r ")) {
                return new KeywordMatcher.StepMatch("N\u00e5r ", 4, StepKeywordType.ACTION);
            }
            if (line.startsWith("Men ")) {
                return new KeywordMatcher.StepMatch("Men ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Og ")) {
                return new KeywordMatcher.StepMatch("Og ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("S\u00e5 ")) {
                return new KeywordMatcher.StepMatch("S\u00e5 ", 3, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class De
    implements KeywordMatcher {
        private De() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Funktionalit\u00e4t")) {
                return new KeywordMatcher.Match("Funktionalit\u00e4t", 15);
            }
            if (line.startsWithTitleKeyword("Funktion")) {
                return new KeywordMatcher.Match("Funktion", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Voraussetzungen")) {
                return new KeywordMatcher.Match("Voraussetzungen", 16);
            }
            if (line.startsWithTitleKeyword("Vorbedingungen")) {
                return new KeywordMatcher.Match("Vorbedingungen", 15);
            }
            if (line.startsWithTitleKeyword("Hintergrund")) {
                return new KeywordMatcher.Match("Hintergrund", 12);
            }
            if (line.startsWithTitleKeyword("Grundlage")) {
                return new KeywordMatcher.Match("Grundlage", 10);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Regel")) {
                return new KeywordMatcher.Match("Regel", 6);
            }
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Szenariogrundriss")) {
                return new KeywordMatcher.Match("Szenariogrundriss", 18);
            }
            if (line.startsWithTitleKeyword("Szenarien")) {
                return new KeywordMatcher.Match("Szenarien", 10);
            }
            if (line.startsWithTitleKeyword("Szenario")) {
                return new KeywordMatcher.Match("Szenario", 9);
            }
            if (line.startsWithTitleKeyword("Beispiel")) {
                return new KeywordMatcher.Match("Beispiel", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Beispiele")) {
                return new KeywordMatcher.Match("Beispiele", 10);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Gegeben seien ")) {
                return new KeywordMatcher.StepMatch("Gegeben seien ", 14, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Gegeben sei ")) {
                return new KeywordMatcher.StepMatch("Gegeben sei ", 12, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Angenommen ")) {
                return new KeywordMatcher.StepMatch("Angenommen ", 11, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Wenn ")) {
                return new KeywordMatcher.StepMatch("Wenn ", 5, StepKeywordType.ACTION);
            }
            if (line.startsWith("Dann ")) {
                return new KeywordMatcher.StepMatch("Dann ", 5, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Aber ")) {
                return new KeywordMatcher.StepMatch("Aber ", 5, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Und ")) {
                return new KeywordMatcher.StepMatch("Und ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class El
    implements KeywordMatcher {
        private El() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0394\u03c5\u03bd\u03b1\u03c4\u03cc\u03c4\u03b7\u03c4\u03b1")) {
                return new KeywordMatcher.Match("\u0394\u03c5\u03bd\u03b1\u03c4\u03cc\u03c4\u03b7\u03c4\u03b1", 11);
            }
            if (line.startsWithTitleKeyword("\u039b\u03b5\u03b9\u03c4\u03bf\u03c5\u03c1\u03b3\u03af\u03b1")) {
                return new KeywordMatcher.Match("\u039b\u03b5\u03b9\u03c4\u03bf\u03c5\u03c1\u03b3\u03af\u03b1", 11);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u03a5\u03c0\u03cc\u03b2\u03b1\u03b8\u03c1\u03bf")) {
                return new KeywordMatcher.Match("\u03a5\u03c0\u03cc\u03b2\u03b1\u03b8\u03c1\u03bf", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u03a0\u03b5\u03c1\u03af\u03b3\u03c1\u03b1\u03bc\u03bc\u03b1 \u03a3\u03b5\u03bd\u03b1\u03c1\u03af\u03bf\u03c5")) {
                return new KeywordMatcher.Match("\u03a0\u03b5\u03c1\u03af\u03b3\u03c1\u03b1\u03bc\u03bc\u03b1 \u03a3\u03b5\u03bd\u03b1\u03c1\u03af\u03bf\u03c5", 20);
            }
            if (line.startsWithTitleKeyword("\u03a0\u03b5\u03c1\u03b9\u03b3\u03c1\u03b1\u03c6\u03ae \u03a3\u03b5\u03bd\u03b1\u03c1\u03af\u03bf\u03c5")) {
                return new KeywordMatcher.Match("\u03a0\u03b5\u03c1\u03b9\u03b3\u03c1\u03b1\u03c6\u03ae \u03a3\u03b5\u03bd\u03b1\u03c1\u03af\u03bf\u03c5", 19);
            }
            if (line.startsWithTitleKeyword("\u03a0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9\u03b3\u03bc\u03b1")) {
                return new KeywordMatcher.Match("\u03a0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9\u03b3\u03bc\u03b1", 11);
            }
            if (line.startsWithTitleKeyword("\u03a3\u03b5\u03bd\u03ac\u03c1\u03b9\u03bf")) {
                return new KeywordMatcher.Match("\u03a3\u03b5\u03bd\u03ac\u03c1\u03b9\u03bf", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u03a0\u03b1\u03c1\u03b1\u03b4\u03b5\u03af\u03b3\u03bc\u03b1\u03c4\u03b1")) {
                return new KeywordMatcher.Match("\u03a0\u03b1\u03c1\u03b1\u03b4\u03b5\u03af\u03b3\u03bc\u03b1\u03c4\u03b1", 13);
            }
            if (line.startsWithTitleKeyword("\u03a3\u03b5\u03bd\u03ac\u03c1\u03b9\u03b1")) {
                return new KeywordMatcher.Match("\u03a3\u03b5\u03bd\u03ac\u03c1\u03b9\u03b1", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("\u0394\u03b5\u03b4\u03bf\u03bc\u03ad\u03bd\u03bf\u03c5 ")) {
                return new KeywordMatcher.StepMatch("\u0394\u03b5\u03b4\u03bf\u03bc\u03ad\u03bd\u03bf\u03c5 ", 10, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u038c\u03c4\u03b1\u03bd ")) {
                return new KeywordMatcher.StepMatch("\u038c\u03c4\u03b1\u03bd ", 5, StepKeywordType.ACTION);
            }
            if (line.startsWith("\u0391\u03bb\u03bb\u03ac ")) {
                return new KeywordMatcher.StepMatch("\u0391\u03bb\u03bb\u03ac ", 5, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u03a4\u03cc\u03c4\u03b5 ")) {
                return new KeywordMatcher.StepMatch("\u03a4\u03cc\u03c4\u03b5 ", 5, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("\u039a\u03b1\u03b9 ")) {
                return new KeywordMatcher.StepMatch("\u039a\u03b1\u03b9 ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class Em
    implements KeywordMatcher {
        private Em() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("\ud83d\udcda")) {
                return new KeywordMatcher.Match("\ud83d\udcda", 3);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("\ud83d\udca4")) {
                return new KeywordMatcher.Match("\ud83d\udca4", 3);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("\ud83d\udcd6")) {
                return new KeywordMatcher.Match("\ud83d\udcd6", 3);
            }
            if (line.startsWithTitleKeyword("\ud83d\udcd5")) {
                return new KeywordMatcher.Match("\ud83d\udcd5", 3);
            }
            if (line.startsWithTitleKeyword("\ud83e\udd52")) {
                return new KeywordMatcher.Match("\ud83e\udd52", 3);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("\ud83d\udcd3")) {
                return new KeywordMatcher.Match("\ud83d\udcd3", 3);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("\ud83d\ude10")) {
                return new KeywordMatcher.StepMatch("\ud83d\ude10", 2, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\ud83d\ude4f")) {
                return new KeywordMatcher.StepMatch("\ud83d\ude4f", 2, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("\ud83c\udfac")) {
                return new KeywordMatcher.StepMatch("\ud83c\udfac", 2, StepKeywordType.ACTION);
            }
            if (line.startsWith("\ud83d\ude14")) {
                return new KeywordMatcher.StepMatch("\ud83d\ude14", 2, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            if (line.startsWith("\ud83d\ude02")) {
                return new KeywordMatcher.StepMatch("\ud83d\ude02", 2, StepKeywordType.CONJUNCTION);
            }
            return null;
        }
    }

    private static final class En
    implements KeywordMatcher {
        private En() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Business Need")) {
                return new KeywordMatcher.Match("Business Need", 14);
            }
            if (line.startsWithTitleKeyword("Ability")) {
                return new KeywordMatcher.Match("Ability", 8);
            }
            if (line.startsWithTitleKeyword("Feature")) {
                return new KeywordMatcher.Match("Feature", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Background")) {
                return new KeywordMatcher.Match("Background", 11);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Scenario Template")) {
                return new KeywordMatcher.Match("Scenario Template", 18);
            }
            if (line.startsWithTitleKeyword("Scenario Outline")) {
                return new KeywordMatcher.Match("Scenario Outline", 17);
            }
            if (line.startsWithTitleKeyword("Scenario")) {
                return new KeywordMatcher.Match("Scenario", 9);
            }
            if (line.startsWithTitleKeyword("Example")) {
                return new KeywordMatcher.Match("Example", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Scenarios")) {
                return new KeywordMatcher.Match("Scenarios", 10);
            }
            if (line.startsWithTitleKeyword("Examples")) {
                return new KeywordMatcher.Match("Examples", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Given ")) {
                return new KeywordMatcher.StepMatch("Given ", 6, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Then ")) {
                return new KeywordMatcher.StepMatch("Then ", 5, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("When ")) {
                return new KeywordMatcher.StepMatch("When ", 5, StepKeywordType.ACTION);
            }
            if (line.startsWith("But ")) {
                return new KeywordMatcher.StepMatch("But ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("And ")) {
                return new KeywordMatcher.StepMatch("And ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class En_scouse
    implements KeywordMatcher {
        private En_scouse() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Feature")) {
                return new KeywordMatcher.Match("Feature", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Dis is what went down")) {
                return new KeywordMatcher.Match("Dis is what went down", 22);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("The thing of it is")) {
                return new KeywordMatcher.Match("The thing of it is", 19);
            }
            if (line.startsWithTitleKeyword("Wharrimean is")) {
                return new KeywordMatcher.Match("Wharrimean is", 14);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Examples")) {
                return new KeywordMatcher.Match("Examples", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Youse know when youse got ")) {
                return new KeywordMatcher.StepMatch("Youse know when youse got ", 26, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Youse know like when ")) {
                return new KeywordMatcher.StepMatch("Youse know like when ", 21, StepKeywordType.ACTION);
            }
            if (line.startsWith("Den youse gotta ")) {
                return new KeywordMatcher.StepMatch("Den youse gotta ", 16, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Givun ")) {
                return new KeywordMatcher.StepMatch("Givun ", 6, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Dun ")) {
                return new KeywordMatcher.StepMatch("Dun ", 4, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Buh ")) {
                return new KeywordMatcher.StepMatch("Buh ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Wun ")) {
                return new KeywordMatcher.StepMatch("Wun ", 4, StepKeywordType.ACTION);
            }
            if (line.startsWith("An ")) {
                return new KeywordMatcher.StepMatch("An ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class En_au
    implements KeywordMatcher {
        private En_au() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Pretty much")) {
                return new KeywordMatcher.Match("Pretty much", 12);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("First off")) {
                return new KeywordMatcher.Match("First off", 10);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Reckon it's like")) {
                return new KeywordMatcher.Match("Reckon it's like", 17);
            }
            if (line.startsWithTitleKeyword("Awww, look mate")) {
                return new KeywordMatcher.Match("Awww, look mate", 16);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("You'll wanna")) {
                return new KeywordMatcher.Match("You'll wanna", 13);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("But at the end of the day I reckon ")) {
                return new KeywordMatcher.StepMatch("But at the end of the day I reckon ", 35, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("It's just unbelievable ")) {
                return new KeywordMatcher.StepMatch("It's just unbelievable ", 23, StepKeywordType.ACTION);
            }
            if (line.startsWith("Too right ")) {
                return new KeywordMatcher.StepMatch("Too right ", 10, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Yeah nah ")) {
                return new KeywordMatcher.StepMatch("Yeah nah ", 9, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Y'know ")) {
                return new KeywordMatcher.StepMatch("Y'know ", 7, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class En_lol
    implements KeywordMatcher {
        private En_lol() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("OH HAI")) {
                return new KeywordMatcher.Match("OH HAI", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("B4")) {
                return new KeywordMatcher.Match("B4", 3);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("MISHUN SRSLY")) {
                return new KeywordMatcher.Match("MISHUN SRSLY", 13);
            }
            if (line.startsWithTitleKeyword("MISHUN")) {
                return new KeywordMatcher.Match("MISHUN", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("EXAMPLZ")) {
                return new KeywordMatcher.Match("EXAMPLZ", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("I CAN HAZ ")) {
                return new KeywordMatcher.StepMatch("I CAN HAZ ", 10, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("BUT ")) {
                return new KeywordMatcher.StepMatch("BUT ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("WEN ")) {
                return new KeywordMatcher.StepMatch("WEN ", 4, StepKeywordType.ACTION);
            }
            if (line.startsWith("DEN ")) {
                return new KeywordMatcher.StepMatch("DEN ", 4, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("AN ")) {
                return new KeywordMatcher.StepMatch("AN ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class En_old
    implements KeywordMatcher {
        private En_old() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Hwaet")) {
                return new KeywordMatcher.Match("Hwaet", 6);
            }
            if (line.startsWithTitleKeyword("Hw\u00e6t")) {
                return new KeywordMatcher.Match("Hw\u00e6t", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Aer")) {
                return new KeywordMatcher.Match("Aer", 4);
            }
            if (line.startsWithTitleKeyword("\u00c6r")) {
                return new KeywordMatcher.Match("\u00c6r", 3);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Swa hwaer swa")) {
                return new KeywordMatcher.Match("Swa hwaer swa", 14);
            }
            if (line.startsWithTitleKeyword("Swa hw\u00e6r swa")) {
                return new KeywordMatcher.Match("Swa hw\u00e6r swa", 13);
            }
            if (line.startsWithTitleKeyword("Swa")) {
                return new KeywordMatcher.Match("Swa", 4);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Se the")) {
                return new KeywordMatcher.Match("Se the", 7);
            }
            if (line.startsWithTitleKeyword("Se \u00f0e")) {
                return new KeywordMatcher.Match("Se \u00f0e", 6);
            }
            if (line.startsWithTitleKeyword("Se \u00fee")) {
                return new KeywordMatcher.Match("Se \u00fee", 6);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("B\u00e6\u00fesealfa ")) {
                return new KeywordMatcher.StepMatch("B\u00e6\u00fesealfa ", 10, StepKeywordType.ACTION);
            }
            if (line.startsWith("B\u00e6\u00fesealfe ")) {
                return new KeywordMatcher.StepMatch("B\u00e6\u00fesealfe ", 10, StepKeywordType.ACTION);
            }
            if (line.startsWith("Ciric\u00e6wa ")) {
                return new KeywordMatcher.StepMatch("Ciric\u00e6wa ", 9, StepKeywordType.ACTION);
            }
            if (line.startsWith("Ciric\u00e6we ")) {
                return new KeywordMatcher.StepMatch("Ciric\u00e6we ", 9, StepKeywordType.ACTION);
            }
            if (line.startsWith("B\u00e6\u00fesealf ")) {
                return new KeywordMatcher.StepMatch("B\u00e6\u00fesealf ", 9, StepKeywordType.ACTION);
            }
            if (line.startsWith("Tha the ")) {
                return new KeywordMatcher.StepMatch("Tha the ", 8, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Ciric\u00e6w ")) {
                return new KeywordMatcher.StepMatch("Ciric\u00e6w ", 8, StepKeywordType.ACTION);
            }
            if (line.startsWith("\u00dea \u00fee ")) {
                return new KeywordMatcher.StepMatch("\u00dea \u00fee ", 6, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("\u00d0a \u00f0e ")) {
                return new KeywordMatcher.StepMatch("\u00d0a \u00f0e ", 6, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Thurh ")) {
                return new KeywordMatcher.StepMatch("Thurh ", 6, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u00d0urh ")) {
                return new KeywordMatcher.StepMatch("\u00d0urh ", 5, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u00deurh ")) {
                return new KeywordMatcher.StepMatch("\u00deurh ", 5, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Tha ")) {
                return new KeywordMatcher.StepMatch("Tha ", 4, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Ond ")) {
                return new KeywordMatcher.StepMatch("Ond ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u00d0a ")) {
                return new KeywordMatcher.StepMatch("\u00d0a ", 3, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("\u00dea ")) {
                return new KeywordMatcher.StepMatch("\u00dea ", 3, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Ac ")) {
                return new KeywordMatcher.StepMatch("Ac ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("7 ")) {
                return new KeywordMatcher.StepMatch("7 ", 2, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class En_pirate
    implements KeywordMatcher {
        private En_pirate() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Ahoy matey!")) {
                return new KeywordMatcher.Match("Ahoy matey!", 12);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Yo-ho-ho")) {
                return new KeywordMatcher.Match("Yo-ho-ho", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Shiver me timbers")) {
                return new KeywordMatcher.Match("Shiver me timbers", 18);
            }
            if (line.startsWithTitleKeyword("Heave to")) {
                return new KeywordMatcher.Match("Heave to", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Dead men tell no tales")) {
                return new KeywordMatcher.Match("Dead men tell no tales", 23);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Let go and haul ")) {
                return new KeywordMatcher.StepMatch("Let go and haul ", 16, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Gangway! ")) {
                return new KeywordMatcher.StepMatch("Gangway! ", 9, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Blimey! ")) {
                return new KeywordMatcher.StepMatch("Blimey! ", 8, StepKeywordType.ACTION);
            }
            if (line.startsWith("Avast! ")) {
                return new KeywordMatcher.StepMatch("Avast! ", 7, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Aye ")) {
                return new KeywordMatcher.StepMatch("Aye ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class En_tx
    implements KeywordMatcher {
        private En_tx() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("This ain\u2019t my first rodeo")) {
                return new KeywordMatcher.Match("This ain\u2019t my first rodeo", 26);
            }
            if (line.startsWithTitleKeyword("All gussied up")) {
                return new KeywordMatcher.Match("All gussied up", 15);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Lemme tell y'all a story")) {
                return new KeywordMatcher.Match("Lemme tell y'all a story", 25);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule ")) {
                return new KeywordMatcher.Match("Rule ", 6);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Busy as a hound in flea season")) {
                return new KeywordMatcher.Match("Busy as a hound in flea season", 31);
            }
            if (line.startsWithTitleKeyword("Serious as a snake bite")) {
                return new KeywordMatcher.Match("Serious as a snake bite", 24);
            }
            if (line.startsWithTitleKeyword("All hat and no cattle")) {
                return new KeywordMatcher.Match("All hat and no cattle", 22);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Now that's a story longer than a cattle drive in July")) {
                return new KeywordMatcher.Match("Now that's a story longer than a cattle drive in July", 54);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("There\u2019s no tree but bears some fruit ")) {
                return new KeywordMatcher.StepMatch("There\u2019s no tree but bears some fruit ", 37, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Well now hold on, I'll you what ")) {
                return new KeywordMatcher.StepMatch("Well now hold on, I'll you what ", 32, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Come hell or high water ")) {
                return new KeywordMatcher.StepMatch("Come hell or high water ", 24, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Quick out of the chute ")) {
                return new KeywordMatcher.StepMatch("Quick out of the chute ", 23, StepKeywordType.ACTION);
            }
            if (line.startsWith("All git out ")) {
                return new KeywordMatcher.StepMatch("All git out ", 12, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Fixin' to ")) {
                return new KeywordMatcher.StepMatch("Fixin' to ", 10, StepKeywordType.CONTEXT);
            }
            return null;
        }
    }

    private static final class Eo
    implements KeywordMatcher {
        private Eo() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Trajto")) {
                return new KeywordMatcher.Match("Trajto", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Fono")) {
                return new KeywordMatcher.Match("Fono", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Regulo")) {
                return new KeywordMatcher.Match("Regulo", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Konturo de la scenaro")) {
                return new KeywordMatcher.Match("Konturo de la scenaro", 22);
            }
            if (line.startsWithTitleKeyword("Kazo-skizo")) {
                return new KeywordMatcher.Match("Kazo-skizo", 11);
            }
            if (line.startsWithTitleKeyword("Ekzemplo")) {
                return new KeywordMatcher.Match("Ekzemplo", 9);
            }
            if (line.startsWithTitleKeyword("Scenaro")) {
                return new KeywordMatcher.Match("Scenaro", 8);
            }
            if (line.startsWithTitleKeyword("Skizo")) {
                return new KeywordMatcher.Match("Skizo", 6);
            }
            if (line.startsWithTitleKeyword("Kazo")) {
                return new KeywordMatcher.Match("Kazo", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Ekzemploj")) {
                return new KeywordMatcher.Match("Ekzemploj", 10);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Donita\u0135o ")) {
                return new KeywordMatcher.StepMatch("Donita\u0135o ", 9, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Komence ")) {
                return new KeywordMatcher.StepMatch("Komence ", 8, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Sed ")) {
                return new KeywordMatcher.StepMatch("Sed ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Kaj ")) {
                return new KeywordMatcher.StepMatch("Kaj ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Se ")) {
                return new KeywordMatcher.StepMatch("Se ", 3, StepKeywordType.ACTION);
            }
            if (line.startsWith("Do ")) {
                return new KeywordMatcher.StepMatch("Do ", 3, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class Es
    implements KeywordMatcher {
        private Es() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Necesidad del negocio")) {
                return new KeywordMatcher.Match("Necesidad del negocio", 22);
            }
            if (line.startsWithTitleKeyword("Caracter\u00edstica")) {
                return new KeywordMatcher.Match("Caracter\u00edstica", 15);
            }
            if (line.startsWithTitleKeyword("Requisito")) {
                return new KeywordMatcher.Match("Requisito", 10);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Antecedentes")) {
                return new KeywordMatcher.Match("Antecedentes", 13);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Regla de negocio")) {
                return new KeywordMatcher.Match("Regla de negocio", 17);
            }
            if (line.startsWithTitleKeyword("Regla")) {
                return new KeywordMatcher.Match("Regla", 6);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Esquema del escenario")) {
                return new KeywordMatcher.Match("Esquema del escenario", 22);
            }
            if (line.startsWithTitleKeyword("Escenario")) {
                return new KeywordMatcher.Match("Escenario", 10);
            }
            if (line.startsWithTitleKeyword("Ejemplo")) {
                return new KeywordMatcher.Match("Ejemplo", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Ejemplos")) {
                return new KeywordMatcher.Match("Ejemplos", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Entonces ")) {
                return new KeywordMatcher.StepMatch("Entonces ", 9, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Cuando ")) {
                return new KeywordMatcher.StepMatch("Cuando ", 7, StepKeywordType.ACTION);
            }
            if (line.startsWith("Dadas ")) {
                return new KeywordMatcher.StepMatch("Dadas ", 6, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Dados ")) {
                return new KeywordMatcher.StepMatch("Dados ", 6, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Dada ")) {
                return new KeywordMatcher.StepMatch("Dada ", 5, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Dado ")) {
                return new KeywordMatcher.StepMatch("Dado ", 5, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Pero ")) {
                return new KeywordMatcher.StepMatch("Pero ", 5, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Y ")) {
                return new KeywordMatcher.StepMatch("Y ", 2, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            if (line.startsWith("E ")) {
                return new KeywordMatcher.StepMatch("E ", 2, StepKeywordType.CONJUNCTION);
            }
            return null;
        }
    }

    private static final class Et
    implements KeywordMatcher {
        private Et() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Omadus")) {
                return new KeywordMatcher.Match("Omadus", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Taust")) {
                return new KeywordMatcher.Match("Taust", 6);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Reegel")) {
                return new KeywordMatcher.Match("Reegel", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Raamstsenaarium")) {
                return new KeywordMatcher.Match("Raamstsenaarium", 16);
            }
            if (line.startsWithTitleKeyword("Stsenaarium")) {
                return new KeywordMatcher.Match("Stsenaarium", 12);
            }
            if (line.startsWithTitleKeyword("Raamjuhtum")) {
                return new KeywordMatcher.Match("Raamjuhtum", 11);
            }
            if (line.startsWithTitleKeyword("Juhtum")) {
                return new KeywordMatcher.Match("Juhtum", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Juhtumid")) {
                return new KeywordMatcher.Match("Juhtumid", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Eeldades ")) {
                return new KeywordMatcher.StepMatch("Eeldades ", 9, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Siis ")) {
                return new KeywordMatcher.StepMatch("Siis ", 5, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Kuid ")) {
                return new KeywordMatcher.StepMatch("Kuid ", 5, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Kui ")) {
                return new KeywordMatcher.StepMatch("Kui ", 4, StepKeywordType.ACTION);
            }
            if (line.startsWith("Ja ")) {
                return new KeywordMatcher.StepMatch("Ja ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class Fa
    implements KeywordMatcher {
        private Fa() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0648\u0650\u06cc\u0698\u06af\u06cc")) {
                return new KeywordMatcher.Match("\u0648\u0650\u06cc\u0698\u06af\u06cc", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0632\u0645\u06cc\u0646\u0647")) {
                return new KeywordMatcher.Match("\u0632\u0645\u06cc\u0646\u0647", 6);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0627\u0644\u06af\u0648\u06cc \u0633\u0646\u0627\u0631\u06cc\u0648")) {
                return new KeywordMatcher.Match("\u0627\u0644\u06af\u0648\u06cc \u0633\u0646\u0627\u0631\u06cc\u0648", 13);
            }
            if (line.startsWithTitleKeyword("\u0633\u0646\u0627\u0631\u06cc\u0648")) {
                return new KeywordMatcher.Match("\u0633\u0646\u0627\u0631\u06cc\u0648", 7);
            }
            if (line.startsWithTitleKeyword("\u0645\u062b\u0627\u0644")) {
                return new KeywordMatcher.Match("\u0645\u062b\u0627\u0644", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0646\u0645\u0648\u0646\u0647 \u0647\u0627")) {
                return new KeywordMatcher.Match("\u0646\u0645\u0648\u0646\u0647 \u0647\u0627", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("\u0628\u0627 \u0641\u0631\u0636 ")) {
                return new KeywordMatcher.StepMatch("\u0628\u0627 \u0641\u0631\u0636 ", 7, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u0647\u0646\u06af\u0627\u0645\u06cc ")) {
                return new KeywordMatcher.StepMatch("\u0647\u0646\u06af\u0627\u0645\u06cc ", 7, StepKeywordType.ACTION);
            }
            if (line.startsWith("\u0622\u0646\u06af\u0627\u0647 ")) {
                return new KeywordMatcher.StepMatch("\u0622\u0646\u06af\u0627\u0647 ", 6, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("\u0627\u0645\u0627 ")) {
                return new KeywordMatcher.StepMatch("\u0627\u0645\u0627 ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            if (line.startsWith("\u0648 ")) {
                return new KeywordMatcher.StepMatch("\u0648 ", 2, StepKeywordType.CONJUNCTION);
            }
            return null;
        }
    }

    private static final class Fi
    implements KeywordMatcher {
        private Fi() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Ominaisuus")) {
                return new KeywordMatcher.Match("Ominaisuus", 11);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Tausta")) {
                return new KeywordMatcher.Match("Tausta", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Tapausaihio")) {
                return new KeywordMatcher.Match("Tapausaihio", 12);
            }
            if (line.startsWithTitleKeyword("Tapaus")) {
                return new KeywordMatcher.Match("Tapaus", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Tapaukset")) {
                return new KeywordMatcher.Match("Tapaukset", 10);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Oletetaan ")) {
                return new KeywordMatcher.StepMatch("Oletetaan ", 10, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Mutta ")) {
                return new KeywordMatcher.StepMatch("Mutta ", 6, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Niin ")) {
                return new KeywordMatcher.StepMatch("Niin ", 5, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Kun ")) {
                return new KeywordMatcher.StepMatch("Kun ", 4, StepKeywordType.ACTION);
            }
            if (line.startsWith("Ja ")) {
                return new KeywordMatcher.StepMatch("Ja ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class Fr
    implements KeywordMatcher {
        private Fr() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Fonctionnalit\u00e9")) {
                return new KeywordMatcher.Match("Fonctionnalit\u00e9", 15);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Contexte")) {
                return new KeywordMatcher.Match("Contexte", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("R\u00e8gle")) {
                return new KeywordMatcher.Match("R\u00e8gle", 6);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Plan du Sc\u00e9nario")) {
                return new KeywordMatcher.Match("Plan du Sc\u00e9nario", 17);
            }
            if (line.startsWithTitleKeyword("Plan du sc\u00e9nario")) {
                return new KeywordMatcher.Match("Plan du sc\u00e9nario", 17);
            }
            if (line.startsWithTitleKeyword("Sc\u00e9nario")) {
                return new KeywordMatcher.Match("Sc\u00e9nario", 9);
            }
            if (line.startsWithTitleKeyword("Exemple")) {
                return new KeywordMatcher.Match("Exemple", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Exemples")) {
                return new KeywordMatcher.Match("Exemples", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Etant donn\u00e9 que ")) {
                return new KeywordMatcher.StepMatch("Etant donn\u00e9 que ", 16, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u00c9tant donn\u00e9 que ")) {
                return new KeywordMatcher.StepMatch("\u00c9tant donn\u00e9 que ", 16, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u00c9tant donn\u00e9 qu'")) {
                return new KeywordMatcher.StepMatch("\u00c9tant donn\u00e9 qu'", 15, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Etant donn\u00e9 qu'")) {
                return new KeywordMatcher.StepMatch("Etant donn\u00e9 qu'", 15, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Etant donn\u00e9es ")) {
                return new KeywordMatcher.StepMatch("Etant donn\u00e9es ", 14, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u00c9tant donn\u00e9es ")) {
                return new KeywordMatcher.StepMatch("\u00c9tant donn\u00e9es ", 14, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Etant donn\u00e9s ")) {
                return new KeywordMatcher.StepMatch("Etant donn\u00e9s ", 13, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u00c9tant donn\u00e9e ")) {
                return new KeywordMatcher.StepMatch("\u00c9tant donn\u00e9e ", 13, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Etant donn\u00e9e ")) {
                return new KeywordMatcher.StepMatch("Etant donn\u00e9e ", 13, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u00c9tant donn\u00e9s ")) {
                return new KeywordMatcher.StepMatch("\u00c9tant donn\u00e9s ", 13, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Etant donn\u00e9 ")) {
                return new KeywordMatcher.StepMatch("Etant donn\u00e9 ", 12, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u00c9tant donn\u00e9 ")) {
                return new KeywordMatcher.StepMatch("\u00c9tant donn\u00e9 ", 12, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Sachant que ")) {
                return new KeywordMatcher.StepMatch("Sachant que ", 12, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Sachant qu'")) {
                return new KeywordMatcher.StepMatch("Sachant qu'", 11, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Mais que ")) {
                return new KeywordMatcher.StepMatch("Mais que ", 9, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Mais qu'")) {
                return new KeywordMatcher.StepMatch("Mais qu'", 8, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Lorsque ")) {
                return new KeywordMatcher.StepMatch("Lorsque ", 8, StepKeywordType.ACTION);
            }
            if (line.startsWith("Sachant ")) {
                return new KeywordMatcher.StepMatch("Sachant ", 8, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Et que ")) {
                return new KeywordMatcher.StepMatch("Et que ", 7, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Lorsqu'")) {
                return new KeywordMatcher.StepMatch("Lorsqu'", 7, StepKeywordType.ACTION);
            }
            if (line.startsWith("Et qu'")) {
                return new KeywordMatcher.StepMatch("Et qu'", 6, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Alors ")) {
                return new KeywordMatcher.StepMatch("Alors ", 6, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Quand ")) {
                return new KeywordMatcher.StepMatch("Quand ", 6, StepKeywordType.ACTION);
            }
            if (line.startsWith("Soit ")) {
                return new KeywordMatcher.StepMatch("Soit ", 5, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Mais ")) {
                return new KeywordMatcher.StepMatch("Mais ", 5, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Donc ")) {
                return new KeywordMatcher.StepMatch("Donc ", 5, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Et ")) {
                return new KeywordMatcher.StepMatch("Et ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class Ga
    implements KeywordMatcher {
        private Ga() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Gn\u00e9")) {
                return new KeywordMatcher.Match("Gn\u00e9", 4);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("C\u00falra")) {
                return new KeywordMatcher.Match("C\u00falra", 6);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Riail")) {
                return new KeywordMatcher.Match("Riail", 6);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("C\u00e1s Achomair")) {
                return new KeywordMatcher.Match("C\u00e1s Achomair", 13);
            }
            if (line.startsWithTitleKeyword("Sampla")) {
                return new KeywordMatcher.Match("Sampla", 7);
            }
            if (line.startsWithTitleKeyword("C\u00e1s")) {
                return new KeywordMatcher.Match("C\u00e1s", 4);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Sampla\u00ed")) {
                return new KeywordMatcher.Match("Sampla\u00ed", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Cuir i gc\u00e1s nach ")) {
                return new KeywordMatcher.StepMatch("Cuir i gc\u00e1s nach ", 17, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Cuir i gc\u00e1s gur ")) {
                return new KeywordMatcher.StepMatch("Cuir i gc\u00e1s gur ", 16, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Cuir i gc\u00e1s n\u00e1r ")) {
                return new KeywordMatcher.StepMatch("Cuir i gc\u00e1s n\u00e1r ", 16, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Cuir i gc\u00e1s go ")) {
                return new KeywordMatcher.StepMatch("Cuir i gc\u00e1s go ", 15, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Nuair nach ")) {
                return new KeywordMatcher.StepMatch("Nuair nach ", 11, StepKeywordType.ACTION);
            }
            if (line.startsWith("Nuair n\u00e1r ")) {
                return new KeywordMatcher.StepMatch("Nuair n\u00e1r ", 10, StepKeywordType.ACTION);
            }
            if (line.startsWith("Nuair ba ")) {
                return new KeywordMatcher.StepMatch("Nuair ba ", 9, StepKeywordType.ACTION);
            }
            if (line.startsWith("Nuair a ")) {
                return new KeywordMatcher.StepMatch("Nuair a ", 8, StepKeywordType.ACTION);
            }
            if (line.startsWith("Ansin ")) {
                return new KeywordMatcher.StepMatch("Ansin ", 6, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Agus ")) {
                return new KeywordMatcher.StepMatch("Agus ", 5, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Ach ")) {
                return new KeywordMatcher.StepMatch("Ach ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class Gj
    implements KeywordMatcher {
        private Gj() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0ab5\u0acd\u0aaf\u0abe\u0aaa\u0abe\u0ab0 \u0a9c\u0ab0\u0ac2\u0ab0")) {
                return new KeywordMatcher.Match("\u0ab5\u0acd\u0aaf\u0abe\u0aaa\u0abe\u0ab0 \u0a9c\u0ab0\u0ac2\u0ab0", 13);
            }
            if (line.startsWithTitleKeyword("\u0a95\u0acd\u0ab7\u0aae\u0aa4\u0abe")) {
                return new KeywordMatcher.Match("\u0a95\u0acd\u0ab7\u0aae\u0aa4\u0abe", 7);
            }
            if (line.startsWithTitleKeyword("\u0ab2\u0a95\u0acd\u0ab7\u0aa3")) {
                return new KeywordMatcher.Match("\u0ab2\u0a95\u0acd\u0ab7\u0aa3", 6);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0aac\u0ac7\u0a95\u0a97\u0acd\u0ab0\u0abe\u0a89\u0aa8\u0acd\u0aa1")) {
                return new KeywordMatcher.Match("\u0aac\u0ac7\u0a95\u0a97\u0acd\u0ab0\u0abe\u0a89\u0aa8\u0acd\u0aa1", 12);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0aa8\u0abf\u0aaf\u0aae")) {
                return new KeywordMatcher.Match("\u0aa8\u0abf\u0aaf\u0aae", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0aaa\u0ab0\u0abf\u0aa6\u0acd\u0aa6\u0ab6\u0acd\u0aaf \u0ab0\u0ac2\u0aaa\u0ab0\u0ac7\u0a96\u0abe")) {
                return new KeywordMatcher.Match("\u0aaa\u0ab0\u0abf\u0aa6\u0acd\u0aa6\u0ab6\u0acd\u0aaf \u0ab0\u0ac2\u0aaa\u0ab0\u0ac7\u0a96\u0abe", 18);
            }
            if (line.startsWithTitleKeyword("\u0aaa\u0ab0\u0abf\u0aa6\u0acd\u0aa6\u0ab6\u0acd\u0aaf \u0aa2\u0abe\u0a82\u0a9a\u0acb")) {
                return new KeywordMatcher.Match("\u0aaa\u0ab0\u0abf\u0aa6\u0acd\u0aa6\u0ab6\u0acd\u0aaf \u0aa2\u0abe\u0a82\u0a9a\u0acb", 16);
            }
            if (line.startsWithTitleKeyword("\u0ab8\u0acd\u0aa5\u0abf\u0aa4\u0abf")) {
                return new KeywordMatcher.Match("\u0ab8\u0acd\u0aa5\u0abf\u0aa4\u0abf", 7);
            }
            if (line.startsWithTitleKeyword("\u0a89\u0aa6\u0abe\u0ab9\u0ab0\u0aa3")) {
                return new KeywordMatcher.Match("\u0a89\u0aa6\u0abe\u0ab9\u0ab0\u0aa3", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0a89\u0aa6\u0abe\u0ab9\u0ab0\u0aa3\u0acb")) {
                return new KeywordMatcher.Match("\u0a89\u0aa6\u0abe\u0ab9\u0ab0\u0aa3\u0acb", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("\u0a86\u0aaa\u0ac7\u0ab2 \u0a9b\u0ac7 ")) {
                return new KeywordMatcher.StepMatch("\u0a86\u0aaa\u0ac7\u0ab2 \u0a9b\u0ac7 ", 8, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u0a95\u0acd\u0aaf\u0abe\u0ab0\u0ac7 ")) {
                return new KeywordMatcher.StepMatch("\u0a95\u0acd\u0aaf\u0abe\u0ab0\u0ac7 ", 7, StepKeywordType.ACTION);
            }
            if (line.startsWith("\u0a85\u0aa8\u0ac7 ")) {
                return new KeywordMatcher.StepMatch("\u0a85\u0aa8\u0ac7 ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u0aaa\u0a9b\u0ac0 ")) {
                return new KeywordMatcher.StepMatch("\u0aaa\u0a9b\u0ac0 ", 4, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("\u0aaa\u0aa3 ")) {
                return new KeywordMatcher.StepMatch("\u0aaa\u0aa3 ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class Gl
    implements KeywordMatcher {
        private Gl() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Caracter\u00edstica")) {
                return new KeywordMatcher.Match("Caracter\u00edstica", 15);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Contexto")) {
                return new KeywordMatcher.Match("Contexto", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Esbozo do escenario")) {
                return new KeywordMatcher.Match("Esbozo do escenario", 20);
            }
            if (line.startsWithTitleKeyword("Escenario")) {
                return new KeywordMatcher.Match("Escenario", 10);
            }
            if (line.startsWithTitleKeyword("Exemplo")) {
                return new KeywordMatcher.Match("Exemplo", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Exemplos")) {
                return new KeywordMatcher.Match("Exemplos", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Dadas ")) {
                return new KeywordMatcher.StepMatch("Dadas ", 6, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Dados ")) {
                return new KeywordMatcher.StepMatch("Dados ", 6, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Cando ")) {
                return new KeywordMatcher.StepMatch("Cando ", 6, StepKeywordType.ACTION);
            }
            if (line.startsWith("Ent\u00f3n ")) {
                return new KeywordMatcher.StepMatch("Ent\u00f3n ", 6, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Mais ")) {
                return new KeywordMatcher.StepMatch("Mais ", 5, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Dada ")) {
                return new KeywordMatcher.StepMatch("Dada ", 5, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Dado ")) {
                return new KeywordMatcher.StepMatch("Dado ", 5, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Logo ")) {
                return new KeywordMatcher.StepMatch("Logo ", 5, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Pero ")) {
                return new KeywordMatcher.StepMatch("Pero ", 5, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            if (line.startsWith("E ")) {
                return new KeywordMatcher.StepMatch("E ", 2, StepKeywordType.CONJUNCTION);
            }
            return null;
        }
    }

    private static final class He
    implements KeywordMatcher {
        private He() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u05ea\u05db\u05d5\u05e0\u05d4")) {
                return new KeywordMatcher.Match("\u05ea\u05db\u05d5\u05e0\u05d4", 6);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u05e8\u05e7\u05e2")) {
                return new KeywordMatcher.Match("\u05e8\u05e7\u05e2", 4);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u05db\u05dc\u05dc")) {
                return new KeywordMatcher.Match("\u05db\u05dc\u05dc", 4);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u05ea\u05d1\u05e0\u05d9\u05ea \u05ea\u05e8\u05d7\u05d9\u05e9")) {
                return new KeywordMatcher.Match("\u05ea\u05d1\u05e0\u05d9\u05ea \u05ea\u05e8\u05d7\u05d9\u05e9", 12);
            }
            if (line.startsWithTitleKeyword("\u05d3\u05d5\u05d2\u05de\u05d0")) {
                return new KeywordMatcher.Match("\u05d3\u05d5\u05d2\u05de\u05d0", 6);
            }
            if (line.startsWithTitleKeyword("\u05ea\u05e8\u05d7\u05d9\u05e9")) {
                return new KeywordMatcher.Match("\u05ea\u05e8\u05d7\u05d9\u05e9", 6);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u05d3\u05d5\u05d2\u05de\u05d0\u05d5\u05ea")) {
                return new KeywordMatcher.Match("\u05d3\u05d5\u05d2\u05de\u05d0\u05d5\u05ea", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("\u05d1\u05d4\u05d9\u05e0\u05ea\u05df ")) {
                return new KeywordMatcher.StepMatch("\u05d1\u05d4\u05d9\u05e0\u05ea\u05df ", 7, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u05db\u05d0\u05e9\u05e8 ")) {
                return new KeywordMatcher.StepMatch("\u05db\u05d0\u05e9\u05e8 ", 5, StepKeywordType.ACTION);
            }
            if (line.startsWith("\u05d0\u05d6\u05d9 ")) {
                return new KeywordMatcher.StepMatch("\u05d0\u05d6\u05d9 ", 4, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("\u05d5\u05d2\u05dd ")) {
                return new KeywordMatcher.StepMatch("\u05d5\u05d2\u05dd ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u05d0\u05d1\u05dc ")) {
                return new KeywordMatcher.StepMatch("\u05d0\u05d1\u05dc ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u05d0\u05d6 ")) {
                return new KeywordMatcher.StepMatch("\u05d0\u05d6 ", 3, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class Hi
    implements KeywordMatcher {
        private Hi() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0930\u0942\u092a \u0932\u0947\u0916")) {
                return new KeywordMatcher.Match("\u0930\u0942\u092a \u0932\u0947\u0916", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u092a\u0943\u0937\u094d\u0920\u092d\u0942\u092e\u093f")) {
                return new KeywordMatcher.Match("\u092a\u0943\u0937\u094d\u0920\u092d\u0942\u092e\u093f", 10);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0928\u093f\u092f\u092e")) {
                return new KeywordMatcher.Match("\u0928\u093f\u092f\u092e", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u092a\u0930\u093f\u0926\u0943\u0936\u094d\u092f \u0930\u0942\u092a\u0930\u0947\u0916\u093e")) {
                return new KeywordMatcher.Match("\u092a\u0930\u093f\u0926\u0943\u0936\u094d\u092f \u0930\u0942\u092a\u0930\u0947\u0916\u093e", 17);
            }
            if (line.startsWithTitleKeyword("\u092a\u0930\u093f\u0926\u0943\u0936\u094d\u092f")) {
                return new KeywordMatcher.Match("\u092a\u0930\u093f\u0926\u0943\u0936\u094d\u092f", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0909\u0926\u093e\u0939\u0930\u0923")) {
                return new KeywordMatcher.Match("\u0909\u0926\u093e\u0939\u0930\u0923", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("\u0915\u093f\u0928\u094d\u0924\u0941 ")) {
                return new KeywordMatcher.StepMatch("\u0915\u093f\u0928\u094d\u0924\u0941 ", 7, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u092a\u0930\u0928\u094d\u0924\u0941 ")) {
                return new KeywordMatcher.StepMatch("\u092a\u0930\u0928\u094d\u0924\u0941 ", 7, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u091a\u0942\u0902\u0915\u093f ")) {
                return new KeywordMatcher.StepMatch("\u091a\u0942\u0902\u0915\u093f ", 6, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u092f\u0926\u093f ")) {
                return new KeywordMatcher.StepMatch("\u092f\u0926\u093f ", 4, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u0924\u0925\u093e ")) {
                return new KeywordMatcher.StepMatch("\u0924\u0925\u093e ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u0924\u0926\u093e ")) {
                return new KeywordMatcher.StepMatch("\u0924\u0926\u093e ", 4, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("\u0915\u0926\u093e ")) {
                return new KeywordMatcher.StepMatch("\u0915\u0926\u093e ", 4, StepKeywordType.ACTION);
            }
            if (line.startsWith("\u0905\u0917\u0930 ")) {
                return new KeywordMatcher.StepMatch("\u0905\u0917\u0930 ", 4, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u0914\u0930 ")) {
                return new KeywordMatcher.StepMatch("\u0914\u0930 ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u091c\u092c ")) {
                return new KeywordMatcher.StepMatch("\u091c\u092c ", 3, StepKeywordType.ACTION);
            }
            if (line.startsWith("\u092a\u0930 ")) {
                return new KeywordMatcher.StepMatch("\u092a\u0930 ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u0924\u092c ")) {
                return new KeywordMatcher.StepMatch("\u0924\u092c ", 3, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class Hr
    implements KeywordMatcher {
        private Hr() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Mogucnost")) {
                return new KeywordMatcher.Match("Mogucnost", 10);
            }
            if (line.startsWithTitleKeyword("Mogu\u0107nost")) {
                return new KeywordMatcher.Match("Mogu\u0107nost", 10);
            }
            if (line.startsWithTitleKeyword("Osobina")) {
                return new KeywordMatcher.Match("Osobina", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Pozadina")) {
                return new KeywordMatcher.Match("Pozadina", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Scenarij")) {
                return new KeywordMatcher.Match("Scenarij", 9);
            }
            if (line.startsWithTitleKeyword("Primjer")) {
                return new KeywordMatcher.Match("Primjer", 8);
            }
            if (line.startsWithTitleKeyword("Koncept")) {
                return new KeywordMatcher.Match("Koncept", 8);
            }
            if (line.startsWithTitleKeyword("Skica")) {
                return new KeywordMatcher.Match("Skica", 6);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Scenariji")) {
                return new KeywordMatcher.Match("Scenariji", 10);
            }
            if (line.startsWithTitleKeyword("Primjeri")) {
                return new KeywordMatcher.Match("Primjeri", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Ukoliko ")) {
                return new KeywordMatcher.StepMatch("Ukoliko ", 8, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Zadani ")) {
                return new KeywordMatcher.StepMatch("Zadani ", 7, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Zadano ")) {
                return new KeywordMatcher.StepMatch("Zadano ", 7, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Zadan ")) {
                return new KeywordMatcher.StepMatch("Zadan ", 6, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Kada ")) {
                return new KeywordMatcher.StepMatch("Kada ", 5, StepKeywordType.ACTION);
            }
            if (line.startsWith("Onda ")) {
                return new KeywordMatcher.StepMatch("Onda ", 5, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Kad ")) {
                return new KeywordMatcher.StepMatch("Kad ", 4, StepKeywordType.ACTION);
            }
            if (line.startsWith("Ali ")) {
                return new KeywordMatcher.StepMatch("Ali ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            if (line.startsWith("I ")) {
                return new KeywordMatcher.StepMatch("I ", 2, StepKeywordType.CONJUNCTION);
            }
            return null;
        }
    }

    private static final class Ht
    implements KeywordMatcher {
        private Ht() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Karakteristik")) {
                return new KeywordMatcher.Match("Karakteristik", 14);
            }
            if (line.startsWithTitleKeyword("Fonksyonalite")) {
                return new KeywordMatcher.Match("Fonksyonalite", 14);
            }
            if (line.startsWithTitleKeyword("Mak")) {
                return new KeywordMatcher.Match("Mak", 4);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Kont\u00e8ks")) {
                return new KeywordMatcher.Match("Kont\u00e8ks", 8);
            }
            if (line.startsWithTitleKeyword("Istorik")) {
                return new KeywordMatcher.Match("Istorik", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Senaryo Deskripsyon")) {
                return new KeywordMatcher.Match("Senaryo Deskripsyon", 20);
            }
            if (line.startsWithTitleKeyword("Senaryo deskripsyon")) {
                return new KeywordMatcher.Match("Senaryo deskripsyon", 20);
            }
            if (line.startsWithTitleKeyword("Dyagram Senaryo")) {
                return new KeywordMatcher.Match("Dyagram Senaryo", 16);
            }
            if (line.startsWithTitleKeyword("Dyagram senaryo")) {
                return new KeywordMatcher.Match("Dyagram senaryo", 16);
            }
            if (line.startsWithTitleKeyword("Plan senaryo")) {
                return new KeywordMatcher.Match("Plan senaryo", 13);
            }
            if (line.startsWithTitleKeyword("Plan Senaryo")) {
                return new KeywordMatcher.Match("Plan Senaryo", 13);
            }
            if (line.startsWithTitleKeyword("Senaryo")) {
                return new KeywordMatcher.Match("Senaryo", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Egzanp")) {
                return new KeywordMatcher.Match("Egzanp", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Sipoze Ke ")) {
                return new KeywordMatcher.StepMatch("Sipoze Ke ", 10, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Sipoze ke ")) {
                return new KeywordMatcher.StepMatch("Sipoze ke ", 10, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Le sa a ")) {
                return new KeywordMatcher.StepMatch("Le sa a ", 8, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("L\u00e8 sa a ")) {
                return new KeywordMatcher.StepMatch("L\u00e8 sa a ", 8, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Sipoze ")) {
                return new KeywordMatcher.StepMatch("Sipoze ", 7, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Epi ")) {
                return new KeywordMatcher.StepMatch("Epi ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Men ")) {
                return new KeywordMatcher.StepMatch("Men ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("L\u00e8 ")) {
                return new KeywordMatcher.StepMatch("L\u00e8 ", 3, StepKeywordType.ACTION);
            }
            if (line.startsWith("Le ")) {
                return new KeywordMatcher.StepMatch("Le ", 3, StepKeywordType.ACTION);
            }
            if (line.startsWith("Ak ")) {
                return new KeywordMatcher.StepMatch("Ak ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            if (line.startsWith("E ")) {
                return new KeywordMatcher.StepMatch("E ", 2, StepKeywordType.CONJUNCTION);
            }
            return null;
        }
    }

    private static final class Hu
    implements KeywordMatcher {
        private Hu() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Jellemz\u0151")) {
                return new KeywordMatcher.Match("Jellemz\u0151", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("H\u00e1tt\u00e9r")) {
                return new KeywordMatcher.Match("H\u00e1tt\u00e9r", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Szab\u00e1ly")) {
                return new KeywordMatcher.Match("Szab\u00e1ly", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Forgat\u00f3k\u00f6nyv v\u00e1zlat")) {
                return new KeywordMatcher.Match("Forgat\u00f3k\u00f6nyv v\u00e1zlat", 20);
            }
            if (line.startsWithTitleKeyword("Forgat\u00f3k\u00f6nyv")) {
                return new KeywordMatcher.Match("Forgat\u00f3k\u00f6nyv", 13);
            }
            if (line.startsWithTitleKeyword("P\u00e9lda")) {
                return new KeywordMatcher.Match("P\u00e9lda", 6);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("P\u00e9ld\u00e1k")) {
                return new KeywordMatcher.Match("P\u00e9ld\u00e1k", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Amennyiben ")) {
                return new KeywordMatcher.StepMatch("Amennyiben ", 11, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Amikor ")) {
                return new KeywordMatcher.StepMatch("Amikor ", 7, StepKeywordType.ACTION);
            }
            if (line.startsWith("Adott ")) {
                return new KeywordMatcher.StepMatch("Adott ", 6, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Akkor ")) {
                return new KeywordMatcher.StepMatch("Akkor ", 6, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Majd ")) {
                return new KeywordMatcher.StepMatch("Majd ", 5, StepKeywordType.ACTION);
            }
            if (line.startsWith("Ha ")) {
                return new KeywordMatcher.StepMatch("Ha ", 3, StepKeywordType.ACTION);
            }
            if (line.startsWith("\u00c9s ")) {
                return new KeywordMatcher.StepMatch("\u00c9s ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("De ")) {
                return new KeywordMatcher.StepMatch("De ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class Id
    implements KeywordMatcher {
        private Id() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Fitur")) {
                return new KeywordMatcher.Match("Fitur", 6);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Latar Belakang")) {
                return new KeywordMatcher.Match("Latar Belakang", 15);
            }
            if (line.startsWithTitleKeyword("Dasar")) {
                return new KeywordMatcher.Match("Dasar", 6);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Aturan")) {
                return new KeywordMatcher.Match("Aturan", 7);
            }
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Garis-Besar Skenario")) {
                return new KeywordMatcher.Match("Garis-Besar Skenario", 21);
            }
            if (line.startsWithTitleKeyword("Skenario konsep")) {
                return new KeywordMatcher.Match("Skenario konsep", 16);
            }
            if (line.startsWithTitleKeyword("Skenario")) {
                return new KeywordMatcher.Match("Skenario", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Contoh")) {
                return new KeywordMatcher.Match("Contoh", 7);
            }
            if (line.startsWithTitleKeyword("Misal")) {
                return new KeywordMatcher.Match("Misal", 6);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Diasumsikan ")) {
                return new KeywordMatcher.StepMatch("Diasumsikan ", 12, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Diketahui ")) {
                return new KeywordMatcher.StepMatch("Diketahui ", 10, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Kemudian ")) {
                return new KeywordMatcher.StepMatch("Kemudian ", 9, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Dengan ")) {
                return new KeywordMatcher.StepMatch("Dengan ", 7, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Ketika ")) {
                return new KeywordMatcher.StepMatch("Ketika ", 7, StepKeywordType.ACTION);
            }
            if (line.startsWith("Tetapi ")) {
                return new KeywordMatcher.StepMatch("Tetapi ", 7, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Jika ")) {
                return new KeywordMatcher.StepMatch("Jika ", 5, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Bila ")) {
                return new KeywordMatcher.StepMatch("Bila ", 5, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Tapi ")) {
                return new KeywordMatcher.StepMatch("Tapi ", 5, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Maka ")) {
                return new KeywordMatcher.StepMatch("Maka ", 5, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Dan ")) {
                return new KeywordMatcher.StepMatch("Dan ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class Is
    implements KeywordMatcher {
        private Is() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Eiginleiki")) {
                return new KeywordMatcher.Match("Eiginleiki", 11);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Bakgrunnur")) {
                return new KeywordMatcher.Match("Bakgrunnur", 11);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("L\u00fdsing Atbur\u00f0ar\u00e1sar")) {
                return new KeywordMatcher.Match("L\u00fdsing Atbur\u00f0ar\u00e1sar", 20);
            }
            if (line.startsWithTitleKeyword("L\u00fdsing D\u00e6ma")) {
                return new KeywordMatcher.Match("L\u00fdsing D\u00e6ma", 12);
            }
            if (line.startsWithTitleKeyword("Atbur\u00f0ar\u00e1s")) {
                return new KeywordMatcher.Match("Atbur\u00f0ar\u00e1s", 11);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Atbur\u00f0ar\u00e1sir")) {
                return new KeywordMatcher.Match("Atbur\u00f0ar\u00e1sir", 13);
            }
            if (line.startsWithTitleKeyword("D\u00e6mi")) {
                return new KeywordMatcher.Match("D\u00e6mi", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("\u00deegar ")) {
                return new KeywordMatcher.StepMatch("\u00deegar ", 6, StepKeywordType.ACTION);
            }
            if (line.startsWith("Og ")) {
                return new KeywordMatcher.StepMatch("Og ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("En ")) {
                return new KeywordMatcher.StepMatch("En ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Ef ")) {
                return new KeywordMatcher.StepMatch("Ef ", 3, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u00de\u00e1 ")) {
                return new KeywordMatcher.StepMatch("\u00de\u00e1 ", 3, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class It
    implements KeywordMatcher {
        private It() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Esigenza di Business")) {
                return new KeywordMatcher.Match("Esigenza di Business", 21);
            }
            if (line.startsWithTitleKeyword("Funzionalit\u00e0")) {
                return new KeywordMatcher.Match("Funzionalit\u00e0", 13);
            }
            if (line.startsWithTitleKeyword("Abilit\u00e0")) {
                return new KeywordMatcher.Match("Abilit\u00e0", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Contesto")) {
                return new KeywordMatcher.Match("Contesto", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Regola")) {
                return new KeywordMatcher.Match("Regola", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Schema dello scenario")) {
                return new KeywordMatcher.Match("Schema dello scenario", 22);
            }
            if (line.startsWithTitleKeyword("Scenario")) {
                return new KeywordMatcher.Match("Scenario", 9);
            }
            if (line.startsWithTitleKeyword("Esempio")) {
                return new KeywordMatcher.Match("Esempio", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Esempi")) {
                return new KeywordMatcher.Match("Esempi", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Allora ")) {
                return new KeywordMatcher.StepMatch("Allora ", 7, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Quando ")) {
                return new KeywordMatcher.StepMatch("Quando ", 7, StepKeywordType.ACTION);
            }
            if (line.startsWith("Dati ")) {
                return new KeywordMatcher.StepMatch("Dati ", 5, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Dato ")) {
                return new KeywordMatcher.StepMatch("Dato ", 5, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Data ")) {
                return new KeywordMatcher.StepMatch("Data ", 5, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Date ")) {
                return new KeywordMatcher.StepMatch("Date ", 5, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Ed ")) {
                return new KeywordMatcher.StepMatch("Ed ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Ma ")) {
                return new KeywordMatcher.StepMatch("Ma ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            if (line.startsWith("E ")) {
                return new KeywordMatcher.StepMatch("E ", 2, StepKeywordType.CONJUNCTION);
            }
            return null;
        }
    }

    private static final class Ja
    implements KeywordMatcher {
        private Ja() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u30d5\u30a3\u30fc\u30c1\u30e3")) {
                return new KeywordMatcher.Match("\u30d5\u30a3\u30fc\u30c1\u30e3", 6);
            }
            if (line.startsWithTitleKeyword("\u6a5f\u80fd")) {
                return new KeywordMatcher.Match("\u6a5f\u80fd", 3);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u80cc\u666f")) {
                return new KeywordMatcher.Match("\u80cc\u666f", 3);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u30eb\u30fc\u30eb")) {
                return new KeywordMatcher.Match("\u30eb\u30fc\u30eb", 4);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u30b7\u30ca\u30ea\u30aa\u30a2\u30a6\u30c8\u30e9\u30a4\u30f3")) {
                return new KeywordMatcher.Match("\u30b7\u30ca\u30ea\u30aa\u30a2\u30a6\u30c8\u30e9\u30a4\u30f3", 11);
            }
            if (line.startsWithTitleKeyword("\u30b7\u30ca\u30ea\u30aa\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8")) {
                return new KeywordMatcher.Match("\u30b7\u30ca\u30ea\u30aa\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8", 11);
            }
            if (line.startsWithTitleKeyword("\u30b7\u30ca\u30ea\u30aa\u30c6\u30f3\u30d7\u30ec")) {
                return new KeywordMatcher.Match("\u30b7\u30ca\u30ea\u30aa\u30c6\u30f3\u30d7\u30ec", 9);
            }
            if (line.startsWithTitleKeyword("\u30c6\u30f3\u30d7\u30ec")) {
                return new KeywordMatcher.Match("\u30c6\u30f3\u30d7\u30ec", 5);
            }
            if (line.startsWithTitleKeyword("\u30b7\u30ca\u30ea\u30aa")) {
                return new KeywordMatcher.Match("\u30b7\u30ca\u30ea\u30aa", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u30b5\u30f3\u30d7\u30eb")) {
                return new KeywordMatcher.Match("\u30b5\u30f3\u30d7\u30eb", 5);
            }
            if (line.startsWithTitleKeyword("\u4f8b")) {
                return new KeywordMatcher.Match("\u4f8b", 2);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("\u306a\u3089\u3070")) {
                return new KeywordMatcher.StepMatch("\u306a\u3089\u3070", 3, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("\u305f\u3060\u3057")) {
                return new KeywordMatcher.StepMatch("\u305f\u3060\u3057", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u3057\u304b\u3057")) {
                return new KeywordMatcher.StepMatch("\u3057\u304b\u3057", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u524d\u63d0")) {
                return new KeywordMatcher.StepMatch("\u524d\u63d0", 2, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u7136\u3057")) {
                return new KeywordMatcher.StepMatch("\u7136\u3057", 2, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u3082\u3057")) {
                return new KeywordMatcher.StepMatch("\u3082\u3057", 2, StepKeywordType.ACTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            if (line.startsWith("\u4f46\u3057")) {
                return new KeywordMatcher.StepMatch("\u4f46\u3057", 2, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u4e14\u3064")) {
                return new KeywordMatcher.StepMatch("\u4e14\u3064", 2, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u304b\u3064")) {
                return new KeywordMatcher.StepMatch("\u304b\u3064", 2, StepKeywordType.CONJUNCTION);
            }
            return null;
        }
    }

    private static final class Jv
    implements KeywordMatcher {
        private Jv() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Fitur")) {
                return new KeywordMatcher.Match("Fitur", 6);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Dasar")) {
                return new KeywordMatcher.Match("Dasar", 6);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Konsep skenario")) {
                return new KeywordMatcher.Match("Konsep skenario", 16);
            }
            if (line.startsWithTitleKeyword("Skenario")) {
                return new KeywordMatcher.Match("Skenario", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Contone")) {
                return new KeywordMatcher.Match("Contone", 8);
            }
            if (line.startsWithTitleKeyword("Conto")) {
                return new KeywordMatcher.Match("Conto", 6);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Nalikaning ")) {
                return new KeywordMatcher.StepMatch("Nalikaning ", 11, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Ananging ")) {
                return new KeywordMatcher.StepMatch("Ananging ", 9, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Nanging ")) {
                return new KeywordMatcher.StepMatch("Nanging ", 8, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Banjur ")) {
                return new KeywordMatcher.StepMatch("Banjur ", 7, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Manawa ")) {
                return new KeywordMatcher.StepMatch("Manawa ", 7, StepKeywordType.ACTION);
            }
            if (line.startsWith("Nalika ")) {
                return new KeywordMatcher.StepMatch("Nalika ", 7, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Menawa ")) {
                return new KeywordMatcher.StepMatch("Menawa ", 7, StepKeywordType.ACTION);
            }
            if (line.startsWith("Njuk ")) {
                return new KeywordMatcher.StepMatch("Njuk ", 5, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Tapi ")) {
                return new KeywordMatcher.StepMatch("Tapi ", 5, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Lan ")) {
                return new KeywordMatcher.StepMatch("Lan ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class Ka
    implements KeywordMatcher {
        private Ka() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u10db\u10dd\u10d7\u10ee\u10dd\u10d5\u10dc\u10d0")) {
                return new KeywordMatcher.Match("\u10db\u10dd\u10d7\u10ee\u10dd\u10d5\u10dc\u10d0", 9);
            }
            if (line.startsWithTitleKeyword("\u10d7\u10d5\u10d8\u10e1\u10d4\u10d1\u10d0")) {
                return new KeywordMatcher.Match("\u10d7\u10d5\u10d8\u10e1\u10d4\u10d1\u10d0", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u10d9\u10dd\u10dc\u10e2\u10d4\u10e5\u10e1\u10e2\u10d8")) {
                return new KeywordMatcher.Match("\u10d9\u10dd\u10dc\u10e2\u10d4\u10e5\u10e1\u10e2\u10d8", 10);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u10ec\u10d4\u10e1\u10d8")) {
                return new KeywordMatcher.Match("\u10ec\u10d4\u10e1\u10d8", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u10e1\u10ea\u10d4\u10dc\u10d0\u10e0\u10d8\u10e1 \u10e8\u10d0\u10d1\u10da\u10dd\u10dc\u10d8")) {
                return new KeywordMatcher.Match("\u10e1\u10ea\u10d4\u10dc\u10d0\u10e0\u10d8\u10e1 \u10e8\u10d0\u10d1\u10da\u10dd\u10dc\u10d8", 17);
            }
            if (line.startsWithTitleKeyword("\u10e1\u10ea\u10d4\u10dc\u10d0\u10e0\u10d8\u10e1 \u10dc\u10d8\u10db\u10e3\u10e8\u10d8")) {
                return new KeywordMatcher.Match("\u10e1\u10ea\u10d4\u10dc\u10d0\u10e0\u10d8\u10e1 \u10dc\u10d8\u10db\u10e3\u10e8\u10d8", 16);
            }
            if (line.startsWithTitleKeyword("\u10db\u10d0\u10d2\u10d0\u10da\u10d8\u10d7\u10d0\u10d3")) {
                return new KeywordMatcher.Match("\u10db\u10d0\u10d2\u10d0\u10da\u10d8\u10d7\u10d0\u10d3", 10);
            }
            if (line.startsWithTitleKeyword("\u10db\u10d0\u10d2\u10d0\u10da\u10d8\u10d7\u10d8")) {
                return new KeywordMatcher.Match("\u10db\u10d0\u10d2\u10d0\u10da\u10d8\u10d7\u10d8", 9);
            }
            if (line.startsWithTitleKeyword("\u10e1\u10ea\u10d4\u10dc\u10d0\u10e0\u10d8")) {
                return new KeywordMatcher.Match("\u10e1\u10ea\u10d4\u10dc\u10d0\u10e0\u10d8", 8);
            }
            if (line.startsWithTitleKeyword("\u10e8\u10d0\u10d1\u10da\u10dd\u10dc\u10d8")) {
                return new KeywordMatcher.Match("\u10e8\u10d0\u10d1\u10da\u10dd\u10dc\u10d8", 8);
            }
            if (line.startsWithTitleKeyword("\u10dc\u10d8\u10db\u10e3\u10e8\u10d8")) {
                return new KeywordMatcher.Match("\u10dc\u10d8\u10db\u10e3\u10e8\u10d8", 7);
            }
            if (line.startsWithTitleKeyword("\u10db\u10d0\u10d2")) {
                return new KeywordMatcher.Match("\u10db\u10d0\u10d2", 4);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u10db\u10d0\u10d2\u10d0\u10da\u10d8\u10d7\u10d4\u10d1\u10d8")) {
                return new KeywordMatcher.Match("\u10db\u10d0\u10d2\u10d0\u10da\u10d8\u10d7\u10d4\u10d1\u10d8", 11);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("\u10db\u10dd\u10ea\u10d4\u10db\u10e3\u10da\u10d8\u10d0 ")) {
                return new KeywordMatcher.StepMatch("\u10db\u10dd\u10ea\u10d4\u10db\u10e3\u10da\u10d8\u10d0 ", 10, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u10e0\u10dd\u10d2\u10dd\u10e0\u10ea \u10d9\u10d8 ")) {
                return new KeywordMatcher.StepMatch("\u10e0\u10dd\u10d2\u10dd\u10e0\u10ea \u10d9\u10d8 ", 10, StepKeywordType.ACTION);
            }
            if (line.startsWith("\u10db\u10dd\u10ea\u10d4\u10db\u10e3\u10da\u10d8 ")) {
                return new KeywordMatcher.StepMatch("\u10db\u10dd\u10ea\u10d4\u10db\u10e3\u10da\u10d8 ", 9, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u10e0\u10dd\u10d3\u10d4\u10e1\u10d0\u10ea ")) {
                return new KeywordMatcher.StepMatch("\u10e0\u10dd\u10d3\u10d4\u10e1\u10d0\u10ea ", 8, StepKeywordType.ACTION);
            }
            if (line.startsWith("\u10db\u10d0\u10d2\u10e0\u10d0\u10db ")) {
                return new KeywordMatcher.StepMatch("\u10db\u10d0\u10d2\u10e0\u10d0\u10db ", 7, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u10d5\u10d7\u10e5\u10d5\u10d0\u10d7 ")) {
                return new KeywordMatcher.StepMatch("\u10d5\u10d7\u10e5\u10d5\u10d0\u10d7 ", 7, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u10d0\u10e1\u10d4\u10d5\u10d4 ")) {
                return new KeywordMatcher.StepMatch("\u10d0\u10e1\u10d4\u10d5\u10d4 ", 6, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u10d7\u10e3\u10db\u10ea\u10d0 ")) {
                return new KeywordMatcher.StepMatch("\u10d7\u10e3\u10db\u10ea\u10d0 ", 6, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u10db\u10d0\u10e8\u10d8\u10dc ")) {
                return new KeywordMatcher.StepMatch("\u10db\u10d0\u10e8\u10d8\u10dc ", 6, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("\u10e0\u10dd\u10ea\u10d0 ")) {
                return new KeywordMatcher.StepMatch("\u10e0\u10dd\u10ea\u10d0 ", 5, StepKeywordType.ACTION);
            }
            if (line.startsWith("\u10d3\u10d0 ")) {
                return new KeywordMatcher.StepMatch("\u10d3\u10d0 ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u10d7\u10e3 ")) {
                return new KeywordMatcher.StepMatch("\u10d7\u10e3 ", 3, StepKeywordType.ACTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class Kn
    implements KeywordMatcher {
        private Kn() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0cb9\u0cc6\u0c9a\u0ccd\u0c9a\u0cb3")) {
                return new KeywordMatcher.Match("\u0cb9\u0cc6\u0c9a\u0ccd\u0c9a\u0cb3", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0cb9\u0cbf\u0ca8\u0ccd\u0ca8\u0cc6\u0cb2\u0cc6")) {
                return new KeywordMatcher.Match("\u0cb9\u0cbf\u0ca8\u0ccd\u0ca8\u0cc6\u0cb2\u0cc6", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0c95\u0ca5\u0cbe\u0cb8\u0cbe\u0cb0\u0cbe\u0c82\u0cb6")) {
                return new KeywordMatcher.Match("\u0c95\u0ca5\u0cbe\u0cb8\u0cbe\u0cb0\u0cbe\u0c82\u0cb6", 10);
            }
            if (line.startsWithTitleKeyword("\u0c89\u0ca6\u0cbe\u0cb9\u0cb0\u0ca3\u0cc6")) {
                return new KeywordMatcher.Match("\u0c89\u0ca6\u0cbe\u0cb9\u0cb0\u0ca3\u0cc6", 8);
            }
            if (line.startsWithTitleKeyword("\u0cb5\u0cbf\u0cb5\u0cb0\u0ca3\u0cc6")) {
                return new KeywordMatcher.Match("\u0cb5\u0cbf\u0cb5\u0cb0\u0ca3\u0cc6", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0c89\u0ca6\u0cbe\u0cb9\u0cb0\u0ca3\u0cc6\u0c97\u0cb3\u0cc1")) {
                return new KeywordMatcher.Match("\u0c89\u0ca6\u0cbe\u0cb9\u0cb0\u0ca3\u0cc6\u0c97\u0cb3\u0cc1", 11);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("\u0cb8\u0ccd\u0ca5\u0cbf\u0ca4\u0cbf\u0caf\u0ca8\u0ccd\u0ca8\u0cc1 ")) {
                return new KeywordMatcher.StepMatch("\u0cb8\u0ccd\u0ca5\u0cbf\u0ca4\u0cbf\u0caf\u0ca8\u0ccd\u0ca8\u0cc1 ", 12, StepKeywordType.ACTION);
            }
            if (line.startsWith("\u0ca8\u0cbf\u0cd5\u0ca1\u0cbf\u0ca6 ")) {
                return new KeywordMatcher.StepMatch("\u0ca8\u0cbf\u0cd5\u0ca1\u0cbf\u0ca6 ", 7, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u0cae\u0ca4\u0ccd\u0ca4\u0cc1 ")) {
                return new KeywordMatcher.StepMatch("\u0cae\u0ca4\u0ccd\u0ca4\u0cc1 ", 6, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u0ca8\u0c82\u0ca4\u0cb0 ")) {
                return new KeywordMatcher.StepMatch("\u0ca8\u0c82\u0ca4\u0cb0 ", 5, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("\u0c86\u0ca6\u0cb0\u0cc6 ")) {
                return new KeywordMatcher.StepMatch("\u0c86\u0ca6\u0cb0\u0cc6 ", 5, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class Ko
    implements KeywordMatcher {
        private Ko() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("\uae30\ub2a5")) {
                return new KeywordMatcher.Match("\uae30\ub2a5", 3);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("\ubc30\uacbd")) {
                return new KeywordMatcher.Match("\ubc30\uacbd", 3);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("\uc2dc\ub098\ub9ac\uc624 \uac1c\uc694")) {
                return new KeywordMatcher.Match("\uc2dc\ub098\ub9ac\uc624 \uac1c\uc694", 8);
            }
            if (line.startsWithTitleKeyword("\uc2dc\ub098\ub9ac\uc624")) {
                return new KeywordMatcher.Match("\uc2dc\ub098\ub9ac\uc624", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("\uc608")) {
                return new KeywordMatcher.Match("\uc608", 2);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("\uadf8\ub9ac\uace0 ")) {
                return new KeywordMatcher.StepMatch("\uadf8\ub9ac\uace0 ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\ud558\uc9c0\ub9cc ")) {
                return new KeywordMatcher.StepMatch("\ud558\uc9c0\ub9cc ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\uadf8\ub7ec\uba74 ")) {
                return new KeywordMatcher.StepMatch("\uadf8\ub7ec\uba74 ", 4, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("\ub9cc\uc77c ")) {
                return new KeywordMatcher.StepMatch("\ub9cc\uc77c ", 3, StepKeywordType.ACTION);
            }
            if (line.startsWith("\uba3c\uc800 ")) {
                return new KeywordMatcher.StepMatch("\uba3c\uc800 ", 3, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\uc870\uac74 ")) {
                return new KeywordMatcher.StepMatch("\uc870\uac74 ", 3, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\ub9cc\uc57d ")) {
                return new KeywordMatcher.StepMatch("\ub9cc\uc57d ", 3, StepKeywordType.ACTION);
            }
            if (line.startsWith("\ub2e8 ")) {
                return new KeywordMatcher.StepMatch("\ub2e8 ", 2, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class Lt
    implements KeywordMatcher {
        private Lt() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Savyb\u0117")) {
                return new KeywordMatcher.Match("Savyb\u0117", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Kontekstas")) {
                return new KeywordMatcher.Match("Kontekstas", 11);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Scenarijaus \u0161ablonas")) {
                return new KeywordMatcher.Match("Scenarijaus \u0161ablonas", 21);
            }
            if (line.startsWithTitleKeyword("Scenarijus")) {
                return new KeywordMatcher.Match("Scenarijus", 11);
            }
            if (line.startsWithTitleKeyword("Pavyzdys")) {
                return new KeywordMatcher.Match("Pavyzdys", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Pavyzd\u017eiai")) {
                return new KeywordMatcher.Match("Pavyzd\u017eiai", 11);
            }
            if (line.startsWithTitleKeyword("Scenarijai")) {
                return new KeywordMatcher.Match("Scenarijai", 11);
            }
            if (line.startsWithTitleKeyword("Variantai")) {
                return new KeywordMatcher.Match("Variantai", 10);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Duota ")) {
                return new KeywordMatcher.StepMatch("Duota ", 6, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Tada ")) {
                return new KeywordMatcher.StepMatch("Tada ", 5, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Kai ")) {
                return new KeywordMatcher.StepMatch("Kai ", 4, StepKeywordType.ACTION);
            }
            if (line.startsWith("Bet ")) {
                return new KeywordMatcher.StepMatch("Bet ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Ir ")) {
                return new KeywordMatcher.StepMatch("Ir ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class Lu
    implements KeywordMatcher {
        private Lu() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Funktionalit\u00e9it")) {
                return new KeywordMatcher.Match("Funktionalit\u00e9it", 16);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Hannergrond")) {
                return new KeywordMatcher.Match("Hannergrond", 12);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Plang vum Szenario")) {
                return new KeywordMatcher.Match("Plang vum Szenario", 19);
            }
            if (line.startsWithTitleKeyword("Szenario")) {
                return new KeywordMatcher.Match("Szenario", 9);
            }
            if (line.startsWithTitleKeyword("Beispill")) {
                return new KeywordMatcher.Match("Beispill", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Beispiller")) {
                return new KeywordMatcher.Match("Beispiller", 11);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("ugeholl ")) {
                return new KeywordMatcher.StepMatch("ugeholl ", 8, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("wann ")) {
                return new KeywordMatcher.StepMatch("wann ", 5, StepKeywordType.ACTION);
            }
            if (line.startsWith("dann ")) {
                return new KeywordMatcher.StepMatch("dann ", 5, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("awer ")) {
                return new KeywordMatcher.StepMatch("awer ", 5, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("m\u00e4 ")) {
                return new KeywordMatcher.StepMatch("m\u00e4 ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("an ")) {
                return new KeywordMatcher.StepMatch("an ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            if (line.startsWith("a ")) {
                return new KeywordMatcher.StepMatch("a ", 2, StepKeywordType.CONJUNCTION);
            }
            return null;
        }
    }

    private static final class Lv
    implements KeywordMatcher {
        private Lv() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Funkcionalit\u0101te")) {
                return new KeywordMatcher.Match("Funkcionalit\u0101te", 16);
            }
            if (line.startsWithTitleKeyword("F\u012b\u010da")) {
                return new KeywordMatcher.Match("F\u012b\u010da", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Konteksts")) {
                return new KeywordMatcher.Match("Konteksts", 10);
            }
            if (line.startsWithTitleKeyword("Situ\u0101cija")) {
                return new KeywordMatcher.Match("Situ\u0101cija", 10);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Scen\u0101rijs p\u0113c parauga")) {
                return new KeywordMatcher.Match("Scen\u0101rijs p\u0113c parauga", 22);
            }
            if (line.startsWithTitleKeyword("Scen\u0101rijs")) {
                return new KeywordMatcher.Match("Scen\u0101rijs", 10);
            }
            if (line.startsWithTitleKeyword("Piem\u0113rs")) {
                return new KeywordMatcher.Match("Piem\u0113rs", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Piem\u0113ri")) {
                return new KeywordMatcher.Match("Piem\u0113ri", 8);
            }
            if (line.startsWithTitleKeyword("Paraugs")) {
                return new KeywordMatcher.Match("Paraugs", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Tad ")) {
                return new KeywordMatcher.StepMatch("Tad ", 4, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Bet ")) {
                return new KeywordMatcher.StepMatch("Bet ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Kad ")) {
                return new KeywordMatcher.StepMatch("Kad ", 4, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Un ")) {
                return new KeywordMatcher.StepMatch("Un ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Ja ")) {
                return new KeywordMatcher.StepMatch("Ja ", 3, StepKeywordType.ACTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class Mk_cyrl
    implements KeywordMatcher {
        private Mk_cyrl() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0424\u0443\u043d\u043a\u0446\u0438\u043e\u043d\u0430\u043b\u043d\u043e\u0441\u0442")) {
                return new KeywordMatcher.Match("\u0424\u0443\u043d\u043a\u0446\u0438\u043e\u043d\u0430\u043b\u043d\u043e\u0441\u0442", 15);
            }
            if (line.startsWithTitleKeyword("\u0411\u0438\u0437\u043d\u0438\u0441 \u043f\u043e\u0442\u0440\u0435\u0431\u0430")) {
                return new KeywordMatcher.Match("\u0411\u0438\u0437\u043d\u0438\u0441 \u043f\u043e\u0442\u0440\u0435\u0431\u0430", 15);
            }
            if (line.startsWithTitleKeyword("\u041c\u043e\u0436\u043d\u043e\u0441\u0442")) {
                return new KeywordMatcher.Match("\u041c\u043e\u0436\u043d\u043e\u0441\u0442", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0421\u043e\u0434\u0440\u0436\u0438\u043d\u0430")) {
                return new KeywordMatcher.Match("\u0421\u043e\u0434\u0440\u0436\u0438\u043d\u0430", 9);
            }
            if (line.startsWithTitleKeyword("\u041a\u043e\u043d\u0442\u0435\u043a\u0441\u0442")) {
                return new KeywordMatcher.Match("\u041a\u043e\u043d\u0442\u0435\u043a\u0441\u0442", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u041f\u0440\u0435\u0433\u043b\u0435\u0434 \u043d\u0430 \u0441\u0446\u0435\u043d\u0430\u0440\u0438\u0458\u0430")) {
                return new KeywordMatcher.Match("\u041f\u0440\u0435\u0433\u043b\u0435\u0434 \u043d\u0430 \u0441\u0446\u0435\u043d\u0430\u0440\u0438\u0458\u0430", 21);
            }
            if (line.startsWithTitleKeyword("\u041d\u0430 \u043f\u0440\u0438\u043c\u0435\u0440")) {
                return new KeywordMatcher.Match("\u041d\u0430 \u043f\u0440\u0438\u043c\u0435\u0440", 10);
            }
            if (line.startsWithTitleKeyword("\u0421\u0446\u0435\u043d\u0430\u0440\u0438\u043e")) {
                return new KeywordMatcher.Match("\u0421\u0446\u0435\u043d\u0430\u0440\u0438\u043e", 9);
            }
            if (line.startsWithTitleKeyword("\u041a\u043e\u043d\u0446\u0435\u043f\u0442")) {
                return new KeywordMatcher.Match("\u041a\u043e\u043d\u0446\u0435\u043f\u0442", 8);
            }
            if (line.startsWithTitleKeyword("\u041f\u0440\u0438\u043c\u0435\u0440")) {
                return new KeywordMatcher.Match("\u041f\u0440\u0438\u043c\u0435\u0440", 7);
            }
            if (line.startsWithTitleKeyword("\u0421\u043a\u0438\u0446\u0430")) {
                return new KeywordMatcher.Match("\u0421\u043a\u0438\u0446\u0430", 6);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0421\u0446\u0435\u043d\u0430\u0440\u0438\u0458\u0430")) {
                return new KeywordMatcher.Match("\u0421\u0446\u0435\u043d\u0430\u0440\u0438\u0458\u0430", 10);
            }
            if (line.startsWithTitleKeyword("\u041f\u0440\u0438\u043c\u0435\u0440\u0438")) {
                return new KeywordMatcher.Match("\u041f\u0440\u0438\u043c\u0435\u0440\u0438", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("\u0414\u0430\u0434\u0435\u043d\u043e ")) {
                return new KeywordMatcher.StepMatch("\u0414\u0430\u0434\u0435\u043d\u043e ", 7, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u0414\u0430\u0434\u0435\u043d\u0430 ")) {
                return new KeywordMatcher.StepMatch("\u0414\u0430\u0434\u0435\u043d\u0430 ", 7, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u0422\u043e\u0433\u0430\u0448 ")) {
                return new KeywordMatcher.StepMatch("\u0422\u043e\u0433\u0430\u0448 ", 6, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("\u041a\u043e\u0433\u0430 ")) {
                return new KeywordMatcher.StepMatch("\u041a\u043e\u0433\u0430 ", 5, StepKeywordType.ACTION);
            }
            if (line.startsWith("\u041d\u043e ")) {
                return new KeywordMatcher.StepMatch("\u041d\u043e ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u0418 ")) {
                return new KeywordMatcher.StepMatch("\u0418 ", 2, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class Mk_latn
    implements KeywordMatcher {
        private Mk_latn() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Funkcionalnost")) {
                return new KeywordMatcher.Match("Funkcionalnost", 15);
            }
            if (line.startsWithTitleKeyword("Biznis potreba")) {
                return new KeywordMatcher.Match("Biznis potreba", 15);
            }
            if (line.startsWithTitleKeyword("Mozhnost")) {
                return new KeywordMatcher.Match("Mozhnost", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Sodrzhina")) {
                return new KeywordMatcher.Match("Sodrzhina", 10);
            }
            if (line.startsWithTitleKeyword("Kontekst")) {
                return new KeywordMatcher.Match("Kontekst", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Pregled na scenarija")) {
                return new KeywordMatcher.Match("Pregled na scenarija", 21);
            }
            if (line.startsWithTitleKeyword("Na primer")) {
                return new KeywordMatcher.Match("Na primer", 10);
            }
            if (line.startsWithTitleKeyword("Scenario")) {
                return new KeywordMatcher.Match("Scenario", 9);
            }
            if (line.startsWithTitleKeyword("Koncept")) {
                return new KeywordMatcher.Match("Koncept", 8);
            }
            if (line.startsWithTitleKeyword("Skica")) {
                return new KeywordMatcher.Match("Skica", 6);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Scenaria")) {
                return new KeywordMatcher.Match("Scenaria", 9);
            }
            if (line.startsWithTitleKeyword("Primeri")) {
                return new KeywordMatcher.Match("Primeri", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Dadena ")) {
                return new KeywordMatcher.StepMatch("Dadena ", 7, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Togash ")) {
                return new KeywordMatcher.StepMatch("Togash ", 7, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Dadeno ")) {
                return new KeywordMatcher.StepMatch("Dadeno ", 7, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Koga ")) {
                return new KeywordMatcher.StepMatch("Koga ", 5, StepKeywordType.ACTION);
            }
            if (line.startsWith("No ")) {
                return new KeywordMatcher.StepMatch("No ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            if (line.startsWith("I ")) {
                return new KeywordMatcher.StepMatch("I ", 2, StepKeywordType.CONJUNCTION);
            }
            return null;
        }
    }

    private static final class Ml
    implements KeywordMatcher {
        private Ml() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0d38\u0d35\u0d3f\u0d36\u0d47\u0d37\u0d24")) {
                return new KeywordMatcher.Match("\u0d38\u0d35\u0d3f\u0d36\u0d47\u0d37\u0d24", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0d2a\u0d36\u0d4d\u0d1a\u0d3e\u0d24\u0d4d\u0d24\u0d32\u0d02")) {
                return new KeywordMatcher.Match("\u0d2a\u0d36\u0d4d\u0d1a\u0d3e\u0d24\u0d4d\u0d24\u0d32\u0d02", 11);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0d28\u0d3f\u0d2f\u0d2e\u0d02")) {
                return new KeywordMatcher.Match("\u0d28\u0d3f\u0d2f\u0d2e\u0d02", 6);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0d38\u0d3e\u0d39\u0d1a\u0d30\u0d4d\u0d2f\u0d24\u0d4d\u0d24\u0d3f\u0d28\u0d4d\u0d31\u0d46 \u0d30\u0d42\u0d2a\u0d30\u0d47\u0d16")) {
                return new KeywordMatcher.Match("\u0d38\u0d3e\u0d39\u0d1a\u0d30\u0d4d\u0d2f\u0d24\u0d4d\u0d24\u0d3f\u0d28\u0d4d\u0d31\u0d46 \u0d30\u0d42\u0d2a\u0d30\u0d47\u0d16", 23);
            }
            if (line.startsWithTitleKeyword("\u0d30\u0d02\u0d17\u0d02")) {
                return new KeywordMatcher.Match("\u0d30\u0d02\u0d17\u0d02", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0d09\u0d26\u0d3e\u0d39\u0d30\u0d23\u0d19\u0d4d\u0d19\u0d7e")) {
                return new KeywordMatcher.Match("\u0d09\u0d26\u0d3e\u0d39\u0d30\u0d23\u0d19\u0d4d\u0d19\u0d7e", 11);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("\u0d28\u0d7d\u0d15\u0d3f\u0d2f\u0d24\u0d4d")) {
                return new KeywordMatcher.StepMatch("\u0d28\u0d7d\u0d15\u0d3f\u0d2f\u0d24\u0d4d", 7, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u0d0e\u0d2a\u0d4d\u0d2a\u0d47\u0d3e\u0d7e")) {
                return new KeywordMatcher.StepMatch("\u0d0e\u0d2a\u0d4d\u0d2a\u0d47\u0d3e\u0d7e", 7, StepKeywordType.ACTION);
            }
            if (line.startsWith("\u0d2a\u0d3f\u0d28\u0d4d\u0d28\u0d46")) {
                return new KeywordMatcher.StepMatch("\u0d2a\u0d3f\u0d28\u0d4d\u0d28\u0d46", 6, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("\u0d12\u0d2a\u0d4d\u0d2a\u0d02")) {
                return new KeywordMatcher.StepMatch("\u0d12\u0d2a\u0d4d\u0d2a\u0d02", 5, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u0d2a\u0d15\u0d4d\u0d37\u0d47")) {
                return new KeywordMatcher.StepMatch("\u0d2a\u0d15\u0d4d\u0d37\u0d47", 5, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class Mn
    implements KeywordMatcher {
        private Mn() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0424\u0443\u043d\u043a\u0446\u0438\u043e\u043d\u0430\u043b")) {
                return new KeywordMatcher.Match("\u0424\u0443\u043d\u043a\u0446\u0438\u043e\u043d\u0430\u043b", 11);
            }
            if (line.startsWithTitleKeyword("\u0424\u0443\u043d\u043a\u0446")) {
                return new KeywordMatcher.Match("\u0424\u0443\u043d\u043a\u0446", 6);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0410\u0433\u0443\u0443\u043b\u0433\u0430")) {
                return new KeywordMatcher.Match("\u0410\u0433\u0443\u0443\u043b\u0433\u0430", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0421\u0446\u0435\u043d\u0430\u0440\u044b\u043d \u0442\u04e9\u043b\u04e9\u0432\u043b\u04e9\u0433\u04e9\u04e9")) {
                return new KeywordMatcher.Match("\u0421\u0446\u0435\u043d\u0430\u0440\u044b\u043d \u0442\u04e9\u043b\u04e9\u0432\u043b\u04e9\u0433\u04e9\u04e9", 20);
            }
            if (line.startsWithTitleKeyword("\u0421\u0446\u0435\u043d\u0430\u0440")) {
                return new KeywordMatcher.Match("\u0421\u0446\u0435\u043d\u0430\u0440", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0422\u0443\u0445\u0430\u0439\u043b\u0431\u0430\u043b")) {
                return new KeywordMatcher.Match("\u0422\u0443\u0445\u0430\u0439\u043b\u0431\u0430\u043b", 10);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("\u04e8\u0433\u04e9\u0433\u0434\u0441\u04e9\u043d \u043d\u044c ")) {
                return new KeywordMatcher.StepMatch("\u04e8\u0433\u04e9\u0433\u0434\u0441\u04e9\u043d \u043d\u044c ", 12, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u04ae\u04af\u043d\u0438\u0439 \u0434\u0430\u0440\u0430\u0430 ")) {
                return new KeywordMatcher.StepMatch("\u04ae\u04af\u043d\u0438\u0439 \u0434\u0430\u0440\u0430\u0430 ", 12, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("\u0422\u044d\u0433\u044d\u0445\u044d\u0434 ")) {
                return new KeywordMatcher.StepMatch("\u0422\u044d\u0433\u044d\u0445\u044d\u0434 ", 8, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("\u0422\u044d\u0433\u044d\u044d\u0434 ")) {
                return new KeywordMatcher.StepMatch("\u0422\u044d\u0433\u044d\u044d\u0434 ", 7, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u0413\u044d\u0445\u0434\u044d\u044d ")) {
                return new KeywordMatcher.StepMatch("\u0413\u044d\u0445\u0434\u044d\u044d ", 7, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u0425\u0430\u0440\u0438\u043d ")) {
                return new KeywordMatcher.StepMatch("\u0425\u0430\u0440\u0438\u043d ", 6, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u0425\u044d\u0440\u044d\u0432 ")) {
                return new KeywordMatcher.StepMatch("\u0425\u044d\u0440\u044d\u0432 ", 6, StepKeywordType.ACTION);
            }
            if (line.startsWith("\u0410\u043d\u0445 ")) {
                return new KeywordMatcher.StepMatch("\u0410\u043d\u0445 ", 4, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u041c\u04e9\u043d ")) {
                return new KeywordMatcher.StepMatch("\u041c\u04e9\u043d ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class Mr
    implements KeywordMatcher {
        private Mr() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0935\u0948\u0936\u093f\u0937\u094d\u091f\u094d\u092f")) {
                return new KeywordMatcher.Match("\u0935\u0948\u0936\u093f\u0937\u094d\u091f\u094d\u092f", 10);
            }
            if (line.startsWithTitleKeyword("\u0938\u0941\u0935\u093f\u0927\u093e")) {
                return new KeywordMatcher.Match("\u0938\u0941\u0935\u093f\u0927\u093e", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u092a\u093e\u0930\u094d\u0936\u094d\u0935\u092d\u0942\u092e\u0940")) {
                return new KeywordMatcher.Match("\u092a\u093e\u0930\u094d\u0936\u094d\u0935\u092d\u0942\u092e\u0940", 12);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0928\u093f\u092f\u092e")) {
                return new KeywordMatcher.Match("\u0928\u093f\u092f\u092e", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u092a\u0930\u093f\u0926\u0943\u0936\u094d\u092f \u0930\u0942\u092a\u0930\u0947\u0916\u093e")) {
                return new KeywordMatcher.Match("\u092a\u0930\u093f\u0926\u0943\u0936\u094d\u092f \u0930\u0942\u092a\u0930\u0947\u0916\u093e", 17);
            }
            if (line.startsWithTitleKeyword("\u092a\u0930\u093f\u0926\u0943\u0936\u094d\u092f")) {
                return new KeywordMatcher.Match("\u092a\u0930\u093f\u0926\u0943\u0936\u094d\u092f", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0909\u0926\u093e\u0939\u0930\u0923")) {
                return new KeywordMatcher.Match("\u0909\u0926\u093e\u0939\u0930\u0923", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("\u0926\u093f\u0932\u0947\u0932\u094d\u092f\u093e \u092a\u094d\u0930\u092e\u093e\u0923\u0947 ")) {
                return new KeywordMatcher.StepMatch("\u0926\u093f\u0932\u0947\u0932\u094d\u092f\u093e \u092a\u094d\u0930\u092e\u093e\u0923\u0947 ", 17, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u0924\u0947\u0935\u094d\u0939\u093e ")) {
                return new KeywordMatcher.StepMatch("\u0924\u0947\u0935\u094d\u0939\u093e ", 7, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("\u091c\u0947\u0935\u094d\u0939\u093e ")) {
                return new KeywordMatcher.StepMatch("\u091c\u0947\u0935\u094d\u0939\u093e ", 7, StepKeywordType.ACTION);
            }
            if (line.startsWith("\u092a\u0930\u0902\u0924\u0941 ")) {
                return new KeywordMatcher.StepMatch("\u092a\u0930\u0902\u0924\u0941 ", 6, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u0924\u0938\u0947\u091a ")) {
                return new KeywordMatcher.StepMatch("\u0924\u0938\u0947\u091a ", 5, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u0906\u0923\u093f ")) {
                return new KeywordMatcher.StepMatch("\u0906\u0923\u093f ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u092a\u0923 ")) {
                return new KeywordMatcher.StepMatch("\u092a\u0923 ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u092e\u0917 ")) {
                return new KeywordMatcher.StepMatch("\u092e\u0917 ", 3, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("\u091c\u0930")) {
                return new KeywordMatcher.StepMatch("\u091c\u0930", 2, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class Ne
    implements KeywordMatcher {
        private Ne() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0935\u093f\u0936\u0947\u0937\u0924\u093e")) {
                return new KeywordMatcher.Match("\u0935\u093f\u0936\u0947\u0937\u0924\u093e", 8);
            }
            if (line.startsWithTitleKeyword("\u0938\u0941\u0935\u093f\u0927\u093e")) {
                return new KeywordMatcher.Match("\u0938\u0941\u0935\u093f\u0927\u093e", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u092a\u0943\u0937\u094d\u0920\u092d\u0942\u092e\u0940")) {
                return new KeywordMatcher.Match("\u092a\u0943\u0937\u094d\u0920\u092d\u0942\u092e\u0940", 10);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0928\u093f\u092f\u092e")) {
                return new KeywordMatcher.Match("\u0928\u093f\u092f\u092e", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u092a\u0930\u093f\u0926\u0943\u0936\u094d\u092f \u0930\u0942\u092a\u0930\u0947\u0916\u093e")) {
                return new KeywordMatcher.Match("\u092a\u0930\u093f\u0926\u0943\u0936\u094d\u092f \u0930\u0942\u092a\u0930\u0947\u0916\u093e", 17);
            }
            if (line.startsWithTitleKeyword("\u092a\u0930\u093f\u0926\u0943\u0936\u094d\u092f")) {
                return new KeywordMatcher.Match("\u092a\u0930\u093f\u0926\u0943\u0936\u094d\u092f", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0909\u0926\u093e\u0939\u0930\u0923\u0939\u0930\u0941")) {
                return new KeywordMatcher.Match("\u0909\u0926\u093e\u0939\u0930\u0923\u0939\u0930\u0941", 10);
            }
            if (line.startsWithTitleKeyword("\u0909\u0926\u093e\u0939\u0930\u0923")) {
                return new KeywordMatcher.Match("\u0909\u0926\u093e\u0939\u0930\u0923", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("\u0924\u094d\u092f\u0938\u092a\u091b\u093f ")) {
                return new KeywordMatcher.StepMatch("\u0924\u094d\u092f\u0938\u092a\u091b\u093f ", 8, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("\u0926\u093f\u0907\u090f\u0915\u094b ")) {
                return new KeywordMatcher.StepMatch("\u0926\u093f\u0907\u090f\u0915\u094b ", 7, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u0926\u093f\u090f\u0915\u094b ")) {
                return new KeywordMatcher.StepMatch("\u0926\u093f\u090f\u0915\u094b ", 6, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u092f\u0926\u093f ")) {
                return new KeywordMatcher.StepMatch("\u092f\u0926\u093f ", 4, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u0905\u0928\u093f ")) {
                return new KeywordMatcher.StepMatch("\u0905\u0928\u093f ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u0905\u0928\u0940 ")) {
                return new KeywordMatcher.StepMatch("\u0905\u0928\u0940 ", 4, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("\u091c\u092c ")) {
                return new KeywordMatcher.StepMatch("\u091c\u092c ", 3, StepKeywordType.ACTION);
            }
            if (line.startsWith("\u0924\u0930 ")) {
                return new KeywordMatcher.StepMatch("\u0924\u0930 ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u0930 ")) {
                return new KeywordMatcher.StepMatch("\u0930 ", 2, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class Nl
    implements KeywordMatcher {
        private Nl() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Functionaliteit")) {
                return new KeywordMatcher.Match("Functionaliteit", 16);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Achtergrond")) {
                return new KeywordMatcher.Match("Achtergrond", 12);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Regel")) {
                return new KeywordMatcher.Match("Regel", 6);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Abstract Scenario")) {
                return new KeywordMatcher.Match("Abstract Scenario", 18);
            }
            if (line.startsWithTitleKeyword("Voorbeeld")) {
                return new KeywordMatcher.Match("Voorbeeld", 10);
            }
            if (line.startsWithTitleKeyword("Scenario")) {
                return new KeywordMatcher.Match("Scenario", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Voorbeelden")) {
                return new KeywordMatcher.Match("Voorbeelden", 12);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Wanneer ")) {
                return new KeywordMatcher.StepMatch("Wanneer ", 8, StepKeywordType.ACTION);
            }
            if (line.startsWith("Gegeven ")) {
                return new KeywordMatcher.StepMatch("Gegeven ", 8, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Maar ")) {
                return new KeywordMatcher.StepMatch("Maar ", 5, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Stel ")) {
                return new KeywordMatcher.StepMatch("Stel ", 5, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Als ")) {
                return new KeywordMatcher.StepMatch("Als ", 4, StepKeywordType.ACTION);
            }
            if (line.startsWith("Dan ")) {
                return new KeywordMatcher.StepMatch("Dan ", 4, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("En ")) {
                return new KeywordMatcher.StepMatch("En ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class No
    implements KeywordMatcher {
        private No() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Egenskap")) {
                return new KeywordMatcher.Match("Egenskap", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Bakgrunn")) {
                return new KeywordMatcher.Match("Bakgrunn", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Regel")) {
                return new KeywordMatcher.Match("Regel", 6);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Abstrakt Scenario")) {
                return new KeywordMatcher.Match("Abstrakt Scenario", 18);
            }
            if (line.startsWithTitleKeyword("Scenariomal")) {
                return new KeywordMatcher.Match("Scenariomal", 12);
            }
            if (line.startsWithTitleKeyword("Eksempel")) {
                return new KeywordMatcher.Match("Eksempel", 9);
            }
            if (line.startsWithTitleKeyword("Scenario")) {
                return new KeywordMatcher.Match("Scenario", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Eksempler")) {
                return new KeywordMatcher.Match("Eksempler", 10);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Gitt ")) {
                return new KeywordMatcher.StepMatch("Gitt ", 5, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("N\u00e5r ")) {
                return new KeywordMatcher.StepMatch("N\u00e5r ", 4, StepKeywordType.ACTION);
            }
            if (line.startsWith("Men ")) {
                return new KeywordMatcher.StepMatch("Men ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Og ")) {
                return new KeywordMatcher.StepMatch("Og ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("S\u00e5 ")) {
                return new KeywordMatcher.StepMatch("S\u00e5 ", 3, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class Pa
    implements KeywordMatcher {
        private Pa() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0a28\u0a15\u0a36 \u0a28\u0a41\u0a39\u0a3e\u0a30")) {
                return new KeywordMatcher.Match("\u0a28\u0a15\u0a36 \u0a28\u0a41\u0a39\u0a3e\u0a30", 10);
            }
            if (line.startsWithTitleKeyword("\u0a2e\u0a41\u0a39\u0a3e\u0a02\u0a26\u0a30\u0a3e")) {
                return new KeywordMatcher.Match("\u0a2e\u0a41\u0a39\u0a3e\u0a02\u0a26\u0a30\u0a3e", 9);
            }
            if (line.startsWithTitleKeyword("\u0a16\u0a3e\u0a38\u0a40\u0a05\u0a24")) {
                return new KeywordMatcher.Match("\u0a16\u0a3e\u0a38\u0a40\u0a05\u0a24", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0a2a\u0a3f\u0a1b\u0a4b\u0a15\u0a5c")) {
                return new KeywordMatcher.Match("\u0a2a\u0a3f\u0a1b\u0a4b\u0a15\u0a5c", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0a2a\u0a1f\u0a15\u0a25\u0a3e \u0a30\u0a42\u0a2a \u0a30\u0a47\u0a16\u0a3e")) {
                return new KeywordMatcher.Match("\u0a2a\u0a1f\u0a15\u0a25\u0a3e \u0a30\u0a42\u0a2a \u0a30\u0a47\u0a16\u0a3e", 15);
            }
            if (line.startsWithTitleKeyword("\u0a2a\u0a1f\u0a15\u0a25\u0a3e \u0a22\u0a3e\u0a02\u0a1a\u0a3e")) {
                return new KeywordMatcher.Match("\u0a2a\u0a1f\u0a15\u0a25\u0a3e \u0a22\u0a3e\u0a02\u0a1a\u0a3e", 12);
            }
            if (line.startsWithTitleKeyword("\u0a09\u0a26\u0a3e\u0a39\u0a30\u0a28")) {
                return new KeywordMatcher.Match("\u0a09\u0a26\u0a3e\u0a39\u0a30\u0a28", 7);
            }
            if (line.startsWithTitleKeyword("\u0a2a\u0a1f\u0a15\u0a25\u0a3e")) {
                return new KeywordMatcher.Match("\u0a2a\u0a1f\u0a15\u0a25\u0a3e", 6);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0a09\u0a26\u0a3e\u0a39\u0a30\u0a28\u0a3e\u0a02")) {
                return new KeywordMatcher.Match("\u0a09\u0a26\u0a3e\u0a39\u0a30\u0a28\u0a3e\u0a02", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("\u0a1c\u0a3f\u0a35\u0a47\u0a02 \u0a15\u0a3f ")) {
                return new KeywordMatcher.StepMatch("\u0a1c\u0a3f\u0a35\u0a47\u0a02 \u0a15\u0a3f ", 9, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u0a1c\u0a26\u0a4b\u0a02 ")) {
                return new KeywordMatcher.StepMatch("\u0a1c\u0a26\u0a4b\u0a02 ", 5, StepKeywordType.ACTION);
            }
            if (line.startsWith("\u0a1c\u0a47\u0a15\u0a30 ")) {
                return new KeywordMatcher.StepMatch("\u0a1c\u0a47\u0a15\u0a30 ", 5, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u0a05\u0a24\u0a47 ")) {
                return new KeywordMatcher.StepMatch("\u0a05\u0a24\u0a47 ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u0a24\u0a26 ")) {
                return new KeywordMatcher.StepMatch("\u0a24\u0a26 ", 3, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("\u0a2a\u0a30 ")) {
                return new KeywordMatcher.StepMatch("\u0a2a\u0a30 ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class Pl
    implements KeywordMatcher {
        private Pl() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Potrzeba biznesowa")) {
                return new KeywordMatcher.Match("Potrzeba biznesowa", 19);
            }
            if (line.startsWithTitleKeyword("W\u0142a\u015bciwo\u015b\u0107")) {
                return new KeywordMatcher.Match("W\u0142a\u015bciwo\u015b\u0107", 11);
            }
            if (line.startsWithTitleKeyword("Funkcja")) {
                return new KeywordMatcher.Match("Funkcja", 8);
            }
            if (line.startsWithTitleKeyword("Aspekt")) {
                return new KeywordMatcher.Match("Aspekt", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Za\u0142o\u017cenia")) {
                return new KeywordMatcher.Match("Za\u0142o\u017cenia", 10);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Regu\u0142a")) {
                return new KeywordMatcher.Match("Regu\u0142a", 7);
            }
            if (line.startsWithTitleKeyword("Zasada")) {
                return new KeywordMatcher.Match("Zasada", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Szablon scenariusza")) {
                return new KeywordMatcher.Match("Szablon scenariusza", 20);
            }
            if (line.startsWithTitleKeyword("Scenariusz")) {
                return new KeywordMatcher.Match("Scenariusz", 11);
            }
            if (line.startsWithTitleKeyword("Przyk\u0142ad")) {
                return new KeywordMatcher.Match("Przyk\u0142ad", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Przyk\u0142ady")) {
                return new KeywordMatcher.Match("Przyk\u0142ady", 10);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Zak\u0142adaj\u0105c, \u017ce ")) {
                return new KeywordMatcher.StepMatch("Zak\u0142adaj\u0105c, \u017ce ", 15, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Zak\u0142adaj\u0105c ")) {
                return new KeywordMatcher.StepMatch("Zak\u0142adaj\u0105c ", 11, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Je\u017celi ")) {
                return new KeywordMatcher.StepMatch("Je\u017celi ", 7, StepKeywordType.ACTION);
            }
            if (line.startsWith("Wtedy ")) {
                return new KeywordMatcher.StepMatch("Wtedy ", 6, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Je\u015bli ")) {
                return new KeywordMatcher.StepMatch("Je\u015bli ", 6, StepKeywordType.ACTION);
            }
            if (line.startsWith("Kiedy ")) {
                return new KeywordMatcher.StepMatch("Kiedy ", 6, StepKeywordType.ACTION);
            }
            if (line.startsWith("Maj\u0105c ")) {
                return new KeywordMatcher.StepMatch("Maj\u0105c ", 6, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Oraz ")) {
                return new KeywordMatcher.StepMatch("Oraz ", 5, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Gdy ")) {
                return new KeywordMatcher.StepMatch("Gdy ", 4, StepKeywordType.ACTION);
            }
            if (line.startsWith("Ale ")) {
                return new KeywordMatcher.StepMatch("Ale ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            if (line.startsWith("I ")) {
                return new KeywordMatcher.StepMatch("I ", 2, StepKeywordType.CONJUNCTION);
            }
            return null;
        }
    }

    private static final class Pt
    implements KeywordMatcher {
        private Pt() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Funcionalidade")) {
                return new KeywordMatcher.Match("Funcionalidade", 15);
            }
            if (line.startsWithTitleKeyword("Caracter\u00edstica")) {
                return new KeywordMatcher.Match("Caracter\u00edstica", 15);
            }
            if (line.startsWithTitleKeyword("Caracteristica")) {
                return new KeywordMatcher.Match("Caracteristica", 15);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Cen\u00e1rio de Fundo")) {
                return new KeywordMatcher.Match("Cen\u00e1rio de Fundo", 17);
            }
            if (line.startsWithTitleKeyword("Cenario de Fundo")) {
                return new KeywordMatcher.Match("Cenario de Fundo", 17);
            }
            if (line.startsWithTitleKeyword("Contexto")) {
                return new KeywordMatcher.Match("Contexto", 9);
            }
            if (line.startsWithTitleKeyword("Fundo")) {
                return new KeywordMatcher.Match("Fundo", 6);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Regra")) {
                return new KeywordMatcher.Match("Regra", 6);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Delineacao do Cenario")) {
                return new KeywordMatcher.Match("Delineacao do Cenario", 22);
            }
            if (line.startsWithTitleKeyword("Delinea\u00e7\u00e3o do Cen\u00e1rio")) {
                return new KeywordMatcher.Match("Delinea\u00e7\u00e3o do Cen\u00e1rio", 22);
            }
            if (line.startsWithTitleKeyword("Esquema do Cen\u00e1rio")) {
                return new KeywordMatcher.Match("Esquema do Cen\u00e1rio", 19);
            }
            if (line.startsWithTitleKeyword("Esquema do Cenario")) {
                return new KeywordMatcher.Match("Esquema do Cenario", 19);
            }
            if (line.startsWithTitleKeyword("Exemplo")) {
                return new KeywordMatcher.Match("Exemplo", 8);
            }
            if (line.startsWithTitleKeyword("Cen\u00e1rio")) {
                return new KeywordMatcher.Match("Cen\u00e1rio", 8);
            }
            if (line.startsWithTitleKeyword("Cenario")) {
                return new KeywordMatcher.Match("Cenario", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Cen\u00e1rios")) {
                return new KeywordMatcher.Match("Cen\u00e1rios", 9);
            }
            if (line.startsWithTitleKeyword("Exemplos")) {
                return new KeywordMatcher.Match("Exemplos", 9);
            }
            if (line.startsWithTitleKeyword("Cenarios")) {
                return new KeywordMatcher.Match("Cenarios", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Quando ")) {
                return new KeywordMatcher.StepMatch("Quando ", 7, StepKeywordType.ACTION);
            }
            if (line.startsWith("Entao ")) {
                return new KeywordMatcher.StepMatch("Entao ", 6, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Dadas ")) {
                return new KeywordMatcher.StepMatch("Dadas ", 6, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Ent\u00e3o ")) {
                return new KeywordMatcher.StepMatch("Ent\u00e3o ", 6, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Dados ")) {
                return new KeywordMatcher.StepMatch("Dados ", 6, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Dada ")) {
                return new KeywordMatcher.StepMatch("Dada ", 5, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Dado ")) {
                return new KeywordMatcher.StepMatch("Dado ", 5, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Mas ")) {
                return new KeywordMatcher.StepMatch("Mas ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            if (line.startsWith("E ")) {
                return new KeywordMatcher.StepMatch("E ", 2, StepKeywordType.CONJUNCTION);
            }
            return null;
        }
    }

    private static final class Ro
    implements KeywordMatcher {
        private Ro() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Func\u0163ionalitate")) {
                return new KeywordMatcher.Match("Func\u0163ionalitate", 16);
            }
            if (line.startsWithTitleKeyword("Functionalitate")) {
                return new KeywordMatcher.Match("Functionalitate", 16);
            }
            if (line.startsWithTitleKeyword("Func\u021bionalitate")) {
                return new KeywordMatcher.Match("Func\u021bionalitate", 16);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Context")) {
                return new KeywordMatcher.Match("Context", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Structur\u0103 scenariu")) {
                return new KeywordMatcher.Match("Structur\u0103 scenariu", 19);
            }
            if (line.startsWithTitleKeyword("Structura scenariu")) {
                return new KeywordMatcher.Match("Structura scenariu", 19);
            }
            if (line.startsWithTitleKeyword("Scenariu")) {
                return new KeywordMatcher.Match("Scenariu", 9);
            }
            if (line.startsWithTitleKeyword("Exemplu")) {
                return new KeywordMatcher.Match("Exemplu", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Exemple")) {
                return new KeywordMatcher.Match("Exemple", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Da\u0163i fiind ")) {
                return new KeywordMatcher.StepMatch("Da\u0163i fiind ", 11, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Da\u021bi fiind ")) {
                return new KeywordMatcher.StepMatch("Da\u021bi fiind ", 11, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Date fiind ")) {
                return new KeywordMatcher.StepMatch("Date fiind ", 11, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Dati fiind ")) {
                return new KeywordMatcher.StepMatch("Dati fiind ", 11, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Dat fiind ")) {
                return new KeywordMatcher.StepMatch("Dat fiind ", 10, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Dat\u0103 fiind")) {
                return new KeywordMatcher.StepMatch("Dat\u0103 fiind", 10, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Atunci ")) {
                return new KeywordMatcher.StepMatch("Atunci ", 7, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Cand ")) {
                return new KeywordMatcher.StepMatch("Cand ", 5, StepKeywordType.ACTION);
            }
            if (line.startsWith("C\u00e2nd ")) {
                return new KeywordMatcher.StepMatch("C\u00e2nd ", 5, StepKeywordType.ACTION);
            }
            if (line.startsWith("Dar ")) {
                return new KeywordMatcher.StepMatch("Dar ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u0218i ")) {
                return new KeywordMatcher.StepMatch("\u0218i ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Si ")) {
                return new KeywordMatcher.StepMatch("Si ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u015ei ")) {
                return new KeywordMatcher.StepMatch("\u015ei ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class Ru
    implements KeywordMatcher {
        private Ru() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0424\u0443\u043d\u043a\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u043e\u0441\u0442\u044c")) {
                return new KeywordMatcher.Match("\u0424\u0443\u043d\u043a\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u043e\u0441\u0442\u044c", 17);
            }
            if (line.startsWithTitleKeyword("\u0424\u0443\u043d\u043a\u0446\u0438\u043e\u043d\u0430\u043b")) {
                return new KeywordMatcher.Match("\u0424\u0443\u043d\u043a\u0446\u0438\u043e\u043d\u0430\u043b", 11);
            }
            if (line.startsWithTitleKeyword("\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u043e")) {
                return new KeywordMatcher.Match("\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u043e", 9);
            }
            if (line.startsWithTitleKeyword("\u0424\u0443\u043d\u043a\u0446\u0438\u044f")) {
                return new KeywordMatcher.Match("\u0424\u0443\u043d\u043a\u0446\u0438\u044f", 8);
            }
            if (line.startsWithTitleKeyword("\u0424\u0438\u0447\u0430")) {
                return new KeywordMatcher.Match("\u0424\u0438\u0447\u0430", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u041f\u0440\u0435\u0434\u044b\u0441\u0442\u043e\u0440\u0438\u044f")) {
                return new KeywordMatcher.Match("\u041f\u0440\u0435\u0434\u044b\u0441\u0442\u043e\u0440\u0438\u044f", 12);
            }
            if (line.startsWithTitleKeyword("\u041a\u043e\u043d\u0442\u0435\u043a\u0441\u0442")) {
                return new KeywordMatcher.Match("\u041a\u043e\u043d\u0442\u0435\u043a\u0441\u0442", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u041f\u0440\u0430\u0432\u0438\u043b\u043e")) {
                return new KeywordMatcher.Match("\u041f\u0440\u0430\u0432\u0438\u043b\u043e", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0421\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430 \u0441\u0446\u0435\u043d\u0430\u0440\u0438\u044f")) {
                return new KeywordMatcher.Match("\u0421\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430 \u0441\u0446\u0435\u043d\u0430\u0440\u0438\u044f", 19);
            }
            if (line.startsWithTitleKeyword("\u0428\u0430\u0431\u043b\u043e\u043d \u0441\u0446\u0435\u043d\u0430\u0440\u0438\u044f")) {
                return new KeywordMatcher.Match("\u0428\u0430\u0431\u043b\u043e\u043d \u0441\u0446\u0435\u043d\u0430\u0440\u0438\u044f", 16);
            }
            if (line.startsWithTitleKeyword("\u0421\u0446\u0435\u043d\u0430\u0440\u0438\u0439")) {
                return new KeywordMatcher.Match("\u0421\u0446\u0435\u043d\u0430\u0440\u0438\u0439", 9);
            }
            if (line.startsWithTitleKeyword("\u041f\u0440\u0438\u043c\u0435\u0440")) {
                return new KeywordMatcher.Match("\u041f\u0440\u0438\u043c\u0435\u0440", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u044f")) {
                return new KeywordMatcher.Match("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u044f", 9);
            }
            if (line.startsWithTitleKeyword("\u041f\u0440\u0438\u043c\u0435\u0440\u044b")) {
                return new KeywordMatcher.Match("\u041f\u0440\u0438\u043c\u0435\u0440\u044b", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("\u041a \u0442\u043e\u043c\u0443 \u0436\u0435 ")) {
                return new KeywordMatcher.StepMatch("\u041a \u0442\u043e\u043c\u0443 \u0436\u0435 ", 10, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u0414\u043e\u043f\u0443\u0441\u0442\u0438\u043c ")) {
                return new KeywordMatcher.StepMatch("\u0414\u043e\u043f\u0443\u0441\u0442\u0438\u043c ", 9, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u0422\u043e\u0433\u0434\u0430 ")) {
                return new KeywordMatcher.StepMatch("\u0422\u043e\u0433\u0434\u0430 ", 6, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("\u041f\u0443\u0441\u0442\u044c ")) {
                return new KeywordMatcher.StepMatch("\u041f\u0443\u0441\u0442\u044c ", 6, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u0418\u043d\u0430\u0447\u0435 ")) {
                return new KeywordMatcher.StepMatch("\u0418\u043d\u0430\u0447\u0435 ", 6, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u0422\u0430\u043a\u0436\u0435 ")) {
                return new KeywordMatcher.StepMatch("\u0422\u0430\u043a\u0436\u0435 ", 6, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u041a\u043e\u0433\u0434\u0430 ")) {
                return new KeywordMatcher.StepMatch("\u041a\u043e\u0433\u0434\u0430 ", 6, StepKeywordType.ACTION);
            }
            if (line.startsWith("\u0417\u0430\u0442\u0435\u043c ")) {
                return new KeywordMatcher.StepMatch("\u0417\u0430\u0442\u0435\u043c ", 6, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("\u0414\u0430\u043d\u043e ")) {
                return new KeywordMatcher.StepMatch("\u0414\u0430\u043d\u043e ", 5, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u0415\u0441\u043b\u0438 ")) {
                return new KeywordMatcher.StepMatch("\u0415\u0441\u043b\u0438 ", 5, StepKeywordType.ACTION);
            }
            if (line.startsWith("\u041d\u043e ")) {
                return new KeywordMatcher.StepMatch("\u041d\u043e ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u0422\u043e ")) {
                return new KeywordMatcher.StepMatch("\u0422\u043e ", 3, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("\u0418 ")) {
                return new KeywordMatcher.StepMatch("\u0418 ", 2, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u0410 ")) {
                return new KeywordMatcher.StepMatch("\u0410 ", 2, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class Sk
    implements KeywordMatcher {
        private Sk() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Po\u017eiadavka")) {
                return new KeywordMatcher.Match("Po\u017eiadavka", 11);
            }
            if (line.startsWithTitleKeyword("Vlastnos\u0165")) {
                return new KeywordMatcher.Match("Vlastnos\u0165", 10);
            }
            if (line.startsWithTitleKeyword("Funkcia")) {
                return new KeywordMatcher.Match("Funkcia", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Pozadie")) {
                return new KeywordMatcher.Match("Pozadie", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Osnova Scen\u00e1ra")) {
                return new KeywordMatcher.Match("Osnova Scen\u00e1ra", 15);
            }
            if (line.startsWithTitleKeyword("N\u00e1\u010drt Scen\u00e1ra")) {
                return new KeywordMatcher.Match("N\u00e1\u010drt Scen\u00e1ra", 14);
            }
            if (line.startsWithTitleKeyword("N\u00e1\u010drt Scen\u00e1ru")) {
                return new KeywordMatcher.Match("N\u00e1\u010drt Scen\u00e1ru", 14);
            }
            if (line.startsWithTitleKeyword("Pr\u00edklad")) {
                return new KeywordMatcher.Match("Pr\u00edklad", 8);
            }
            if (line.startsWithTitleKeyword("Scen\u00e1r")) {
                return new KeywordMatcher.Match("Scen\u00e1r", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Pr\u00edklady")) {
                return new KeywordMatcher.Match("Pr\u00edklady", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Za predpokladu ")) {
                return new KeywordMatcher.StepMatch("Za predpokladu ", 15, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("A taktie\u017e ")) {
                return new KeywordMatcher.StepMatch("A taktie\u017e ", 10, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("A z\u00e1rove\u0148 ")) {
                return new KeywordMatcher.StepMatch("A z\u00e1rove\u0148 ", 10, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Pokia\u013e ")) {
                return new KeywordMatcher.StepMatch("Pokia\u013e ", 7, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("A tie\u017e ")) {
                return new KeywordMatcher.StepMatch("A tie\u017e ", 7, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Potom ")) {
                return new KeywordMatcher.StepMatch("Potom ", 6, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Tak ")) {
                return new KeywordMatcher.StepMatch("Tak ", 4, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Ke\u010f ")) {
                return new KeywordMatcher.StepMatch("Ke\u010f ", 4, StepKeywordType.ACTION);
            }
            if (line.startsWith("Ale ")) {
                return new KeywordMatcher.StepMatch("Ale ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Ak ")) {
                return new KeywordMatcher.StepMatch("Ak ", 3, StepKeywordType.ACTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            if (line.startsWith("A ")) {
                return new KeywordMatcher.StepMatch("A ", 2, StepKeywordType.CONJUNCTION);
            }
            return null;
        }
    }

    private static final class Sl
    implements KeywordMatcher {
        private Sl() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Funkcionalnost")) {
                return new KeywordMatcher.Match("Funkcionalnost", 15);
            }
            if (line.startsWithTitleKeyword("Zna\u010dilnost")) {
                return new KeywordMatcher.Match("Zna\u010dilnost", 11);
            }
            if (line.startsWithTitleKeyword("Mo\u017enosti")) {
                return new KeywordMatcher.Match("Mo\u017enosti", 9);
            }
            if (line.startsWithTitleKeyword("Moznosti")) {
                return new KeywordMatcher.Match("Moznosti", 9);
            }
            if (line.startsWithTitleKeyword("Lastnost")) {
                return new KeywordMatcher.Match("Lastnost", 9);
            }
            if (line.startsWithTitleKeyword("Funkcija")) {
                return new KeywordMatcher.Match("Funkcija", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Kontekst")) {
                return new KeywordMatcher.Match("Kontekst", 9);
            }
            if (line.startsWithTitleKeyword("Osnova")) {
                return new KeywordMatcher.Match("Osnova", 7);
            }
            if (line.startsWithTitleKeyword("Ozadje")) {
                return new KeywordMatcher.Match("Ozadje", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Struktura scenarija")) {
                return new KeywordMatcher.Match("Struktura scenarija", 20);
            }
            if (line.startsWithTitleKeyword("Oris scenarija")) {
                return new KeywordMatcher.Match("Oris scenarija", 15);
            }
            if (line.startsWithTitleKeyword("Scenarij")) {
                return new KeywordMatcher.Match("Scenarij", 9);
            }
            if (line.startsWithTitleKeyword("Osnutek")) {
                return new KeywordMatcher.Match("Osnutek", 8);
            }
            if (line.startsWithTitleKeyword("Koncept")) {
                return new KeywordMatcher.Match("Koncept", 8);
            }
            if (line.startsWithTitleKeyword("Primer")) {
                return new KeywordMatcher.Match("Primer", 7);
            }
            if (line.startsWithTitleKeyword("Skica")) {
                return new KeywordMatcher.Match("Skica", 6);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Scenariji")) {
                return new KeywordMatcher.Match("Scenariji", 10);
            }
            if (line.startsWithTitleKeyword("Primeri")) {
                return new KeywordMatcher.Match("Primeri", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Privzeto ")) {
                return new KeywordMatcher.StepMatch("Privzeto ", 9, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Vendar ")) {
                return new KeywordMatcher.StepMatch("Vendar ", 7, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Podano ")) {
                return new KeywordMatcher.StepMatch("Podano ", 7, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Zaradi ")) {
                return new KeywordMatcher.StepMatch("Zaradi ", 7, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Takrat ")) {
                return new KeywordMatcher.StepMatch("Takrat ", 7, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Kadar ")) {
                return new KeywordMatcher.StepMatch("Kadar ", 6, StepKeywordType.ACTION);
            }
            if (line.startsWith("Ampak ")) {
                return new KeywordMatcher.StepMatch("Ampak ", 6, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Potem ")) {
                return new KeywordMatcher.StepMatch("Potem ", 6, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Nato ")) {
                return new KeywordMatcher.StepMatch("Nato ", 5, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Dano ")) {
                return new KeywordMatcher.StepMatch("Dano ", 5, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Toda ")) {
                return new KeywordMatcher.StepMatch("Toda ", 5, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Ter ")) {
                return new KeywordMatcher.StepMatch("Ter ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u010ce ")) {
                return new KeywordMatcher.StepMatch("\u010ce ", 3, StepKeywordType.ACTION);
            }
            if (line.startsWith("In ")) {
                return new KeywordMatcher.StepMatch("In ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Ko ")) {
                return new KeywordMatcher.StepMatch("Ko ", 3, StepKeywordType.ACTION);
            }
            if (line.startsWith("Ce ")) {
                return new KeywordMatcher.StepMatch("Ce ", 3, StepKeywordType.ACTION);
            }
            return null;
        }
    }

    private static final class Sr_cyrl
    implements KeywordMatcher {
        private Sr_cyrl() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0424\u0443\u043d\u043a\u0446\u0438\u043e\u043d\u0430\u043b\u043d\u043e\u0441\u0442")) {
                return new KeywordMatcher.Match("\u0424\u0443\u043d\u043a\u0446\u0438\u043e\u043d\u0430\u043b\u043d\u043e\u0441\u0442", 15);
            }
            if (line.startsWithTitleKeyword("\u041c\u043e\u0433\u0443\u045b\u043d\u043e\u0441\u0442")) {
                return new KeywordMatcher.Match("\u041c\u043e\u0433\u0443\u045b\u043d\u043e\u0441\u0442", 10);
            }
            if (line.startsWithTitleKeyword("\u041e\u0441\u043e\u0431\u0438\u043d\u0430")) {
                return new KeywordMatcher.Match("\u041e\u0441\u043e\u0431\u0438\u043d\u0430", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u041f\u043e\u0437\u0430\u0434\u0438\u043d\u0430")) {
                return new KeywordMatcher.Match("\u041f\u043e\u0437\u0430\u0434\u0438\u043d\u0430", 9);
            }
            if (line.startsWithTitleKeyword("\u041a\u043e\u043d\u0442\u0435\u043a\u0441\u0442")) {
                return new KeywordMatcher.Match("\u041a\u043e\u043d\u0442\u0435\u043a\u0441\u0442", 9);
            }
            if (line.startsWithTitleKeyword("\u041e\u0441\u043d\u043e\u0432\u0430")) {
                return new KeywordMatcher.Match("\u041e\u0441\u043d\u043e\u0432\u0430", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u041f\u0440\u0430\u0432\u0438\u043b\u043e")) {
                return new KeywordMatcher.Match("\u041f\u0440\u0430\u0432\u0438\u043b\u043e", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0421\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430 \u0441\u0446\u0435\u043d\u0430\u0440\u0438\u0458\u0430")) {
                return new KeywordMatcher.Match("\u0421\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430 \u0441\u0446\u0435\u043d\u0430\u0440\u0438\u0458\u0430", 20);
            }
            if (line.startsWithTitleKeyword("\u0421\u0446\u0435\u043d\u0430\u0440\u0438\u043e")) {
                return new KeywordMatcher.Match("\u0421\u0446\u0435\u043d\u0430\u0440\u0438\u043e", 9);
            }
            if (line.startsWithTitleKeyword("\u041a\u043e\u043d\u0446\u0435\u043f\u0442")) {
                return new KeywordMatcher.Match("\u041a\u043e\u043d\u0446\u0435\u043f\u0442", 8);
            }
            if (line.startsWithTitleKeyword("\u041f\u0440\u0438\u043c\u0435\u0440")) {
                return new KeywordMatcher.Match("\u041f\u0440\u0438\u043c\u0435\u0440", 7);
            }
            if (line.startsWithTitleKeyword("\u0421\u043a\u0438\u0446\u0430")) {
                return new KeywordMatcher.Match("\u0421\u043a\u0438\u0446\u0430", 6);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0421\u0446\u0435\u043d\u0430\u0440\u0438\u0458\u0438")) {
                return new KeywordMatcher.Match("\u0421\u0446\u0435\u043d\u0430\u0440\u0438\u0458\u0438", 10);
            }
            if (line.startsWithTitleKeyword("\u041f\u0440\u0438\u043c\u0435\u0440\u0438")) {
                return new KeywordMatcher.Match("\u041f\u0440\u0438\u043c\u0435\u0440\u0438", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("\u0417\u0430 \u0434\u0430\u0442\u0438 ")) {
                return new KeywordMatcher.StepMatch("\u0417\u0430 \u0434\u0430\u0442\u0438 ", 8, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u0417\u0430 \u0434\u0430\u0442\u043e ")) {
                return new KeywordMatcher.StepMatch("\u0417\u0430 \u0434\u0430\u0442\u043e ", 8, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u0417\u0430 \u0434\u0430\u0442\u0435 ")) {
                return new KeywordMatcher.StepMatch("\u0417\u0430 \u0434\u0430\u0442\u0435 ", 8, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u041e\u043d\u0434\u0430 ")) {
                return new KeywordMatcher.StepMatch("\u041e\u043d\u0434\u0430 ", 5, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("\u041a\u0430\u0434\u0430 ")) {
                return new KeywordMatcher.StepMatch("\u041a\u0430\u0434\u0430 ", 5, StepKeywordType.ACTION);
            }
            if (line.startsWith("\u041a\u0430\u0434 ")) {
                return new KeywordMatcher.StepMatch("\u041a\u0430\u0434 ", 4, StepKeywordType.ACTION);
            }
            if (line.startsWith("\u0410\u043b\u0438 ")) {
                return new KeywordMatcher.StepMatch("\u0410\u043b\u0438 ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u0418 ")) {
                return new KeywordMatcher.StepMatch("\u0418 ", 2, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class Sr_latn
    implements KeywordMatcher {
        private Sr_latn() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Funkcionalnost")) {
                return new KeywordMatcher.Match("Funkcionalnost", 15);
            }
            if (line.startsWithTitleKeyword("Mogucnost")) {
                return new KeywordMatcher.Match("Mogucnost", 10);
            }
            if (line.startsWithTitleKeyword("Mogu\u0107nost")) {
                return new KeywordMatcher.Match("Mogu\u0107nost", 10);
            }
            if (line.startsWithTitleKeyword("Osobina")) {
                return new KeywordMatcher.Match("Osobina", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Kontekst")) {
                return new KeywordMatcher.Match("Kontekst", 9);
            }
            if (line.startsWithTitleKeyword("Pozadina")) {
                return new KeywordMatcher.Match("Pozadina", 9);
            }
            if (line.startsWithTitleKeyword("Osnova")) {
                return new KeywordMatcher.Match("Osnova", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Pravilo")) {
                return new KeywordMatcher.Match("Pravilo", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Struktura scenarija")) {
                return new KeywordMatcher.Match("Struktura scenarija", 20);
            }
            if (line.startsWithTitleKeyword("Scenario")) {
                return new KeywordMatcher.Match("Scenario", 9);
            }
            if (line.startsWithTitleKeyword("Koncept")) {
                return new KeywordMatcher.Match("Koncept", 8);
            }
            if (line.startsWithTitleKeyword("Primer")) {
                return new KeywordMatcher.Match("Primer", 7);
            }
            if (line.startsWithTitleKeyword("Skica")) {
                return new KeywordMatcher.Match("Skica", 6);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Scenariji")) {
                return new KeywordMatcher.Match("Scenariji", 10);
            }
            if (line.startsWithTitleKeyword("Primeri")) {
                return new KeywordMatcher.Match("Primeri", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Za dati ")) {
                return new KeywordMatcher.StepMatch("Za dati ", 8, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Za date ")) {
                return new KeywordMatcher.StepMatch("Za date ", 8, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Za dato ")) {
                return new KeywordMatcher.StepMatch("Za dato ", 8, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Kada ")) {
                return new KeywordMatcher.StepMatch("Kada ", 5, StepKeywordType.ACTION);
            }
            if (line.startsWith("Onda ")) {
                return new KeywordMatcher.StepMatch("Onda ", 5, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Kad ")) {
                return new KeywordMatcher.StepMatch("Kad ", 4, StepKeywordType.ACTION);
            }
            if (line.startsWith("Ali ")) {
                return new KeywordMatcher.StepMatch("Ali ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            if (line.startsWith("I ")) {
                return new KeywordMatcher.StepMatch("I ", 2, StepKeywordType.CONJUNCTION);
            }
            return null;
        }
    }

    private static final class Sv
    implements KeywordMatcher {
        private Sv() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Egenskap")) {
                return new KeywordMatcher.Match("Egenskap", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Bakgrund")) {
                return new KeywordMatcher.Match("Bakgrund", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Regel")) {
                return new KeywordMatcher.Match("Regel", 6);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Abstrakt Scenario")) {
                return new KeywordMatcher.Match("Abstrakt Scenario", 18);
            }
            if (line.startsWithTitleKeyword("Scenariomall")) {
                return new KeywordMatcher.Match("Scenariomall", 13);
            }
            if (line.startsWithTitleKeyword("Scenario")) {
                return new KeywordMatcher.Match("Scenario", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Exempel")) {
                return new KeywordMatcher.Match("Exempel", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Givet ")) {
                return new KeywordMatcher.StepMatch("Givet ", 6, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("N\u00e4r ")) {
                return new KeywordMatcher.StepMatch("N\u00e4r ", 4, StepKeywordType.ACTION);
            }
            if (line.startsWith("Och ")) {
                return new KeywordMatcher.StepMatch("Och ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Men ")) {
                return new KeywordMatcher.StepMatch("Men ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("S\u00e5 ")) {
                return new KeywordMatcher.StepMatch("S\u00e5 ", 3, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class Ta
    implements KeywordMatcher {
        private Ta() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0bb5\u0ba3\u0bbf\u0b95 \u0ba4\u0bc7\u0bb5\u0bc8")) {
                return new KeywordMatcher.Match("\u0bb5\u0ba3\u0bbf\u0b95 \u0ba4\u0bc7\u0bb5\u0bc8", 10);
            }
            if (line.startsWithTitleKeyword("\u0b85\u0bae\u0bcd\u0b9a\u0bae\u0bcd")) {
                return new KeywordMatcher.Match("\u0b85\u0bae\u0bcd\u0b9a\u0bae\u0bcd", 7);
            }
            if (line.startsWithTitleKeyword("\u0ba4\u0bbf\u0bb1\u0ba9\u0bcd")) {
                return new KeywordMatcher.Match("\u0ba4\u0bbf\u0bb1\u0ba9\u0bcd", 6);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0baa\u0bbf\u0ba9\u0bcd\u0ba9\u0ba3\u0bbf")) {
                return new KeywordMatcher.Match("\u0baa\u0bbf\u0ba9\u0bcd\u0ba9\u0ba3\u0bbf", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0b95\u0bbe\u0b9f\u0bcd\u0b9a\u0bbf \u0bb5\u0bbe\u0bb0\u0bcd\u0baa\u0bcd\u0baa\u0bc1\u0bb0\u0bc1")) {
                return new KeywordMatcher.Match("\u0b95\u0bbe\u0b9f\u0bcd\u0b9a\u0bbf \u0bb5\u0bbe\u0bb0\u0bcd\u0baa\u0bcd\u0baa\u0bc1\u0bb0\u0bc1", 18);
            }
            if (line.startsWithTitleKeyword("\u0b95\u0bbe\u0b9f\u0bcd\u0b9a\u0bbf \u0b9a\u0bc1\u0bb0\u0bc1\u0b95\u0bcd\u0b95\u0bae\u0bcd")) {
                return new KeywordMatcher.Match("\u0b95\u0bbe\u0b9f\u0bcd\u0b9a\u0bbf \u0b9a\u0bc1\u0bb0\u0bc1\u0b95\u0bcd\u0b95\u0bae\u0bcd", 17);
            }
            if (line.startsWithTitleKeyword("\u0b89\u0ba4\u0bbe\u0bb0\u0ba3\u0bae\u0bbe\u0b95")) {
                return new KeywordMatcher.Match("\u0b89\u0ba4\u0bbe\u0bb0\u0ba3\u0bae\u0bbe\u0b95", 9);
            }
            if (line.startsWithTitleKeyword("\u0b95\u0bbe\u0b9f\u0bcd\u0b9a\u0bbf")) {
                return new KeywordMatcher.Match("\u0b95\u0bbe\u0b9f\u0bcd\u0b9a\u0bbf", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0b8e\u0b9f\u0bc1\u0ba4\u0bcd\u0ba4\u0bc1\u0b95\u0bcd\u0b95\u0bbe\u0b9f\u0bcd\u0b9f\u0bc1\u0b95\u0bb3\u0bcd")) {
                return new KeywordMatcher.Match("\u0b8e\u0b9f\u0bc1\u0ba4\u0bcd\u0ba4\u0bc1\u0b95\u0bcd\u0b95\u0bbe\u0b9f\u0bcd\u0b9f\u0bc1\u0b95\u0bb3\u0bcd", 19);
            }
            if (line.startsWithTitleKeyword("\u0ba8\u0bbf\u0bb2\u0bc8\u0bae\u0bc8\u0b95\u0bb3\u0bbf\u0bb2\u0bcd")) {
                return new KeywordMatcher.Match("\u0ba8\u0bbf\u0bb2\u0bc8\u0bae\u0bc8\u0b95\u0bb3\u0bbf\u0bb2\u0bcd", 12);
            }
            if (line.startsWithTitleKeyword("\u0b95\u0bbe\u0b9f\u0bcd\u0b9a\u0bbf\u0b95\u0bb3\u0bcd")) {
                return new KeywordMatcher.Match("\u0b95\u0bbe\u0b9f\u0bcd\u0b9a\u0bbf\u0b95\u0bb3\u0bcd", 10);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("\u0b95\u0bc6\u0bbe\u0b9f\u0bc1\u0b95\u0bcd\u0b95\u0baa\u0bcd\u0baa\u0b9f\u0bcd\u0b9f ")) {
                return new KeywordMatcher.StepMatch("\u0b95\u0bc6\u0bbe\u0b9f\u0bc1\u0b95\u0bcd\u0b95\u0baa\u0bcd\u0baa\u0b9f\u0bcd\u0b9f ", 15, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u0b85\u0baa\u0bcd\u0baa\u0bc6\u0bbe\u0bb4\u0bc1\u0ba4\u0bc1 ")) {
                return new KeywordMatcher.StepMatch("\u0b85\u0baa\u0bcd\u0baa\u0bc6\u0bbe\u0bb4\u0bc1\u0ba4\u0bc1 ", 11, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("\u0b8e\u0baa\u0bcd\u0baa\u0bc7\u0bbe\u0ba4\u0bc1 ")) {
                return new KeywordMatcher.StepMatch("\u0b8e\u0baa\u0bcd\u0baa\u0bc7\u0bbe\u0ba4\u0bc1 ", 9, StepKeywordType.ACTION);
            }
            if (line.startsWith("\u0bae\u0bb1\u0bcd\u0bb1\u0bc1\u0bae\u0bcd ")) {
                return new KeywordMatcher.StepMatch("\u0bae\u0bb1\u0bcd\u0bb1\u0bc1\u0bae\u0bcd ", 8, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u0bae\u0bc7\u0bb2\u0bc1\u0bae\u0bcd ")) {
                return new KeywordMatcher.StepMatch("\u0bae\u0bc7\u0bb2\u0bc1\u0bae\u0bcd ", 7, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u0b86\u0ba9\u0bbe\u0bb2\u0bcd ")) {
                return new KeywordMatcher.StepMatch("\u0b86\u0ba9\u0bbe\u0bb2\u0bcd ", 6, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class Te
    implements KeywordMatcher {
        private Te() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0c17\u0c41\u0c23\u0c2e\u0c41")) {
                return new KeywordMatcher.Match("\u0c17\u0c41\u0c23\u0c2e\u0c41", 6);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0c28\u0c47\u0c2a\u0c25\u0c4d\u0c2f\u0c02")) {
                return new KeywordMatcher.Match("\u0c28\u0c47\u0c2a\u0c25\u0c4d\u0c2f\u0c02", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0c38\u0c28\u0c4d\u0c28\u0c3f\u0c35\u0c47\u0c36\u0c02")) {
                return new KeywordMatcher.Match("\u0c38\u0c28\u0c4d\u0c28\u0c3f\u0c35\u0c47\u0c36\u0c02", 10);
            }
            if (line.startsWithTitleKeyword("\u0c09\u0c26\u0c3e\u0c39\u0c30\u0c23")) {
                return new KeywordMatcher.Match("\u0c09\u0c26\u0c3e\u0c39\u0c30\u0c23", 7);
            }
            if (line.startsWithTitleKeyword("\u0c15\u0c25\u0c28\u0c02")) {
                return new KeywordMatcher.Match("\u0c15\u0c25\u0c28\u0c02", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0c09\u0c26\u0c3e\u0c39\u0c30\u0c23\u0c32\u0c41")) {
                return new KeywordMatcher.Match("\u0c09\u0c26\u0c3e\u0c39\u0c30\u0c23\u0c32\u0c41", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("\u0c08 \u0c2a\u0c30\u0c3f\u0c38\u0c4d\u0c25\u0c3f\u0c24\u0c3f\u0c32\u0c4b ")) {
                return new KeywordMatcher.StepMatch("\u0c08 \u0c2a\u0c30\u0c3f\u0c38\u0c4d\u0c25\u0c3f\u0c24\u0c3f\u0c32\u0c4b ", 14, StepKeywordType.ACTION);
            }
            if (line.startsWith("\u0c1a\u0c46\u0c2a\u0c4d\u0c2a\u0c2c\u0c21\u0c3f\u0c28\u0c26\u0c3f ")) {
                return new KeywordMatcher.StepMatch("\u0c1a\u0c46\u0c2a\u0c4d\u0c2a\u0c2c\u0c21\u0c3f\u0c28\u0c26\u0c3f ", 12, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u0c05\u0c2a\u0c4d\u0c2a\u0c41\u0c21\u0c41 ")) {
                return new KeywordMatcher.StepMatch("\u0c05\u0c2a\u0c4d\u0c2a\u0c41\u0c21\u0c41 ", 8, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("\u0c2e\u0c30\u0c3f\u0c2f\u0c41 ")) {
                return new KeywordMatcher.StepMatch("\u0c2e\u0c30\u0c3f\u0c2f\u0c41 ", 6, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u0c15\u0c3e\u0c28\u0c3f ")) {
                return new KeywordMatcher.StepMatch("\u0c15\u0c3e\u0c28\u0c3f ", 5, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class Th
    implements KeywordMatcher {
        private Th() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0e04\u0e27\u0e32\u0e21\u0e15\u0e49\u0e2d\u0e07\u0e01\u0e32\u0e23\u0e17\u0e32\u0e07\u0e18\u0e38\u0e23\u0e01\u0e34\u0e08")) {
                return new KeywordMatcher.Match("\u0e04\u0e27\u0e32\u0e21\u0e15\u0e49\u0e2d\u0e07\u0e01\u0e32\u0e23\u0e17\u0e32\u0e07\u0e18\u0e38\u0e23\u0e01\u0e34\u0e08", 21);
            }
            if (line.startsWithTitleKeyword("\u0e04\u0e27\u0e32\u0e21\u0e2a\u0e32\u0e21\u0e32\u0e23\u0e16")) {
                return new KeywordMatcher.Match("\u0e04\u0e27\u0e32\u0e21\u0e2a\u0e32\u0e21\u0e32\u0e23\u0e16", 11);
            }
            if (line.startsWithTitleKeyword("\u0e42\u0e04\u0e23\u0e07\u0e2b\u0e25\u0e31\u0e01")) {
                return new KeywordMatcher.Match("\u0e42\u0e04\u0e23\u0e07\u0e2b\u0e25\u0e31\u0e01", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0e41\u0e19\u0e27\u0e04\u0e34\u0e14")) {
                return new KeywordMatcher.Match("\u0e41\u0e19\u0e27\u0e04\u0e34\u0e14", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0e42\u0e04\u0e23\u0e07\u0e2a\u0e23\u0e49\u0e32\u0e07\u0e02\u0e2d\u0e07\u0e40\u0e2b\u0e15\u0e38\u0e01\u0e32\u0e23\u0e13\u0e4c")) {
                return new KeywordMatcher.Match("\u0e42\u0e04\u0e23\u0e07\u0e2a\u0e23\u0e49\u0e32\u0e07\u0e02\u0e2d\u0e07\u0e40\u0e2b\u0e15\u0e38\u0e01\u0e32\u0e23\u0e13\u0e4c", 22);
            }
            if (line.startsWithTitleKeyword("\u0e2a\u0e23\u0e38\u0e1b\u0e40\u0e2b\u0e15\u0e38\u0e01\u0e32\u0e23\u0e13\u0e4c")) {
                return new KeywordMatcher.Match("\u0e2a\u0e23\u0e38\u0e1b\u0e40\u0e2b\u0e15\u0e38\u0e01\u0e32\u0e23\u0e13\u0e4c", 14);
            }
            if (line.startsWithTitleKeyword("\u0e40\u0e2b\u0e15\u0e38\u0e01\u0e32\u0e23\u0e13\u0e4c")) {
                return new KeywordMatcher.Match("\u0e40\u0e2b\u0e15\u0e38\u0e01\u0e32\u0e23\u0e13\u0e4c", 10);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0e0a\u0e38\u0e14\u0e02\u0e2d\u0e07\u0e40\u0e2b\u0e15\u0e38\u0e01\u0e32\u0e23\u0e13\u0e4c")) {
                return new KeywordMatcher.Match("\u0e0a\u0e38\u0e14\u0e02\u0e2d\u0e07\u0e40\u0e2b\u0e15\u0e38\u0e01\u0e32\u0e23\u0e13\u0e4c", 16);
            }
            if (line.startsWithTitleKeyword("\u0e0a\u0e38\u0e14\u0e02\u0e2d\u0e07\u0e15\u0e31\u0e27\u0e2d\u0e22\u0e48\u0e32\u0e07")) {
                return new KeywordMatcher.Match("\u0e0a\u0e38\u0e14\u0e02\u0e2d\u0e07\u0e15\u0e31\u0e27\u0e2d\u0e22\u0e48\u0e32\u0e07", 15);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("\u0e01\u0e33\u0e2b\u0e19\u0e14\u0e43\u0e2b\u0e49 ")) {
                return new KeywordMatcher.StepMatch("\u0e01\u0e33\u0e2b\u0e19\u0e14\u0e43\u0e2b\u0e49 ", 9, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u0e14\u0e31\u0e07\u0e19\u0e31\u0e49\u0e19 ")) {
                return new KeywordMatcher.StepMatch("\u0e14\u0e31\u0e07\u0e19\u0e31\u0e49\u0e19 ", 8, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("\u0e40\u0e21\u0e37\u0e48\u0e2d ")) {
                return new KeywordMatcher.StepMatch("\u0e40\u0e21\u0e37\u0e48\u0e2d ", 6, StepKeywordType.ACTION);
            }
            if (line.startsWith("\u0e41\u0e25\u0e30 ")) {
                return new KeywordMatcher.StepMatch("\u0e41\u0e25\u0e30 ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u0e41\u0e15\u0e48 ")) {
                return new KeywordMatcher.StepMatch("\u0e41\u0e15\u0e48 ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class Tlh
    implements KeywordMatcher {
        private Tlh() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("poQbogh malja'")) {
                return new KeywordMatcher.Match("poQbogh malja'", 15);
            }
            if (line.startsWithTitleKeyword("Qu'meH 'ut")) {
                return new KeywordMatcher.Match("Qu'meH 'ut", 11);
            }
            if (line.startsWithTitleKeyword("perbogh")) {
                return new KeywordMatcher.Match("perbogh", 8);
            }
            if (line.startsWithTitleKeyword("Qap")) {
                return new KeywordMatcher.Match("Qap", 4);
            }
            if (line.startsWithTitleKeyword("laH")) {
                return new KeywordMatcher.Match("laH", 4);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("mo'")) {
                return new KeywordMatcher.Match("mo'", 4);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("lut chovnatlh")) {
                return new KeywordMatcher.Match("lut chovnatlh", 14);
            }
            if (line.startsWithTitleKeyword("lut")) {
                return new KeywordMatcher.Match("lut", 4);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("ghantoH")) {
                return new KeywordMatcher.Match("ghantoH", 8);
            }
            if (line.startsWithTitleKeyword("lutmey")) {
                return new KeywordMatcher.Match("lutmey", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("DaH ghu' bejlu' ")) {
                return new KeywordMatcher.StepMatch("DaH ghu' bejlu' ", 16, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("ghu' noblu' ")) {
                return new KeywordMatcher.StepMatch("ghu' noblu' ", 12, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("qaSDI' ")) {
                return new KeywordMatcher.StepMatch("qaSDI' ", 7, StepKeywordType.ACTION);
            }
            if (line.startsWith("latlh ")) {
                return new KeywordMatcher.StepMatch("latlh ", 6, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("'ach ")) {
                return new KeywordMatcher.StepMatch("'ach ", 5, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("'ej ")) {
                return new KeywordMatcher.StepMatch("'ej ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("vaj ")) {
                return new KeywordMatcher.StepMatch("vaj ", 4, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("'a ")) {
                return new KeywordMatcher.StepMatch("'a ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class Tr
    implements KeywordMatcher {
        private Tr() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u00d6zellik")) {
                return new KeywordMatcher.Match("\u00d6zellik", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Ge\u00e7mi\u015f")) {
                return new KeywordMatcher.Match("Ge\u00e7mi\u015f", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Kural")) {
                return new KeywordMatcher.Match("Kural", 6);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Senaryo tasla\u011f\u0131")) {
                return new KeywordMatcher.Match("Senaryo tasla\u011f\u0131", 16);
            }
            if (line.startsWithTitleKeyword("Senaryo")) {
                return new KeywordMatcher.Match("Senaryo", 8);
            }
            if (line.startsWithTitleKeyword("\u00d6rnek")) {
                return new KeywordMatcher.Match("\u00d6rnek", 6);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u00d6rnekler")) {
                return new KeywordMatcher.Match("\u00d6rnekler", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Diyelim ki ")) {
                return new KeywordMatcher.StepMatch("Diyelim ki ", 11, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("O zaman ")) {
                return new KeywordMatcher.StepMatch("O zaman ", 8, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("E\u011fer ki ")) {
                return new KeywordMatcher.StepMatch("E\u011fer ki ", 8, StepKeywordType.ACTION);
            }
            if (line.startsWith("Fakat ")) {
                return new KeywordMatcher.StepMatch("Fakat ", 6, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Ama ")) {
                return new KeywordMatcher.StepMatch("Ama ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Ve ")) {
                return new KeywordMatcher.StepMatch("Ve ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class Tt
    implements KeywordMatcher {
        private Tt() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u04ae\u0437\u0435\u043d\u0447\u04d9\u043b\u0435\u043a\u043b\u0435\u043b\u0435\u043a")) {
                return new KeywordMatcher.Match("\u04ae\u0437\u0435\u043d\u0447\u04d9\u043b\u0435\u043a\u043b\u0435\u043b\u0435\u043a", 15);
            }
            if (line.startsWithTitleKeyword("\u041c\u04e9\u043c\u043a\u0438\u043d\u043b\u0435\u043a")) {
                return new KeywordMatcher.Match("\u041c\u04e9\u043c\u043a\u0438\u043d\u043b\u0435\u043a", 10);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u041a\u0435\u0440\u0435\u0448")) {
                return new KeywordMatcher.Match("\u041a\u0435\u0440\u0435\u0448", 6);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0421\u0446\u0435\u043d\u0430\u0440\u0438\u0439\u043d\u044b\u04a3 \u0442\u04e9\u0437\u0435\u043b\u0435\u0448\u0435")) {
                return new KeywordMatcher.Match("\u0421\u0446\u0435\u043d\u0430\u0440\u0438\u0439\u043d\u044b\u04a3 \u0442\u04e9\u0437\u0435\u043b\u0435\u0448\u0435", 21);
            }
            if (line.startsWithTitleKeyword("\u0421\u0446\u0435\u043d\u0430\u0440\u0438\u0439")) {
                return new KeywordMatcher.Match("\u0421\u0446\u0435\u043d\u0430\u0440\u0438\u0439", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u041c\u0438\u0441\u0430\u043b\u043b\u0430\u0440")) {
                return new KeywordMatcher.Match("\u041c\u0438\u0441\u0430\u043b\u043b\u0430\u0440", 9);
            }
            if (line.startsWithTitleKeyword("\u04ae\u0440\u043d\u04d9\u043a\u043b\u04d9\u0440")) {
                return new KeywordMatcher.Match("\u04ae\u0440\u043d\u04d9\u043a\u043b\u04d9\u0440", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("\u041d\u04d9\u0442\u0438\u0497\u04d9\u0434\u04d9 ")) {
                return new KeywordMatcher.StepMatch("\u041d\u04d9\u0442\u0438\u0497\u04d9\u0434\u04d9 ", 9, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("\u04d8\u0439\u0442\u0438\u043a ")) {
                return new KeywordMatcher.StepMatch("\u04d8\u0439\u0442\u0438\u043a ", 6, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u041b\u04d9\u043a\u0438\u043d ")) {
                return new KeywordMatcher.StepMatch("\u041b\u04d9\u043a\u0438\u043d ", 6, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u04d8\u0433\u04d9\u0440 ")) {
                return new KeywordMatcher.StepMatch("\u04d8\u0433\u04d9\u0440 ", 5, StepKeywordType.ACTION);
            }
            if (line.startsWith("\u04d8\u043c\u043c\u0430 ")) {
                return new KeywordMatcher.StepMatch("\u04d8\u043c\u043c\u0430 ", 5, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u04ba\u04d9\u043c ")) {
                return new KeywordMatcher.StepMatch("\u04ba\u04d9\u043c ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u0412\u04d9 ")) {
                return new KeywordMatcher.StepMatch("\u0412\u04d9 ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class Uk
    implements KeywordMatcher {
        private Uk() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0424\u0443\u043d\u043a\u0446\u0456\u043e\u043d\u0430\u043b")) {
                return new KeywordMatcher.Match("\u0424\u0443\u043d\u043a\u0446\u0456\u043e\u043d\u0430\u043b", 11);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u041f\u0435\u0440\u0435\u0434\u0443\u043c\u043e\u0432\u0430")) {
                return new KeywordMatcher.Match("\u041f\u0435\u0440\u0435\u0434\u0443\u043c\u043e\u0432\u0430", 11);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0421\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430 \u0441\u0446\u0435\u043d\u0430\u0440\u0456\u044e")) {
                return new KeywordMatcher.Match("\u0421\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430 \u0441\u0446\u0435\u043d\u0430\u0440\u0456\u044e", 19);
            }
            if (line.startsWithTitleKeyword("\u0421\u0446\u0435\u043d\u0430\u0440\u0456\u0439")) {
                return new KeywordMatcher.Match("\u0421\u0446\u0435\u043d\u0430\u0440\u0456\u0439", 9);
            }
            if (line.startsWithTitleKeyword("\u041f\u0440\u0438\u043a\u043b\u0430\u0434")) {
                return new KeywordMatcher.Match("\u041f\u0440\u0438\u043a\u043b\u0430\u0434", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u041f\u0440\u0438\u043a\u043b\u0430\u0434\u0438")) {
                return new KeywordMatcher.Match("\u041f\u0440\u0438\u043a\u043b\u0430\u0434\u0438", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("\u041f\u0440\u0438\u043f\u0443\u0441\u0442\u0438\u043c\u043e, \u0449\u043e ")) {
                return new KeywordMatcher.StepMatch("\u041f\u0440\u0438\u043f\u0443\u0441\u0442\u0438\u043c\u043e, \u0449\u043e ", 15, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u041f\u0440\u0438\u043f\u0443\u0441\u0442\u0438\u043c\u043e ")) {
                return new KeywordMatcher.StepMatch("\u041f\u0440\u0438\u043f\u0443\u0441\u0442\u0438\u043c\u043e ", 11, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u0410 \u0442\u0430\u043a\u043e\u0436 ")) {
                return new KeywordMatcher.StepMatch("\u0410 \u0442\u0430\u043a\u043e\u0436 ", 8, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u041d\u0435\u0445\u0430\u0439 ")) {
                return new KeywordMatcher.StepMatch("\u041d\u0435\u0445\u0430\u0439 ", 6, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u0414\u0430\u043d\u043e ")) {
                return new KeywordMatcher.StepMatch("\u0414\u0430\u043d\u043e ", 5, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u042f\u043a\u0449\u043e ")) {
                return new KeywordMatcher.StepMatch("\u042f\u043a\u0449\u043e ", 5, StepKeywordType.ACTION);
            }
            if (line.startsWith("\u041a\u043e\u043b\u0438 ")) {
                return new KeywordMatcher.StepMatch("\u041a\u043e\u043b\u0438 ", 5, StepKeywordType.ACTION);
            }
            if (line.startsWith("\u0422\u043e\u0434\u0456 ")) {
                return new KeywordMatcher.StepMatch("\u0422\u043e\u0434\u0456 ", 5, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("\u0410\u043b\u0435 ")) {
                return new KeywordMatcher.StepMatch("\u0410\u043b\u0435 ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u0422\u0430 ")) {
                return new KeywordMatcher.StepMatch("\u0422\u0430 ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u0422\u043e ")) {
                return new KeywordMatcher.StepMatch("\u0422\u043e ", 3, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            if (line.startsWith("\u0406 ")) {
                return new KeywordMatcher.StepMatch("\u0406 ", 2, StepKeywordType.CONJUNCTION);
            }
            return null;
        }
    }

    private static final class Ur
    implements KeywordMatcher {
        private Ur() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u06a9\u0627\u0631\u0648\u0628\u0627\u0631 \u06a9\u06cc \u0636\u0631\u0648\u0631\u062a")) {
                return new KeywordMatcher.Match("\u06a9\u0627\u0631\u0648\u0628\u0627\u0631 \u06a9\u06cc \u0636\u0631\u0648\u0631\u062a", 17);
            }
            if (line.startsWithTitleKeyword("\u0635\u0644\u0627\u062d\u06cc\u062a")) {
                return new KeywordMatcher.Match("\u0635\u0644\u0627\u062d\u06cc\u062a", 7);
            }
            if (line.startsWithTitleKeyword("\u062e\u0635\u0648\u0635\u06cc\u062a")) {
                return new KeywordMatcher.Match("\u062e\u0635\u0648\u0635\u06cc\u062a", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u067e\u0633 \u0645\u0646\u0638\u0631")) {
                return new KeywordMatcher.Match("\u067e\u0633 \u0645\u0646\u0638\u0631", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0645\u0646\u0638\u0631 \u0646\u0627\u0645\u06d2 \u06a9\u0627 \u062e\u0627\u06a9\u06c1")) {
                return new KeywordMatcher.Match("\u0645\u0646\u0638\u0631 \u0646\u0627\u0645\u06d2 \u06a9\u0627 \u062e\u0627\u06a9\u06c1", 18);
            }
            if (line.startsWithTitleKeyword("\u0645\u0646\u0638\u0631\u0646\u0627\u0645\u06c1")) {
                return new KeywordMatcher.Match("\u0645\u0646\u0638\u0631\u0646\u0627\u0645\u06c1", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0645\u062b\u0627\u0644\u06cc\u06ba")) {
                return new KeywordMatcher.Match("\u0645\u062b\u0627\u0644\u06cc\u06ba", 7);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("\u0641\u0631\u0636 \u06a9\u06cc\u0627 ")) {
                return new KeywordMatcher.StepMatch("\u0641\u0631\u0636 \u06a9\u06cc\u0627 ", 8, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u0628\u0627\u0644\u0641\u0631\u0636 ")) {
                return new KeywordMatcher.StepMatch("\u0628\u0627\u0644\u0641\u0631\u0636 ", 7, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u0644\u06cc\u06a9\u0646 ")) {
                return new KeywordMatcher.StepMatch("\u0644\u06cc\u06a9\u0646 ", 5, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u067e\u06be\u0631 ")) {
                return new KeywordMatcher.StepMatch("\u067e\u06be\u0631 ", 4, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("\u0627\u06af\u0631 ")) {
                return new KeywordMatcher.StepMatch("\u0627\u06af\u0631 ", 4, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u0627\u0648\u0631 ")) {
                return new KeywordMatcher.StepMatch("\u0627\u0648\u0631 ", 4, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u062c\u0628 ")) {
                return new KeywordMatcher.StepMatch("\u062c\u0628 ", 3, StepKeywordType.ACTION);
            }
            if (line.startsWith("\u062a\u0628 ")) {
                return new KeywordMatcher.StepMatch("\u062a\u0628 ", 3, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class Uz
    implements KeywordMatcher {
        private Uz() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0424\u0443\u043d\u043a\u0446\u0438\u043e\u043d\u0430\u043b")) {
                return new KeywordMatcher.Match("\u0424\u0443\u043d\u043a\u0446\u0438\u043e\u043d\u0430\u043b", 11);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0422\u0430\u0440\u0438\u0445")) {
                return new KeywordMatcher.Match("\u0422\u0430\u0440\u0438\u0445", 6);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u0421\u0446\u0435\u043d\u0430\u0440\u0438\u0439 \u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430\u0441\u0438")) {
                return new KeywordMatcher.Match("\u0421\u0446\u0435\u043d\u0430\u0440\u0438\u0439 \u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430\u0441\u0438", 21);
            }
            if (line.startsWithTitleKeyword("\u0421\u0446\u0435\u043d\u0430\u0440\u0438\u0439")) {
                return new KeywordMatcher.Match("\u0421\u0446\u0435\u043d\u0430\u0440\u0438\u0439", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u041c\u0438\u0441\u043e\u043b\u043b\u0430\u0440")) {
                return new KeywordMatcher.Match("\u041c\u0438\u0441\u043e\u043b\u043b\u0430\u0440", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Belgilangan ")) {
                return new KeywordMatcher.StepMatch("Belgilangan ", 12, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u041b\u0435\u043a\u0438\u043d ")) {
                return new KeywordMatcher.StepMatch("\u041b\u0435\u043a\u0438\u043d ", 6, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u0411\u0438\u0440\u043e\u043a ")) {
                return new KeywordMatcher.StepMatch("\u0411\u0438\u0440\u043e\u043a ", 6, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u0423\u043d\u0434\u0430 ")) {
                return new KeywordMatcher.StepMatch("\u0423\u043d\u0434\u0430 ", 5, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("\u0410\u043c\u043c\u043e ")) {
                return new KeywordMatcher.StepMatch("\u0410\u043c\u043c\u043e ", 5, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u0410\u0433\u0430\u0440 ")) {
                return new KeywordMatcher.StepMatch("\u0410\u0433\u0430\u0440 ", 5, StepKeywordType.ACTION);
            }
            if (line.startsWith("\u0412\u0430 ")) {
                return new KeywordMatcher.StepMatch("\u0412\u0430 ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class Vi
    implements KeywordMatcher {
        private Vi() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("T\u00ednh n\u0103ng")) {
                return new KeywordMatcher.Match("T\u00ednh n\u0103ng", 10);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("B\u1ed1i c\u1ea3nh")) {
                return new KeywordMatcher.Match("B\u1ed1i c\u1ea3nh", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Quy t\u1eafc")) {
                return new KeywordMatcher.Match("Quy t\u1eafc", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Khung t\u00ecnh hu\u1ed1ng")) {
                return new KeywordMatcher.Match("Khung t\u00ecnh hu\u1ed1ng", 17);
            }
            if (line.startsWithTitleKeyword("Khung k\u1ecbch b\u1ea3n")) {
                return new KeywordMatcher.Match("Khung k\u1ecbch b\u1ea3n", 15);
            }
            if (line.startsWithTitleKeyword("T\u00ecnh hu\u1ed1ng")) {
                return new KeywordMatcher.Match("T\u00ecnh hu\u1ed1ng", 11);
            }
            if (line.startsWithTitleKeyword("K\u1ecbch b\u1ea3n")) {
                return new KeywordMatcher.Match("K\u1ecbch b\u1ea3n", 9);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("D\u1eef li\u1ec7u")) {
                return new KeywordMatcher.Match("D\u1eef li\u1ec7u", 8);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Nh\u01b0ng ")) {
                return new KeywordMatcher.StepMatch("Nh\u01b0ng ", 6, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("Bi\u1ebft ")) {
                return new KeywordMatcher.StepMatch("Bi\u1ebft ", 5, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Th\u00ec ")) {
                return new KeywordMatcher.StepMatch("Th\u00ec ", 4, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("Cho ")) {
                return new KeywordMatcher.StepMatch("Cho ", 4, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("Khi ")) {
                return new KeywordMatcher.StepMatch("Khi ", 4, StepKeywordType.ACTION);
            }
            if (line.startsWith("V\u00e0 ")) {
                return new KeywordMatcher.StepMatch("V\u00e0 ", 3, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            return null;
        }
    }

    private static final class Zh_cn
    implements KeywordMatcher {
        private Zh_cn() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u529f\u80fd")) {
                return new KeywordMatcher.Match("\u529f\u80fd", 3);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u80cc\u666f")) {
                return new KeywordMatcher.Match("\u80cc\u666f", 3);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            if (line.startsWithTitleKeyword("\u89c4\u5219")) {
                return new KeywordMatcher.Match("\u89c4\u5219", 3);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u573a\u666f\u5927\u7eb2")) {
                return new KeywordMatcher.Match("\u573a\u666f\u5927\u7eb2", 5);
            }
            if (line.startsWithTitleKeyword("\u5267\u672c\u5927\u7eb2")) {
                return new KeywordMatcher.Match("\u5267\u672c\u5927\u7eb2", 5);
            }
            if (line.startsWithTitleKeyword("\u5267\u672c")) {
                return new KeywordMatcher.Match("\u5267\u672c", 3);
            }
            if (line.startsWithTitleKeyword("\u573a\u666f")) {
                return new KeywordMatcher.Match("\u573a\u666f", 3);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u4f8b\u5b50")) {
                return new KeywordMatcher.Match("\u4f8b\u5b50", 3);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("\u540c\u65f6")) {
                return new KeywordMatcher.StepMatch("\u540c\u65f6", 2, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u4f46\u662f")) {
                return new KeywordMatcher.StepMatch("\u4f46\u662f", 2, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u800c\u4e14")) {
                return new KeywordMatcher.StepMatch("\u800c\u4e14", 2, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u5047\u5982")) {
                return new KeywordMatcher.StepMatch("\u5047\u5982", 2, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u90a3\u4e48")) {
                return new KeywordMatcher.StepMatch("\u90a3\u4e48", 2, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("\u5e76\u4e14")) {
                return new KeywordMatcher.StepMatch("\u5e76\u4e14", 2, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            if (line.startsWith("\u5047\u5b9a")) {
                return new KeywordMatcher.StepMatch("\u5047\u5b9a", 2, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u5047\u8bbe")) {
                return new KeywordMatcher.StepMatch("\u5047\u8bbe", 2, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u5f53")) {
                return new KeywordMatcher.StepMatch("\u5f53", 1, StepKeywordType.ACTION);
            }
            return null;
        }
    }

    private static final class Zh_tw
    implements KeywordMatcher {
        private Zh_tw() {
        }

        @Override
        public KeywordMatcher.Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u529f\u80fd")) {
                return new KeywordMatcher.Match("\u529f\u80fd", 3);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u80cc\u666f")) {
                return new KeywordMatcher.Match("\u80cc\u666f", 3);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new KeywordMatcher.Match("Rule", 5);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u5834\u666f\u5927\u7db1")) {
                return new KeywordMatcher.Match("\u5834\u666f\u5927\u7db1", 5);
            }
            if (line.startsWithTitleKeyword("\u5287\u672c\u5927\u7db1")) {
                return new KeywordMatcher.Match("\u5287\u672c\u5927\u7db1", 5);
            }
            if (line.startsWithTitleKeyword("\u5287\u672c")) {
                return new KeywordMatcher.Match("\u5287\u672c", 3);
            }
            if (line.startsWithTitleKeyword("\u5834\u666f")) {
                return new KeywordMatcher.Match("\u5834\u666f", 3);
            }
            return null;
        }

        @Override
        public KeywordMatcher.Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("\u4f8b\u5b50")) {
                return new KeywordMatcher.Match("\u4f8b\u5b50", 3);
            }
            return null;
        }

        @Override
        public KeywordMatcher.StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("\u4f46\u662f")) {
                return new KeywordMatcher.StepMatch("\u4f46\u662f", 2, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u800c\u4e14")) {
                return new KeywordMatcher.StepMatch("\u800c\u4e14", 2, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u4e26\u4e14")) {
                return new KeywordMatcher.StepMatch("\u4e26\u4e14", 2, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u90a3\u9ebc")) {
                return new KeywordMatcher.StepMatch("\u90a3\u9ebc", 2, StepKeywordType.OUTCOME);
            }
            if (line.startsWith("\u5047\u8a2d")) {
                return new KeywordMatcher.StepMatch("\u5047\u8a2d", 2, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u5047\u5982")) {
                return new KeywordMatcher.StepMatch("\u5047\u5982", 2, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("* ")) {
                return new KeywordMatcher.StepMatch("* ", 2, StepKeywordType.UNKNOWN);
            }
            if (line.startsWith("\u5047\u5b9a")) {
                return new KeywordMatcher.StepMatch("\u5047\u5b9a", 2, StepKeywordType.CONTEXT);
            }
            if (line.startsWith("\u540c\u6642")) {
                return new KeywordMatcher.StepMatch("\u540c\u6642", 2, StepKeywordType.CONJUNCTION);
            }
            if (line.startsWith("\u7576")) {
                return new KeywordMatcher.StepMatch("\u7576", 1, StepKeywordType.ACTION);
            }
            return null;
        }
    }
}

