/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages;

import io.cucumber.messages.Messages;
import io.cucumber.messages.internal.com.google.protobuf.Message;
import io.cucumber.messages.internal.com.google.protobuf.util.JsonFormat;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;

public class NdjsonToMessageIterable
implements Iterable<Messages.Envelope> {
    public static final JsonFormat.Parser JSON_PARSER = JsonFormat.parser().ignoringUnknownFields();
    private final BufferedReader input;
    private Messages.Envelope next;

    public NdjsonToMessageIterable(InputStream input) {
        this.input = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
    }

    @Override
    public Iterator<Messages.Envelope> iterator() {
        return new Iterator<Messages.Envelope>(){

            @Override
            public boolean hasNext() {
                try {
                    String line = NdjsonToMessageIterable.this.input.readLine();
                    if (line == null) {
                        return false;
                    }
                    Messages.Envelope.Builder builder = Messages.Envelope.newBuilder();
                    JSON_PARSER.merge(line, (Message.Builder)builder);
                    NdjsonToMessageIterable.this.next = builder.build();
                    return true;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public Messages.Envelope next() {
                if (NdjsonToMessageIterable.this.next == null) {
                    throw new IllegalStateException("next() should only be called after a call to hasNext() that returns true");
                }
                return NdjsonToMessageIterable.this.next;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

