
package io.cucumber.messages.types;



/**
 * CI environment
 * 
 */
public class Ci {

    /**
     * Name of the CI product, e.g. "Jenkins", "CircleCI" etc.
     * (Required)
     * 
     */
    private String name;
    /**
     * Link to the build
     * 
     */
    private String url;
    /**
     * The build number. Some CI servers use non-numeric build numbers, which is why this is a string
     * 
     */
    private String buildNumber;
    /**
     * Information about Git, provided by the Build/CI server as environment
     *  variables.
     * 
     */
    private Git git;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Ci() {
    }

    /**
     * 
     * @param git
     * @param name
     * @param buildNumber
     * @param url
     */
    public Ci(String name, String url, String buildNumber, Git git) {
        super();
        this.name = name;
        this.url = url;
        this.buildNumber = buildNumber;
        this.git = git;
    }

    /**
     * Name of the CI product, e.g. "Jenkins", "CircleCI" etc.
     * (Required)
     * 
     */
    public String getName() {
        return name;
    }

    /**
     * Name of the CI product, e.g. "Jenkins", "CircleCI" etc.
     * (Required)
     * 
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Link to the build
     * 
     */
    public String getUrl() {
        return url;
    }

    /**
     * Link to the build
     * 
     */
    public void setUrl(String url) {
        this.url = url;
    }

    /**
     * The build number. Some CI servers use non-numeric build numbers, which is why this is a string
     * 
     */
    public String getBuildNumber() {
        return buildNumber;
    }

    /**
     * The build number. Some CI servers use non-numeric build numbers, which is why this is a string
     * 
     */
    public void setBuildNumber(String buildNumber) {
        this.buildNumber = buildNumber;
    }

    /**
     * Information about Git, provided by the Build/CI server as environment
     *  variables.
     * 
     */
    public Git getGit() {
        return git;
    }

    /**
     * Information about Git, provided by the Build/CI server as environment
     *  variables.
     * 
     */
    public void setGit(Git git) {
        this.git = git;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Ci.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("url");
        sb.append('=');
        sb.append(((this.url == null)?"<null>":this.url));
        sb.append(',');
        sb.append("buildNumber");
        sb.append('=');
        sb.append(((this.buildNumber == null)?"<null>":this.buildNumber));
        sb.append(',');
        sb.append("git");
        sb.append('=');
        sb.append(((this.git == null)?"<null>":this.git));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.git == null)? 0 :this.git.hashCode()));
        result = ((result* 31)+((this.buildNumber == null)? 0 :this.buildNumber.hashCode()));
        result = ((result* 31)+((this.url == null)? 0 :this.url.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Ci) == false) {
            return false;
        }
        Ci rhs = ((Ci) other);
        return (((((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name)))&&((this.git == rhs.git)||((this.git!= null)&&this.git.equals(rhs.git))))&&((this.buildNumber == rhs.buildNumber)||((this.buildNumber!= null)&&this.buildNumber.equals(rhs.buildNumber))))&&((this.url == rhs.url)||((this.url!= null)&&this.url.equals(rhs.url))));
    }

}
