
package io.cucumber.messages.types;



/**
 * *
 *  This message contains meta information about the environment. Consumers can use
 *  this for various purposes.
 * 
 */
public class Meta {

    /**
     * *
     *  The [SEMVER](https://semver.org/) version number of the protocol
     * (Required)
     * 
     */
    private String protocolVersion;
    /**
     * Used to describe various properties of Meta
     * (Required)
     * 
     */
    private Product implementation;
    /**
     * Used to describe various properties of Meta
     * (Required)
     * 
     */
    private Product runtime;
    /**
     * Used to describe various properties of Meta
     * (Required)
     * 
     */
    private Product os;
    /**
     * Used to describe various properties of Meta
     * (Required)
     * 
     */
    private Product cpu;
    /**
     * CI environment
     * 
     */
    private Ci ci;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Meta() {
    }

    /**
     * 
     * @param os
     * @param ci
     * @param implementation
     * @param runtime
     * @param cpu
     * @param protocolVersion
     */
    public Meta(String protocolVersion, Product implementation, Product runtime, Product os, Product cpu, Ci ci) {
        super();
        this.protocolVersion = protocolVersion;
        this.implementation = implementation;
        this.runtime = runtime;
        this.os = os;
        this.cpu = cpu;
        this.ci = ci;
    }

    /**
     * *
     *  The [SEMVER](https://semver.org/) version number of the protocol
     * (Required)
     * 
     */
    public String getProtocolVersion() {
        return protocolVersion;
    }

    /**
     * *
     *  The [SEMVER](https://semver.org/) version number of the protocol
     * (Required)
     * 
     */
    public void setProtocolVersion(String protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    /**
     * Used to describe various properties of Meta
     * (Required)
     * 
     */
    public Product getImplementation() {
        return implementation;
    }

    /**
     * Used to describe various properties of Meta
     * (Required)
     * 
     */
    public void setImplementation(Product implementation) {
        this.implementation = implementation;
    }

    /**
     * Used to describe various properties of Meta
     * (Required)
     * 
     */
    public Product getRuntime() {
        return runtime;
    }

    /**
     * Used to describe various properties of Meta
     * (Required)
     * 
     */
    public void setRuntime(Product runtime) {
        this.runtime = runtime;
    }

    /**
     * Used to describe various properties of Meta
     * (Required)
     * 
     */
    public Product getOs() {
        return os;
    }

    /**
     * Used to describe various properties of Meta
     * (Required)
     * 
     */
    public void setOs(Product os) {
        this.os = os;
    }

    /**
     * Used to describe various properties of Meta
     * (Required)
     * 
     */
    public Product getCpu() {
        return cpu;
    }

    /**
     * Used to describe various properties of Meta
     * (Required)
     * 
     */
    public void setCpu(Product cpu) {
        this.cpu = cpu;
    }

    /**
     * CI environment
     * 
     */
    public Ci getCi() {
        return ci;
    }

    /**
     * CI environment
     * 
     */
    public void setCi(Ci ci) {
        this.ci = ci;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Meta.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("protocolVersion");
        sb.append('=');
        sb.append(((this.protocolVersion == null)?"<null>":this.protocolVersion));
        sb.append(',');
        sb.append("implementation");
        sb.append('=');
        sb.append(((this.implementation == null)?"<null>":this.implementation));
        sb.append(',');
        sb.append("runtime");
        sb.append('=');
        sb.append(((this.runtime == null)?"<null>":this.runtime));
        sb.append(',');
        sb.append("os");
        sb.append('=');
        sb.append(((this.os == null)?"<null>":this.os));
        sb.append(',');
        sb.append("cpu");
        sb.append('=');
        sb.append(((this.cpu == null)?"<null>":this.cpu));
        sb.append(',');
        sb.append("ci");
        sb.append('=');
        sb.append(((this.ci == null)?"<null>":this.ci));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.os == null)? 0 :this.os.hashCode()));
        result = ((result* 31)+((this.ci == null)? 0 :this.ci.hashCode()));
        result = ((result* 31)+((this.implementation == null)? 0 :this.implementation.hashCode()));
        result = ((result* 31)+((this.runtime == null)? 0 :this.runtime.hashCode()));
        result = ((result* 31)+((this.cpu == null)? 0 :this.cpu.hashCode()));
        result = ((result* 31)+((this.protocolVersion == null)? 0 :this.protocolVersion.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Meta) == false) {
            return false;
        }
        Meta rhs = ((Meta) other);
        return (((((((this.os == rhs.os)||((this.os!= null)&&this.os.equals(rhs.os)))&&((this.ci == rhs.ci)||((this.ci!= null)&&this.ci.equals(rhs.ci))))&&((this.implementation == rhs.implementation)||((this.implementation!= null)&&this.implementation.equals(rhs.implementation))))&&((this.runtime == rhs.runtime)||((this.runtime!= null)&&this.runtime.equals(rhs.runtime))))&&((this.cpu == rhs.cpu)||((this.cpu!= null)&&this.cpu.equals(rhs.cpu))))&&((this.protocolVersion == rhs.protocolVersion)||((this.protocolVersion!= null)&&this.protocolVersion.equals(rhs.protocolVersion))));
    }

}
