
package io.cucumber.messages.types;



/**
 * An optional argument
 * 
 */
public class PickleStepArgument {

    private PickleDocString docString;
    private PickleTable dataTable;

    /**
     * No args constructor for use in serialization
     * 
     */
    public PickleStepArgument() {
    }

    /**
     * 
     * @param dataTable
     * @param docString
     */
    public PickleStepArgument(PickleDocString docString, PickleTable dataTable) {
        super();
        this.docString = docString;
        this.dataTable = dataTable;
    }

    public PickleDocString getDocString() {
        return docString;
    }

    public void setDocString(PickleDocString docString) {
        this.docString = docString;
    }

    public PickleTable getDataTable() {
        return dataTable;
    }

    public void setDataTable(PickleTable dataTable) {
        this.dataTable = dataTable;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(PickleStepArgument.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("docString");
        sb.append('=');
        sb.append(((this.docString == null)?"<null>":this.docString));
        sb.append(',');
        sb.append("dataTable");
        sb.append('=');
        sb.append(((this.dataTable == null)?"<null>":this.dataTable));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.docString == null)? 0 :this.docString.hashCode()));
        result = ((result* 31)+((this.dataTable == null)? 0 :this.dataTable.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof PickleStepArgument) == false) {
            return false;
        }
        PickleStepArgument rhs = ((PickleStepArgument) other);
        return (((this.docString == rhs.docString)||((this.docString!= null)&&this.docString.equals(rhs.docString)))&&((this.dataTable == rhs.dataTable)||((this.dataTable!= null)&&this.dataTable.equals(rhs.dataTable))));
    }

}
