
package io.cucumber.messages.types;



/**
 * *
 *  Points to a [Source](#io.cucumber.messages.Source) identified by `uri` and a
 *  [Location](#io.cucumber.messages.Location) within that file.
 * 
 */
public class SourceReference {

    private String uri;
    private JavaMethod javaMethod;
    private JavaStackTraceElement javaStackTraceElement;
    /**
     * *
     *  Points to a line and a column in a text file
     * 
     */
    private Location location;

    /**
     * No args constructor for use in serialization
     * 
     */
    public SourceReference() {
    }

    /**
     * 
     * @param javaStackTraceElement
     * @param location
     * @param javaMethod
     * @param uri
     */
    public SourceReference(String uri, JavaMethod javaMethod, JavaStackTraceElement javaStackTraceElement, Location location) {
        super();
        this.uri = uri;
        this.javaMethod = javaMethod;
        this.javaStackTraceElement = javaStackTraceElement;
        this.location = location;
    }

    public String getUri() {
        return uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public JavaMethod getJavaMethod() {
        return javaMethod;
    }

    public void setJavaMethod(JavaMethod javaMethod) {
        this.javaMethod = javaMethod;
    }

    public JavaStackTraceElement getJavaStackTraceElement() {
        return javaStackTraceElement;
    }

    public void setJavaStackTraceElement(JavaStackTraceElement javaStackTraceElement) {
        this.javaStackTraceElement = javaStackTraceElement;
    }

    /**
     * *
     *  Points to a line and a column in a text file
     * 
     */
    public Location getLocation() {
        return location;
    }

    /**
     * *
     *  Points to a line and a column in a text file
     * 
     */
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SourceReference.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("uri");
        sb.append('=');
        sb.append(((this.uri == null)?"<null>":this.uri));
        sb.append(',');
        sb.append("javaMethod");
        sb.append('=');
        sb.append(((this.javaMethod == null)?"<null>":this.javaMethod));
        sb.append(',');
        sb.append("javaStackTraceElement");
        sb.append('=');
        sb.append(((this.javaStackTraceElement == null)?"<null>":this.javaStackTraceElement));
        sb.append(',');
        sb.append("location");
        sb.append('=');
        sb.append(((this.location == null)?"<null>":this.location));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.location == null)? 0 :this.location.hashCode()));
        result = ((result* 31)+((this.javaMethod == null)? 0 :this.javaMethod.hashCode()));
        result = ((result* 31)+((this.javaStackTraceElement == null)? 0 :this.javaStackTraceElement.hashCode()));
        result = ((result* 31)+((this.uri == null)? 0 :this.uri.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof SourceReference) == false) {
            return false;
        }
        SourceReference rhs = ((SourceReference) other);
        return (((((this.location == rhs.location)||((this.location!= null)&&this.location.equals(rhs.location)))&&((this.javaMethod == rhs.javaMethod)||((this.javaMethod!= null)&&this.javaMethod.equals(rhs.javaMethod))))&&((this.javaStackTraceElement == rhs.javaStackTraceElement)||((this.javaStackTraceElement!= null)&&this.javaStackTraceElement.equals(rhs.javaStackTraceElement))))&&((this.uri == rhs.uri)||((this.uri!= null)&&this.uri.equals(rhs.uri))));
    }

}
