
package io.cucumber.messages.types;

import java.util.HashMap;
import java.util.Map;

public class StepDefinitionPattern {

    /**
     * 
     * (Required)
     * 
     */
    private String source;
    /**
     * 
     * (Required)
     * 
     */
    private StepDefinitionPattern.Type type;

    /**
     * No args constructor for use in serialization
     * 
     */
    public StepDefinitionPattern() {
    }

    /**
     * 
     * @param source
     * @param type
     */
    public StepDefinitionPattern(String source, StepDefinitionPattern.Type type) {
        super();
        this.source = source;
        this.type = type;
    }

    /**
     * 
     * (Required)
     * 
     */
    public String getSource() {
        return source;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setSource(String source) {
        this.source = source;
    }

    /**
     * 
     * (Required)
     * 
     */
    public StepDefinitionPattern.Type getType() {
        return type;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setType(StepDefinitionPattern.Type type) {
        this.type = type;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(StepDefinitionPattern.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("source");
        sb.append('=');
        sb.append(((this.source == null)?"<null>":this.source));
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(((this.type == null)?"<null>":this.type));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.type == null)? 0 :this.type.hashCode()));
        result = ((result* 31)+((this.source == null)? 0 :this.source.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof StepDefinitionPattern) == false) {
            return false;
        }
        StepDefinitionPattern rhs = ((StepDefinitionPattern) other);
        return (((this.type == rhs.type)||((this.type!= null)&&this.type.equals(rhs.type)))&&((this.source == rhs.source)||((this.source!= null)&&this.source.equals(rhs.source))));
    }

    public enum Type {

        CUCUMBER_EXPRESSION("CUCUMBER_EXPRESSION"),
        REGULAR_EXPRESSION("REGULAR_EXPRESSION");
        private final String value;
        private final static Map<String, StepDefinitionPattern.Type> CONSTANTS = new HashMap<String, StepDefinitionPattern.Type>();

        static {
            for (StepDefinitionPattern.Type c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        Type(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static StepDefinitionPattern.Type fromValue(String value) {
            StepDefinitionPattern.Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
