
package io.cucumber.messages.types;

import java.util.ArrayList;
import java.util.List;


/**
 * *
 *  A `TestStep` is derived from either a `PickleStep`
 *  combined with a `StepDefinition`, or from a `Hook`.
 * 
 */
public class TestStep {

    /**
     * Pointer to the `Hook` (if derived from a Hook)
     * 
     */
    private String hookId;
    /**
     * 
     * (Required)
     * 
     */
    private String id;
    /**
     * Pointer to the `PickleStep` (if derived from a `PickleStep`)
     * 
     */
    private String pickleStepId;
    /**
     * Pointer to all the matching `StepDefinition`s (if derived from a `PickleStep`)
     * 
     */
    private List<String> stepDefinitionIds = new ArrayList<String>();
    /**
     * A list of list of StepMatchArgument (if derived from a `PickleStep`).
     *  Each element represents a matching step definition. A size of 0 means `UNDEFINED`,
     *  and a size of 2+ means `AMBIGUOUS`
     * 
     */
    private List<StepMatchArgumentsList> stepMatchArgumentsLists = new ArrayList<StepMatchArgumentsList>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public TestStep() {
    }

    /**
     * 
     * @param hookId
     * @param stepMatchArgumentsLists
     * @param id
     * @param stepDefinitionIds
     * @param pickleStepId
     */
    public TestStep(String hookId, String id, String pickleStepId, List<String> stepDefinitionIds, List<StepMatchArgumentsList> stepMatchArgumentsLists) {
        super();
        this.hookId = hookId;
        this.id = id;
        this.pickleStepId = pickleStepId;
        this.stepDefinitionIds = stepDefinitionIds;
        this.stepMatchArgumentsLists = stepMatchArgumentsLists;
    }

    /**
     * Pointer to the `Hook` (if derived from a Hook)
     * 
     */
    public String getHookId() {
        return hookId;
    }

    /**
     * Pointer to the `Hook` (if derived from a Hook)
     * 
     */
    public void setHookId(String hookId) {
        this.hookId = hookId;
    }

    /**
     * 
     * (Required)
     * 
     */
    public String getId() {
        return id;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * Pointer to the `PickleStep` (if derived from a `PickleStep`)
     * 
     */
    public String getPickleStepId() {
        return pickleStepId;
    }

    /**
     * Pointer to the `PickleStep` (if derived from a `PickleStep`)
     * 
     */
    public void setPickleStepId(String pickleStepId) {
        this.pickleStepId = pickleStepId;
    }

    /**
     * Pointer to all the matching `StepDefinition`s (if derived from a `PickleStep`)
     * 
     */
    public List<String> getStepDefinitionIds() {
        return stepDefinitionIds;
    }

    /**
     * Pointer to all the matching `StepDefinition`s (if derived from a `PickleStep`)
     * 
     */
    public void setStepDefinitionIds(List<String> stepDefinitionIds) {
        this.stepDefinitionIds = stepDefinitionIds;
    }

    /**
     * A list of list of StepMatchArgument (if derived from a `PickleStep`).
     *  Each element represents a matching step definition. A size of 0 means `UNDEFINED`,
     *  and a size of 2+ means `AMBIGUOUS`
     * 
     */
    public List<StepMatchArgumentsList> getStepMatchArgumentsLists() {
        return stepMatchArgumentsLists;
    }

    /**
     * A list of list of StepMatchArgument (if derived from a `PickleStep`).
     *  Each element represents a matching step definition. A size of 0 means `UNDEFINED`,
     *  and a size of 2+ means `AMBIGUOUS`
     * 
     */
    public void setStepMatchArgumentsLists(List<StepMatchArgumentsList> stepMatchArgumentsLists) {
        this.stepMatchArgumentsLists = stepMatchArgumentsLists;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TestStep.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("hookId");
        sb.append('=');
        sb.append(((this.hookId == null)?"<null>":this.hookId));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("pickleStepId");
        sb.append('=');
        sb.append(((this.pickleStepId == null)?"<null>":this.pickleStepId));
        sb.append(',');
        sb.append("stepDefinitionIds");
        sb.append('=');
        sb.append(((this.stepDefinitionIds == null)?"<null>":this.stepDefinitionIds));
        sb.append(',');
        sb.append("stepMatchArgumentsLists");
        sb.append('=');
        sb.append(((this.stepMatchArgumentsLists == null)?"<null>":this.stepMatchArgumentsLists));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.stepMatchArgumentsLists == null)? 0 :this.stepMatchArgumentsLists.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.stepDefinitionIds == null)? 0 :this.stepDefinitionIds.hashCode()));
        result = ((result* 31)+((this.hookId == null)? 0 :this.hookId.hashCode()));
        result = ((result* 31)+((this.pickleStepId == null)? 0 :this.pickleStepId.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TestStep) == false) {
            return false;
        }
        TestStep rhs = ((TestStep) other);
        return ((((((this.stepMatchArgumentsLists == rhs.stepMatchArgumentsLists)||((this.stepMatchArgumentsLists!= null)&&this.stepMatchArgumentsLists.equals(rhs.stepMatchArgumentsLists)))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.stepDefinitionIds == rhs.stepDefinitionIds)||((this.stepDefinitionIds!= null)&&this.stepDefinitionIds.equals(rhs.stepDefinitionIds))))&&((this.hookId == rhs.hookId)||((this.hookId!= null)&&this.hookId.equals(rhs.hookId))))&&((this.pickleStepId == rhs.pickleStepId)||((this.pickleStepId!= null)&&this.pickleStepId.equals(rhs.pickleStepId))));
    }

}
