
package io.cucumber.messages.types;


public class UndefinedParameterType {

    /**
     * 
     * (Required)
     * 
     */
    private String expression;
    /**
     * 
     * (Required)
     * 
     */
    private String name;

    /**
     * No args constructor for use in serialization
     * 
     */
    public UndefinedParameterType() {
    }

    /**
     * 
     * @param expression
     * @param name
     */
    public UndefinedParameterType(String expression, String name) {
        super();
        this.expression = expression;
        this.name = name;
    }

    /**
     * 
     * (Required)
     * 
     */
    public String getExpression() {
        return expression;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setExpression(String expression) {
        this.expression = expression;
    }

    /**
     * 
     * (Required)
     * 
     */
    public String getName() {
        return name;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(UndefinedParameterType.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("expression");
        sb.append('=');
        sb.append(((this.expression == null)?"<null>":this.expression));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.expression == null)? 0 :this.expression.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof UndefinedParameterType) == false) {
            return false;
        }
        UndefinedParameterType rhs = ((UndefinedParameterType) other);
        return (((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name)))&&((this.expression == rhs.expression)||((this.expression!= null)&&this.expression.equals(rhs.expression))));
    }

}
