
package io.cucumber.messages.types;

import java.util.ArrayList;
import java.util.List;

public class Feature {

    /**
     * *
     *  Points to a line and a column in a text file
     * (Required)
     * 
     */
    private Location location;
    /**
     * All the tags placed above the `Feature` keyword
     * (Required)
     * 
     */
    private List<Tag> tags = new ArrayList<Tag>();
    /**
     * The [ISO 639-1](https://en.wikipedia.org/wiki/ISO_639-1) language code of the Gherkin document
     * (Required)
     * 
     */
    private String language;
    /**
     * The text of the `Feature` keyword (in the language specified by `language`)
     * (Required)
     * 
     */
    private String keyword;
    /**
     * The name of the feature (the text following the `keyword`)
     * (Required)
     * 
     */
    private String name;
    /**
     * The line(s) underneath the line with the `keyword` that are used as description
     * (Required)
     * 
     */
    private String description;
    /**
     * Zero or more children
     * (Required)
     * 
     */
    private List<FeatureChild> children = new ArrayList<FeatureChild>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public Feature() {
    }

    /**
     * 
     * @param children
     * @param name
     * @param description
     * @param location
     * @param language
     * @param keyword
     * @param tags
     */
    public Feature(Location location, List<Tag> tags, String language, String keyword, String name, String description, List<FeatureChild> children) {
        super();
        this.location = location;
        this.tags = tags;
        this.language = language;
        this.keyword = keyword;
        this.name = name;
        this.description = description;
        this.children = children;
    }

    /**
     * *
     *  Points to a line and a column in a text file
     * (Required)
     * 
     */
    public Location getLocation() {
        return location;
    }

    /**
     * *
     *  Points to a line and a column in a text file
     * (Required)
     * 
     */
    public void setLocation(Location location) {
        this.location = location;
    }

    /**
     * All the tags placed above the `Feature` keyword
     * (Required)
     * 
     */
    public List<Tag> getTags() {
        return tags;
    }

    /**
     * All the tags placed above the `Feature` keyword
     * (Required)
     * 
     */
    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    /**
     * The [ISO 639-1](https://en.wikipedia.org/wiki/ISO_639-1) language code of the Gherkin document
     * (Required)
     * 
     */
    public String getLanguage() {
        return language;
    }

    /**
     * The [ISO 639-1](https://en.wikipedia.org/wiki/ISO_639-1) language code of the Gherkin document
     * (Required)
     * 
     */
    public void setLanguage(String language) {
        this.language = language;
    }

    /**
     * The text of the `Feature` keyword (in the language specified by `language`)
     * (Required)
     * 
     */
    public String getKeyword() {
        return keyword;
    }

    /**
     * The text of the `Feature` keyword (in the language specified by `language`)
     * (Required)
     * 
     */
    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    /**
     * The name of the feature (the text following the `keyword`)
     * (Required)
     * 
     */
    public String getName() {
        return name;
    }

    /**
     * The name of the feature (the text following the `keyword`)
     * (Required)
     * 
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * The line(s) underneath the line with the `keyword` that are used as description
     * (Required)
     * 
     */
    public String getDescription() {
        return description;
    }

    /**
     * The line(s) underneath the line with the `keyword` that are used as description
     * (Required)
     * 
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * Zero or more children
     * (Required)
     * 
     */
    public List<FeatureChild> getChildren() {
        return children;
    }

    /**
     * Zero or more children
     * (Required)
     * 
     */
    public void setChildren(List<FeatureChild> children) {
        this.children = children;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Feature.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("location");
        sb.append('=');
        sb.append(((this.location == null)?"<null>":this.location));
        sb.append(',');
        sb.append("tags");
        sb.append('=');
        sb.append(((this.tags == null)?"<null>":this.tags));
        sb.append(',');
        sb.append("language");
        sb.append('=');
        sb.append(((this.language == null)?"<null>":this.language));
        sb.append(',');
        sb.append("keyword");
        sb.append('=');
        sb.append(((this.keyword == null)?"<null>":this.keyword));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("children");
        sb.append('=');
        sb.append(((this.children == null)?"<null>":this.children));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.children == null)? 0 :this.children.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.location == null)? 0 :this.location.hashCode()));
        result = ((result* 31)+((this.language == null)? 0 :this.language.hashCode()));
        result = ((result* 31)+((this.keyword == null)? 0 :this.keyword.hashCode()));
        result = ((result* 31)+((this.tags == null)? 0 :this.tags.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Feature) == false) {
            return false;
        }
        Feature rhs = ((Feature) other);
        return ((((((((this.children == rhs.children)||((this.children!= null)&&this.children.equals(rhs.children)))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.location == rhs.location)||((this.location!= null)&&this.location.equals(rhs.location))))&&((this.language == rhs.language)||((this.language!= null)&&this.language.equals(rhs.language))))&&((this.keyword == rhs.keyword)||((this.keyword!= null)&&this.keyword.equals(rhs.keyword))))&&((this.tags == rhs.tags)||((this.tags!= null)&&this.tags.equals(rhs.tags))));
    }

}
