
package io.cucumber.messages.types;


public class Timestamp {

    /**
     * Represents seconds of UTC time since Unix epoch
     *  1970-01-01T00:00:00Z. Must be from 0001-01-01T00:00:00Z to
     *  9999-12-31T23:59:59Z inclusive.
     * (Required)
     * 
     */
    private Long seconds;
    /**
     * Non-negative fractions of a second at nanosecond resolution. Negative
     *  second values with fractions must still have non-negative nanos values
     *  that count forward in time. Must be from 0 to 999,999,999
     *  inclusive.
     * (Required)
     * 
     */
    private Long nanos;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Timestamp() {
    }

    /**
     * 
     * @param seconds
     * @param nanos
     */
    public Timestamp(Long seconds, Long nanos) {
        super();
        this.seconds = seconds;
        this.nanos = nanos;
    }

    /**
     * Represents seconds of UTC time since Unix epoch
     *  1970-01-01T00:00:00Z. Must be from 0001-01-01T00:00:00Z to
     *  9999-12-31T23:59:59Z inclusive.
     * (Required)
     * 
     */
    public Long getSeconds() {
        return seconds;
    }

    /**
     * Represents seconds of UTC time since Unix epoch
     *  1970-01-01T00:00:00Z. Must be from 0001-01-01T00:00:00Z to
     *  9999-12-31T23:59:59Z inclusive.
     * (Required)
     * 
     */
    public void setSeconds(Long seconds) {
        this.seconds = seconds;
    }

    /**
     * Non-negative fractions of a second at nanosecond resolution. Negative
     *  second values with fractions must still have non-negative nanos values
     *  that count forward in time. Must be from 0 to 999,999,999
     *  inclusive.
     * (Required)
     * 
     */
    public Long getNanos() {
        return nanos;
    }

    /**
     * Non-negative fractions of a second at nanosecond resolution. Negative
     *  second values with fractions must still have non-negative nanos values
     *  that count forward in time. Must be from 0 to 999,999,999
     *  inclusive.
     * (Required)
     * 
     */
    public void setNanos(Long nanos) {
        this.nanos = nanos;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Timestamp.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("seconds");
        sb.append('=');
        sb.append(((this.seconds == null)?"<null>":this.seconds));
        sb.append(',');
        sb.append("nanos");
        sb.append('=');
        sb.append(((this.nanos == null)?"<null>":this.nanos));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.nanos == null)? 0 :this.nanos.hashCode()));
        result = ((result* 31)+((this.seconds == null)? 0 :this.seconds.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Timestamp) == false) {
            return false;
        }
        Timestamp rhs = ((Timestamp) other);
        return (((this.nanos == rhs.nanos)||((this.nanos!= null)&&this.nanos.equals(rhs.nanos)))&&((this.seconds == rhs.seconds)||((this.seconds!= null)&&this.seconds.equals(rhs.seconds))));
    }

}
