/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.testngxmlformatter;

import io.cucumber.messages.Convertor;
import io.cucumber.messages.types.Duration;
import io.cucumber.messages.types.Envelope;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.Pickle;
import io.cucumber.messages.types.PickleStep;
import io.cucumber.messages.types.Step;
import io.cucumber.messages.types.TestCaseFinished;
import io.cucumber.messages.types.TestCaseStarted;
import io.cucumber.messages.types.TestStep;
import io.cucumber.messages.types.TestStepFinished;
import io.cucumber.messages.types.TestStepResult;
import io.cucumber.messages.types.TestStepResultStatus;
import io.cucumber.messages.types.Timestamp;
import io.cucumber.query.NamingStrategy;
import io.cucumber.query.Query;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.AbstractMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class XmlReportData {
    final Query query = new Query();
    private final NamingStrategy namingStrategy = NamingStrategy.strategy((NamingStrategy.Strategy)NamingStrategy.Strategy.LONG).featureName(NamingStrategy.FeatureName.EXCLUDE).build();
    private static final Duration ZERO_DURATION = new Duration(Long.valueOf(0L), Long.valueOf(0L));
    private static final TestStepResult SCENARIO_WITH_NO_STEPS = new TestStepResult(ZERO_DURATION, null, TestStepResultStatus.PASSED, null);

    XmlReportData() {
    }

    void collect(Envelope envelope) {
        this.query.update(envelope);
    }

    long getSuiteDurationInMilliSeconds() {
        return this.query.findTestRunDuration().orElse(java.time.Duration.ZERO).toMillis();
    }

    long getDurationInMilliSeconds(TestCaseStarted testCaseStarted) {
        return this.query.findTestCaseDurationBy(testCaseStarted).orElse(java.time.Duration.ZERO).toMillis();
    }

    Map<TestStepResultStatus, Long> getTestCaseStatusCounts() {
        return this.query.countMostSevereTestStepResultStatus();
    }

    int getTestCaseCount() {
        return this.query.countTestCasesStarted();
    }

    String getPickleName(TestCaseStarted testCaseStarted) {
        Pickle pickle = (Pickle)this.query.findPickleBy(testCaseStarted).orElseThrow(() -> new IllegalStateException("No pickle for " + testCaseStarted.getId()));
        return this.query.findNameOf(pickle, this.namingStrategy);
    }

    List<Map.Entry<String, String>> getStepsAndResult(TestCaseStarted testCaseStarted) {
        return this.query.findTestStepFinishedAndTestStepBy(testCaseStarted).stream().filter(entry -> ((TestStep)entry.getValue()).getPickleStepId().isPresent()).map(testStep -> {
            String key = this.renderTestStepText((TestStep)testStep.getValue());
            String value = this.renderTestStepResult((TestStepFinished)testStep.getKey());
            return new AbstractMap.SimpleEntry<String, String>(key, value);
        }).collect(Collectors.toList());
    }

    private String renderTestStepResult(TestStepFinished testStepFinished) {
        return testStepFinished.getTestStepResult().getStatus().toString().toLowerCase(Locale.ROOT);
    }

    private String renderTestStepText(TestStep testStep) {
        Optional pickleStep = this.query.findPickleStepBy(testStep);
        String stepKeyWord = pickleStep.flatMap(arg_0 -> ((Query)this.query).findStepBy(arg_0)).map(Step::getKeyword).orElse("");
        String stepText = pickleStep.map(PickleStep::getText).orElse("");
        return stepKeyWord + stepText;
    }

    Set<Map.Entry<Optional<Feature>, List<TestCaseStarted>>> getAllTestCaseStartedGroupedByFeature() {
        return this.query.findAllTestCaseStartedGroupedByFeature().entrySet();
    }

    TestStepResult getTestCaseStatus(TestCaseStarted testCaseStarted) {
        return this.query.findMostSevereTestStepResulBy(testCaseStarted).orElse(SCENARIO_WITH_NO_STEPS);
    }

    public String getStartedAt(TestCaseStarted testCaseStarted) {
        Instant instant = Convertor.toInstant((Timestamp)testCaseStarted.getTimestamp());
        return DateTimeFormatter.ISO_INSTANT.format(instant);
    }

    public String getFinishedAt(TestCaseStarted testCaseStarted) {
        TestCaseFinished testCaseFinished = (TestCaseFinished)this.query.findTestCaseFinishedBy(testCaseStarted).orElseThrow(() -> new IllegalStateException("No test cased finished for " + testCaseStarted));
        Instant instant = Convertor.toInstant((Timestamp)testCaseFinished.getTimestamp());
        return DateTimeFormatter.ISO_INSTANT.format(instant);
    }
}

