/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.ddl;

import io.debezium.annotation.NotThreadSafe;
import io.debezium.relational.TableId;
import io.debezium.relational.ddl.DdlParserListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

@NotThreadSafe
public class DdlChanges
implements DdlParserListener {
    private final String terminator;
    private final List<DdlParserListener.Event> events = new ArrayList<DdlParserListener.Event>();
    private final Set<String> databaseNames = new HashSet<String>();

    public DdlChanges() {
        this(null);
    }

    public DdlChanges(String terminator) {
        this.terminator = terminator != null ? terminator : ";";
    }

    public DdlChanges reset() {
        this.events.clear();
        this.databaseNames.clear();
        return this;
    }

    @Override
    public void handle(DdlParserListener.Event event) {
        this.events.add(event);
        this.databaseNames.add(this.getDatabase(event));
    }

    public void groupStatementStringsByDatabase(DatabaseStatementStringConsumer consumer) {
        this.groupEventsByDatabase((dbName, eventList) -> {
            StringBuilder statements = new StringBuilder();
            HashSet<TableId> tables = new HashSet<TableId>();
            eventList.forEach(event -> {
                statements.append(event.statement());
                statements.append(this.terminator);
                this.addTable((Set<TableId>)tables, (DdlParserListener.Event)event);
            });
            consumer.consume(dbName, tables, statements.toString());
        });
    }

    private void addTable(Set<TableId> tables, DdlParserListener.Event event) {
        if (event instanceof DdlParserListener.TableEvent) {
            tables.add(((DdlParserListener.TableEvent)event).tableId());
        }
    }

    public void groupStatementsByDatabase(DatabaseStatementConsumer consumer) {
        this.groupEventsByDatabase((dbName, eventList) -> {
            ArrayList<String> statements = new ArrayList<String>();
            HashSet<TableId> tables = new HashSet<TableId>();
            eventList.forEach(event -> {
                statements.add(event.statement());
                this.addTable((Set<TableId>)tables, (DdlParserListener.Event)event);
            });
            consumer.consume(dbName, tables, statements);
        });
    }

    public void groupEventsByDatabase(DatabaseEventConsumer consumer) {
        if (this.isEmpty()) {
            return;
        }
        if (this.databaseNames.size() <= 1) {
            consumer.consume(this.databaseNames.iterator().next(), this.events);
            return;
        }
        ArrayList<DdlParserListener.Event> dbEvents = new ArrayList<DdlParserListener.Event>();
        String currentDatabase = null;
        for (DdlParserListener.Event event : this.events) {
            String dbName = this.getDatabase(event);
            if (currentDatabase == null || dbName.equals(currentDatabase)) {
                currentDatabase = dbName;
                dbEvents.add(event);
                continue;
            }
            consumer.consume(currentDatabase, dbEvents);
        }
    }

    protected String getDatabase(DdlParserListener.Event event) {
        switch (event.type()) {
            case CREATE_TABLE: 
            case ALTER_TABLE: 
            case DROP_TABLE: 
            case TRUNCATE_TABLE: {
                DdlParserListener.TableEvent tableEvent = (DdlParserListener.TableEvent)event;
                return tableEvent.tableId().catalog();
            }
            case CREATE_INDEX: 
            case DROP_INDEX: {
                DdlParserListener.TableIndexEvent tableIndexEvent = (DdlParserListener.TableIndexEvent)event;
                return tableIndexEvent.tableId().catalog();
            }
            case CREATE_DATABASE: 
            case ALTER_DATABASE: 
            case DROP_DATABASE: 
            case USE_DATABASE: {
                DdlParserListener.DatabaseEvent dbEvent = (DdlParserListener.DatabaseEvent)event;
                return dbEvent.databaseName();
            }
            case SET_VARIABLE: {
                DdlParserListener.SetVariableEvent varEvent = (DdlParserListener.SetVariableEvent)event;
                return varEvent.databaseName().orElse("");
            }
        }
        assert (false) : "Should never happen";
        return null;
    }

    public boolean isEmpty() {
        return this.events.isEmpty();
    }

    public boolean applyToMoreDatabasesThan(String name) {
        return this.databaseNames.contains(name) ? this.databaseNames.size() > 1 : this.databaseNames.size() > 0;
    }

    public String toString() {
        return this.events.toString();
    }

    public boolean anyMatch(Predicate<String> databaseFilter, Predicate<TableId> tableFilter) {
        return this.events.stream().anyMatch(event -> event instanceof DdlParserListener.DatabaseEvent && databaseFilter.test(((DdlParserListener.DatabaseEvent)event).databaseName()) || event instanceof DdlParserListener.TableEvent && tableFilter.test(((DdlParserListener.TableEvent)event).tableId()) || event instanceof DdlParserListener.SetVariableEvent && (!((DdlParserListener.SetVariableEvent)event).databaseName().isPresent() || databaseFilter.test(((DdlParserListener.SetVariableEvent)event).databaseName().get())));
    }

    public static interface DatabaseStatementStringConsumer {
        public void consume(String var1, Set<TableId> var2, String var3);
    }

    public static interface DatabaseStatementConsumer {
        public void consume(String var1, Set<TableId> var2, List<String> var3);
    }

    public static interface DatabaseEventConsumer {
        public void consume(String var1, List<DdlParserListener.Event> var2);
    }
}

