/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.document;

import io.debezium.document.Array;
import io.debezium.document.Document;
import io.debezium.document.JacksonReader;
import io.debezium.document.JacksonWriter;
import io.debezium.util.Testing;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class JacksonArrayReadingAndWritingTest
implements Testing {
    private Array array;
    private Array after;
    private JacksonWriter writer = JacksonWriter.INSTANCE;
    private JacksonReader reader = JacksonReader.DEFAULT_INSTANCE;

    @Before
    public void beforeEach() {
        this.array = Array.create();
        this.after = null;
    }

    @Test
    public void shouldWriteDocumentWithSingleField() throws Exception {
        this.array.add("value1");
        this.after = this.reader.readArray(this.writer.write(this.array));
        Assertions.assertThat((Comparable)this.after.get(0)).isEqualTo((Object)"value1");
        Assertions.assertThat((int)this.after.size()).isEqualTo(1);
    }

    @Test
    public void shouldWriteDocumentWithTwoFields() throws Exception {
        this.array.add("value1");
        this.array.add("value2");
        this.after = this.reader.readArray(this.writer.write(this.array));
        Assertions.assertThat((Comparable)this.after.get(0)).isEqualTo((Object)"value1");
        Assertions.assertThat((Comparable)this.after.get(1)).isEqualTo((Object)"value2");
        Assertions.assertThat((int)this.after.size()).isEqualTo(2);
    }

    @Test
    public void shouldWriteDocumentWithNestedDocument() throws Exception {
        this.array.add("value1");
        this.array.add("value2");
        this.array.add(Document.create((CharSequence)"a", (Object)"A", (CharSequence)"b", (Object)"B"));
        this.after = this.reader.readArray(this.writer.write(this.array));
        Assertions.assertThat((Comparable)this.after.get(0)).isEqualTo((Object)"value1");
        Assertions.assertThat((Comparable)this.after.get(1)).isEqualTo((Object)"value2");
        Assertions.assertThat((int)this.after.size()).isEqualTo(3);
        Document nested = this.after.get(2).asDocument();
        Assertions.assertThat((String)nested.getString((CharSequence)"a")).isEqualTo((Object)"A");
        Assertions.assertThat((String)nested.getString((CharSequence)"b")).isEqualTo((Object)"B");
        Assertions.assertThat((int)nested.size()).isEqualTo(2);
    }

    @Test
    public void shouldWriteDocumentWithDeeplyNestedDocument() throws Exception {
        this.array.add("value1");
        this.array.add("value2");
        this.array.add(Document.create((CharSequence)"a", (Object)"A", (CharSequence)"b", (Object)"B", (CharSequence)"c", (Object)Document.create((CharSequence)"x", (Object)"X")));
        this.after = this.reader.readArray(this.writer.write(this.array));
        Assertions.assertThat((Comparable)this.after.get(0)).isEqualTo((Object)"value1");
        Assertions.assertThat((Comparable)this.after.get(1)).isEqualTo((Object)"value2");
        Assertions.assertThat((int)this.after.size()).isEqualTo(3);
        Document nested = this.after.get(2).asDocument();
        Assertions.assertThat((String)nested.getString((CharSequence)"a")).isEqualTo((Object)"A");
        Assertions.assertThat((String)nested.getString((CharSequence)"b")).isEqualTo((Object)"B");
        Assertions.assertThat((int)nested.size()).isEqualTo(3);
        Document deepNested = nested.getDocument((CharSequence)"c");
        Assertions.assertThat((String)deepNested.getString((CharSequence)"x")).isEqualTo((Object)"X");
        Assertions.assertThat((int)deepNested.size()).isEqualTo(1);
    }
}

