/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.relational.TableIdParser;
import io.debezium.relational.TableIdPredicates;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TableIdParserTest {
    @Test
    public void canParseValidIdentifiers() {
        Assertions.assertThat((List)TableIdParser.parse((String)"s.a")).containsExactly((Object[])new String[]{"s", "a"});
        Assertions.assertThat((List)TableIdParser.parse((String)"s2.a")).containsExactly((Object[])new String[]{"s2", "a"});
        Assertions.assertThat((List)TableIdParser.parse((String)"table")).containsExactly((Object[])new String[]{"table"});
        Assertions.assertThat((List)TableIdParser.parse((String)"  table  ")).containsExactly((Object[])new String[]{"table"});
        Assertions.assertThat((List)TableIdParser.parse((String)"schema.table")).containsExactly((Object[])new String[]{"schema", "table"});
        Assertions.assertThat((List)TableIdParser.parse((String)"  schema  .  table  ")).containsExactly((Object[])new String[]{"schema", "table"});
        Assertions.assertThat((List)TableIdParser.parse((String)"catalog.schema.table")).containsExactly((Object[])new String[]{"catalog", "schema", "table"});
        Assertions.assertThat((List)TableIdParser.parse((String)"catalog  .  schema  .  table")).containsExactly((Object[])new String[]{"catalog", "schema", "table"});
        Assertions.assertThat((List)TableIdParser.parse((String)"\"table\"")).containsExactly((Object[])new String[]{"table"});
        Assertions.assertThat((List)TableIdParser.parse((String)"\"ta.ble\"")).containsExactly((Object[])new String[]{"ta.ble"});
        Assertions.assertThat((List)TableIdParser.parse((String)"\"ta   ble\"")).containsExactly((Object[])new String[]{"ta   ble"});
        Assertions.assertThat((List)TableIdParser.parse((String)"\"schema\".\"table\"")).containsExactly((Object[])new String[]{"schema", "table"});
        Assertions.assertThat((List)TableIdParser.parse((String)"\"cata . log\" . \"sche . ma\" . \"ta . ble\"")).containsExactly((Object[])new String[]{"cata . log", "sche . ma", "ta . ble"});
        Assertions.assertThat((List)TableIdParser.parse((String)"\"tab\"\"le\"")).containsExactly((Object[])new String[]{"tab\"le"});
        Assertions.assertThat((List)TableIdParser.parse((String)"\"tab\"\"\"\"le\"")).containsExactly((Object[])new String[]{"tab\"\"le"});
        Assertions.assertThat((List)TableIdParser.parse((String)"\"\"\"s\"\"\".\"\"\"a\"\"\"")).containsExactly((Object[])new String[]{"\"s\"", "\"a\""});
        Assertions.assertThat((List)TableIdParser.parse((String)"[db].[table]", (TableIdPredicates)new TestTableIdPredicates())).containsExactly((Object[])new String[]{"db", "table"});
        Assertions.assertThat((List)TableIdParser.parse((String)"[db].[table with spaces]", (TableIdPredicates)new TestTableIdPredicates())).containsExactly((Object[])new String[]{"db", "table with spaces"});
    }

    @Test(expected=IllegalArgumentException.class)
    public void leadingSeparatorIsInvalid() {
        TableIdParser.parse((String)".table");
    }

    @Test(expected=IllegalArgumentException.class)
    public void trailingSeparatorIsInvalid() {
        TableIdParser.parse((String)"table.");
    }

    @Test(expected=IllegalArgumentException.class)
    public void unclosedQuotingCharIsInvalid() {
        TableIdParser.parse((String)"\"table");
    }

    @Test(expected=IllegalArgumentException.class)
    public void escapedQuoteDoesntCloseQuotedIdentifier() {
        TableIdParser.parse((String)"\"table\"\"");
    }

    private static class TestTableIdPredicates
    implements TableIdPredicates {
        private TestTableIdPredicates() {
        }

        public boolean isStartDelimiter(char c) {
            return c == '[';
        }

        public boolean isEndDelimiter(char c) {
            return c == ']';
        }
    }
}

