/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.time;

import io.debezium.time.Temporals;
import java.time.Duration;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TemporalsTest {
    @Test
    public void maxHandlesSameUnit() {
        Duration hundredMillis = Duration.ofMillis(100L);
        Duration thousandMillis = Duration.ofMillis(1000L);
        Assertions.assertThat((Comparable)Temporals.max((Duration)hundredMillis, (Duration)thousandMillis)).isEqualTo((Object)thousandMillis);
    }

    @Test
    public void maxHandlesDifferentUnits() {
        Duration sixtyOneMinutes = Duration.ofMinutes(61L);
        Duration oneHour = Duration.ofHours(1L);
        Assertions.assertThat((Comparable)Temporals.max((Duration)sixtyOneMinutes, (Duration)oneHour)).isEqualTo((Object)sixtyOneMinutes);
    }

    @Test
    public void maxHandlesEqualValue() {
        Duration oneMilli = Duration.ofMillis(1L);
        Duration oneMillionNanos = Duration.ofNanos(1000000L);
        Assertions.assertThat((Comparable)Temporals.max((Duration)oneMilli, (Duration)oneMillionNanos)).isEqualTo((Object)oneMilli);
        Assertions.assertThat((Comparable)Temporals.max((Duration)oneMilli, (Duration)oneMillionNanos)).isEqualTo((Object)oneMillionNanos);
    }
}

