/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms;

import io.debezium.transforms.AbstractExtractStateTest;
import io.debezium.transforms.SchemaChangeEventFilter;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class SchemaChangeEventFilterTest
extends AbstractExtractStateTest {
    private static final String SCHEMA_CHANGE_EVENT_EXCLUDE_LIST = "schema.change.event.exclude.list";
    private static final String SCHEMA_HISTORY_CHANGE_SCHEMA_NAME = "io.debezium.connector.schema.Change";

    @Test
    public void whenNoDeclaredConfigExceptionIsThrew() {
        try (SchemaChangeEventFilter transform = new SchemaChangeEventFilter();){
            HashMap props = new HashMap();
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> transform.configure(props)).isInstanceOf(ConfigException.class)).hasMessageContaining("Invalid value null for configuration schema.change.event.exclude.list: The 'schema.change.event.exclude.list' value is invalid: A value is required");
        }
    }

    @Test
    public void testSchemaChangeContainsEventTypeFilter() {
        try (SchemaChangeEventFilter transform = new SchemaChangeEventFilter();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(SCHEMA_CHANGE_EVENT_EXCLUDE_LIST, "ALTER, CREATE");
            transform.configure(props);
            SourceRecord record = this.createSchemaChangeRecordContainsEventType();
            Assertions.assertThat((Object)((SourceRecord)transform.apply((ConnectRecord)record))).isNull();
        }
    }

    @Test
    public void testSchemaChangeNonEventTypeFilter() {
        try (SchemaChangeEventFilter transform = new SchemaChangeEventFilter();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(SCHEMA_CHANGE_EVENT_EXCLUDE_LIST, "ALTER,CREATE");
            transform.configure(props);
            SourceRecord record = this.createSchemaChangeRecordNonEventType();
            Assertions.assertThat((Object)((SourceRecord)transform.apply((ConnectRecord)record))).isSameAs((Object)record);
        }
    }

    @Test
    public void testSchemaChangeNonContainsEventTypeFilter() {
        try (SchemaChangeEventFilter transform = new SchemaChangeEventFilter();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(SCHEMA_CHANGE_EVENT_EXCLUDE_LIST, "ALTER,CREATE");
            transform.configure(props);
            SourceRecord record = this.createSchemaChangeRecordNonContainsEventType();
            Assertions.assertThat((Object)((SourceRecord)transform.apply((ConnectRecord)record))).isSameAs((Object)record);
        }
    }

    protected SourceRecord createSchemaChangeRecordNonEventType() {
        Schema schemaChangeRecordSchema = SchemaChangeEventFilterTest.createSchemaChangeSchema();
        Struct result = new Struct(schemaChangeRecordSchema);
        result.put("ts_ms", (Object)System.currentTimeMillis());
        result.put("databaseName", (Object)"test");
        result.put("schemaName", (Object)"test_schema");
        result.put("ddl", (Object)"");
        result.put("tableChanges", new ArrayList());
        return new SourceRecord(new HashMap(), new HashMap(), "dummy", schemaChangeRecordSchema, (Object)result);
    }

    protected SourceRecord createSchemaChangeRecordContainsEventType() {
        Schema schemaChangeRecordSchema = SchemaChangeEventFilterTest.createSchemaChangeSchema();
        Struct result = new Struct(schemaChangeRecordSchema);
        result.put("ts_ms", (Object)System.currentTimeMillis());
        result.put("databaseName", (Object)"test");
        result.put("schemaName", (Object)"test_schema");
        result.put("ddl", (Object)"");
        ArrayList<Struct> structs = new ArrayList<Struct>();
        Struct struct = new Struct(SchemaChangeEventFilterTest.schemaHistoryChangeSchema());
        struct.put("type", (Object)"ALTER");
        struct.put("id", (Object)"test.table");
        structs.add(struct);
        result.put("tableChanges", structs);
        return new SourceRecord(new HashMap(), new HashMap(), "dummy", schemaChangeRecordSchema, (Object)result);
    }

    protected SourceRecord createSchemaChangeRecordNonContainsEventType() {
        Schema schemaChangeRecordSchema = SchemaChangeEventFilterTest.createSchemaChangeSchema();
        Struct result = new Struct(schemaChangeRecordSchema);
        result.put("ts_ms", (Object)System.currentTimeMillis());
        result.put("databaseName", (Object)"test");
        result.put("schemaName", (Object)"test_schema");
        result.put("ddl", (Object)"");
        ArrayList<Struct> structs = new ArrayList<Struct>();
        Struct struct = new Struct(SchemaChangeEventFilterTest.schemaHistoryChangeSchema());
        struct.put("type", (Object)"DROP");
        struct.put("id", (Object)"test.table");
        structs.add(struct);
        result.put("tableChanges", structs);
        result.put("tableChanges", structs);
        return new SourceRecord(new HashMap(), new HashMap(), "dummy", schemaChangeRecordSchema, (Object)result);
    }

    private static Schema createSchemaChangeSchema() {
        Schema schemaChangeRecordSchema = SchemaBuilder.struct().name("filter.SchemaChangeValue").field("ts_ms", Schema.INT64_SCHEMA).field("databaseName", Schema.OPTIONAL_STRING_SCHEMA).field("schemaName", Schema.OPTIONAL_STRING_SCHEMA).field("ddl", Schema.OPTIONAL_STRING_SCHEMA).field("tableChanges", SchemaBuilder.array((Schema)SchemaChangeEventFilterTest.schemaHistoryChangeSchema()).build()).build();
        return schemaChangeRecordSchema;
    }

    protected static Schema schemaHistoryChangeSchema() {
        return SchemaBuilder.struct().name(SCHEMA_HISTORY_CHANGE_SCHEMA_NAME).field("type", Schema.STRING_SCHEMA).field("id", Schema.STRING_SCHEMA).build();
    }
}

