/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.applicationcrd.api.model;

import io.dekorate.deps.applicationcrd.api.model.InfoItem;
import io.dekorate.deps.applicationcrd.api.model.InfoItemFluent;
import io.dekorate.deps.applicationcrd.api.model.InfoItemFluentImpl;
import io.dekorate.deps.javax.validation.Validator;
import io.dekorate.deps.kubernetes.api.builder.ValidationUtils;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;

public class InfoItemBuilder
extends InfoItemFluentImpl<InfoItemBuilder>
implements VisitableBuilder<InfoItem, InfoItemBuilder> {
    InfoItemFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public InfoItemBuilder() {
        this(true);
    }

    public InfoItemBuilder(Boolean validationEnabled) {
        this(new InfoItem(), validationEnabled);
    }

    public InfoItemBuilder(InfoItemFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public InfoItemBuilder(InfoItemFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new InfoItem(), validationEnabled);
    }

    public InfoItemBuilder(InfoItemFluent<?> fluent, InfoItem instance) {
        this(fluent, instance, true);
    }

    public InfoItemBuilder(InfoItemFluent<?> fluent, InfoItem instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withType(instance.getType());
        fluent.withValue(instance.getValue());
        fluent.withValueFrom(instance.getValueFrom());
        this.validationEnabled = validationEnabled;
    }

    public InfoItemBuilder(InfoItem instance) {
        this(instance, (Boolean)true);
    }

    public InfoItemBuilder(InfoItem instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withType(instance.getType());
        this.withValue(instance.getValue());
        this.withValueFrom(instance.getValueFrom());
        this.validationEnabled = validationEnabled;
    }

    public InfoItemBuilder(Validator validator) {
        this(new InfoItem(), (Boolean)true);
    }

    public InfoItemBuilder(InfoItemFluent<?> fluent, InfoItem instance, Validator validator) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withType(instance.getType());
        fluent.withValue(instance.getValue());
        fluent.withValueFrom(instance.getValueFrom());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public InfoItemBuilder(InfoItem instance, Validator validator) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withType(instance.getType());
        this.withValue(instance.getValue());
        this.withValueFrom(instance.getValueFrom());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public InfoItem build() {
        InfoItem buildable = new InfoItem(this.fluent.getName(), this.fluent.getType(), this.fluent.getValue(), this.fluent.getValueFrom());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate((Object)buildable, (Validator)this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InfoItemBuilder that = (InfoItemBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

