/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.knative.duck.v1alpha1;

import io.dekorate.deps.knative.duck.v1alpha1.Resource;
import io.dekorate.deps.knative.duck.v1alpha1.ResourceBuilder;
import io.dekorate.deps.knative.duck.v1alpha1.ResourceFluentImpl;
import io.dekorate.deps.knative.duck.v1alpha1.ResourceList;
import io.dekorate.deps.knative.duck.v1alpha1.ResourceListFluent;
import io.dekorate.deps.kubernetes.api.builder.BaseFluent;
import io.dekorate.deps.kubernetes.api.builder.Nested;
import io.dekorate.deps.kubernetes.api.builder.Predicate;
import io.dekorate.deps.kubernetes.api.model.ListMeta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ResourceListFluentImpl<A extends ResourceListFluent<A>>
extends BaseFluent<A>
implements ResourceListFluent<A> {
    private String apiVersion;
    private List<ResourceBuilder> items;
    private String kind;
    private ListMeta metadata;

    public ResourceListFluentImpl() {
    }

    public ResourceListFluentImpl(ResourceList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A addToItems(int index, Resource item) {
        if (this.items == null) {
            this.items = new ArrayList<ResourceBuilder>();
        }
        ResourceBuilder builder = new ResourceBuilder(item);
        this._visitables.get("items").add(index >= 0 ? index : this._visitables.get("items").size(), builder);
        this.items.add(index >= 0 ? index : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(int index, Resource item) {
        if (this.items == null) {
            this.items = new ArrayList<ResourceBuilder>();
        }
        ResourceBuilder builder = new ResourceBuilder(item);
        if (index < 0 || index >= this._visitables.get("items").size()) {
            this._visitables.get("items").add(builder);
        } else {
            this._visitables.get("items").set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(Resource ... items) {
        if (this.items == null) {
            this.items = new ArrayList<ResourceBuilder>();
        }
        for (Resource item : items) {
            ResourceBuilder builder = new ResourceBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<Resource> items) {
        if (this.items == null) {
            this.items = new ArrayList<ResourceBuilder>();
        }
        for (Resource item : items) {
            ResourceBuilder builder = new ResourceBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(Resource ... items) {
        for (Resource item : items) {
            ResourceBuilder builder = new ResourceBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<Resource> items) {
        for (Resource item : items) {
            ResourceBuilder builder = new ResourceBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromItems(Predicate<ResourceBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<ResourceBuilder> each = this.items.iterator();
        Object visitables = this._visitables.get("items");
        while (each.hasNext()) {
            ResourceBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Resource> getItems() {
        return ResourceListFluentImpl.build(this.items);
    }

    @Override
    public List<Resource> buildItems() {
        return ResourceListFluentImpl.build(this.items);
    }

    @Override
    public Resource buildItem(int index) {
        return this.items.get(index).build();
    }

    @Override
    public Resource buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public Resource buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public Resource buildMatchingItem(Predicate<ResourceBuilder> predicate) {
        for (ResourceBuilder item : this.items) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<ResourceBuilder> predicate) {
        for (ResourceBuilder item : this.items) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<Resource> items) {
        if (this.items != null) {
            this._visitables.get("items").removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList<ResourceBuilder>();
            for (Resource item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(Resource ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (Resource item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public ResourceListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public ResourceListFluent.ItemsNested<A> addNewItemLike(Resource item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public ResourceListFluent.ItemsNested<A> setNewItemLike(int index, Resource item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public ResourceListFluent.ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public ResourceListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public ResourceListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public ResourceListFluent.ItemsNested<A> editMatchingItem(Predicate<ResourceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.apply(this.items.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this.metadata = metadata;
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public A withNewMetadata(String _continue, Long remainingItemCount, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceListFluentImpl that = (ResourceListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    public class ItemsNestedImpl<N>
    extends ResourceFluentImpl<ResourceListFluent.ItemsNested<N>>
    implements ResourceListFluent.ItemsNested<N>,
    Nested<N> {
        private final ResourceBuilder builder;
        private final int index;

        ItemsNestedImpl(int index, Resource item) {
            this.index = index;
            this.builder = new ResourceBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new ResourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ResourceListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

