/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model;

import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.Affinity;
import io.dekorate.deps.kubernetes.api.model.AffinityFluent;
import io.dekorate.deps.kubernetes.api.model.AffinityFluentImpl;

public class AffinityBuilder
extends AffinityFluentImpl<AffinityBuilder>
implements VisitableBuilder<Affinity, AffinityBuilder> {
    AffinityFluent<?> fluent;
    Boolean validationEnabled;

    public AffinityBuilder() {
        this(true);
    }

    public AffinityBuilder(Boolean validationEnabled) {
        this(new Affinity(), validationEnabled);
    }

    public AffinityBuilder(AffinityFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public AffinityBuilder(AffinityFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Affinity(), validationEnabled);
    }

    public AffinityBuilder(AffinityFluent<?> fluent, Affinity instance) {
        this(fluent, instance, true);
    }

    public AffinityBuilder(AffinityFluent<?> fluent, Affinity instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withNodeAffinity(instance.getNodeAffinity());
        fluent.withPodAffinity(instance.getPodAffinity());
        fluent.withPodAntiAffinity(instance.getPodAntiAffinity());
        this.validationEnabled = validationEnabled;
    }

    public AffinityBuilder(Affinity instance) {
        this(instance, (Boolean)true);
    }

    public AffinityBuilder(Affinity instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withNodeAffinity(instance.getNodeAffinity());
        this.withPodAffinity(instance.getPodAffinity());
        this.withPodAntiAffinity(instance.getPodAntiAffinity());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Affinity build() {
        Affinity buildable = new Affinity(this.fluent.getNodeAffinity(), this.fluent.getPodAffinity(), this.fluent.getPodAntiAffinity());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AffinityBuilder that = (AffinityBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

