/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.client;

import io.dekorate.deps.kubernetes.api.builder.Function;
import io.dekorate.deps.kubernetes.client.Client;
import io.dekorate.deps.kubernetes.client.RequestConfig;
import io.dekorate.deps.kubernetes.client.RequestConfigHolder;
import io.dekorate.deps.kubernetes.client.dsl.FunctionCallable;

public class WithRequestCallable<C extends Client>
implements FunctionCallable<C> {
    private final C client;
    private final RequestConfig requestConfig;

    public WithRequestCallable(C client, RequestConfig requestConfig) {
        this.client = client;
        this.requestConfig = requestConfig;
    }

    @Override
    public <O> O call(Function<C, O> function) {
        try {
            RequestConfigHolder.set(this.requestConfig);
            O o = function.apply(this.client);
            return o;
        }
        finally {
            RequestConfigHolder.remove();
        }
    }
}

