/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.openshift.client.handlers;

import io.dekorate.deps.kubernetes.client.Config;
import io.dekorate.deps.kubernetes.client.ResourceHandler;
import io.dekorate.deps.kubernetes.client.Watch;
import io.dekorate.deps.kubernetes.client.Watcher;
import io.dekorate.deps.kubernetes.client.dsl.Gettable;
import io.dekorate.deps.kubernetes.client.dsl.Resource;
import io.dekorate.deps.okhttp3.OkHttpClient;
import io.dekorate.deps.openshift.api.model.Project;
import io.dekorate.deps.openshift.api.model.ProjectBuilder;
import io.dekorate.deps.openshift.client.OpenShiftConfig;
import io.dekorate.deps.openshift.client.dsl.internal.ProjectOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class ProjectHandler
implements ResourceHandler<Project, ProjectBuilder> {
    @Override
    public String getKind() {
        return Project.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "project.openshift.io/v1";
    }

    @Override
    public Project create(OkHttpClient client, Config config, String namespace, Project item) {
        return (Project)new ProjectOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create(new Project[0]);
    }

    @Override
    public Project replace(OkHttpClient client, Config config, String namespace, Project item) {
        return (Project)((Resource)new ProjectOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public Project reload(OkHttpClient client, Config config, String namespace, Project item) {
        return (Project)((Gettable)((Resource)new ProjectOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public ProjectBuilder edit(Project item) {
        return new ProjectBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, Project item) {
        if (cascading.booleanValue()) {
            return (Boolean)new ProjectOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).cascading(true).delete();
        }
        return (Boolean)new ProjectOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).delete(item);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Project item, Watcher<Project> watcher) {
        return (Watch)((Resource)new ProjectOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Project item, String resourceVersion, Watcher<Project> watcher) {
        return (Watch)((Resource)new ProjectOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Project waitUntilReady(OkHttpClient client, Config config, String namespace, Project item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Project)((Resource)new ProjectOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public Project waitUntilCondition(OkHttpClient client, Config config, String namespace, Project item, Predicate<Project> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Project)((Resource)new ProjectOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

