/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.knative.apt;

import io.dekorate.doc.Description;
import io.dekorate.knative.generator.KnativeApplicationGenerator;
import io.dekorate.processor.AbstractAnnotationProcessor;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

@Description(value="Generates knative manifests.")
@SupportedAnnotationTypes(value={"io.dekorate.knative.annotation.KnativeApplication"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class KnativeAnnotationProcessor
extends AbstractAnnotationProcessor
implements KnativeApplicationGenerator {
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            this.getSession().close();
            return true;
        }
        HashSet<Element> mainClasses = new HashSet<Element>();
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                mainClasses.add(element);
            }
        }
        for (Element element : mainClasses) {
            this.add(element);
        }
        return false;
    }
}

