/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.option.apt;

import io.dekorate.WithSession;
import io.dekorate.doc.Description;
import io.dekorate.option.annotation.GeneratorOptions;
import io.dekorate.processor.AbstractAnnotationProcessor;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

@Description(value="Processing generator options, which are used for customizing the generation process")
@SupportedAnnotationTypes(value={"io.dekorate.annotation.Dekorate", "io.dekorate.kubernetes.annotation.KubernetesApplication", "io.dekorate.openshift.annotation.OpenshiftApplication", "io.dekorate.knative.annotation.KnativeApplication", "io.dekorate.option.annotation.GeneratorOptions"})
public class GeneratorOptionsProcessor
extends AbstractAnnotationProcessor
implements WithSession {
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            this.getSession().close();
            return true;
        }
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                GeneratorOptions options = element.getAnnotation(GeneratorOptions.class);
                if (options == null) continue;
                this.process("options", element, GeneratorOptions.class);
                return false;
            }
        }
        return false;
    }
}

