/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.s2i.buildservice;

import io.dekorate.BuildService;
import io.dekorate.BuildServiceApplicablility;
import io.dekorate.BuildServiceFactory;
import io.dekorate.config.ConfigurationSupplier;
import io.dekorate.deps.kubernetes.api.model.HasMetadata;
import io.dekorate.kubernetes.config.ImageConfiguration;
import io.dekorate.project.Project;
import io.dekorate.s2i.buildservice.S2iBuildService;
import io.dekorate.s2i.config.S2iBuildConfig;
import java.util.Collection;
import java.util.Collections;

public class S2iBuildServiceFactory
implements BuildServiceFactory {
    private final String S2I = "s2i";
    private final String MESSAGE_OK = "S2i build service is applicable.";
    private final String MESSAGE_DISABLED = "S2i disabled.";

    public BuildService create(Project project, ImageConfiguration config) {
        return new S2iBuildService(project, config, Collections.emptyList());
    }

    public BuildService create(Project project, ImageConfiguration config, Collection<HasMetadata> resources) {
        return new S2iBuildService(project, config, resources);
    }

    public int order() {
        return 20;
    }

    public String name() {
        return "s2i";
    }

    public BuildServiceApplicablility checkApplicablility(Project project, ImageConfiguration config) {
        if (config instanceof S2iBuildConfig) {
            if (((S2iBuildConfig)config).isEnabled()) {
                return new BuildServiceApplicablility(true, "S2i build service is applicable.");
            }
            return new BuildServiceApplicablility(false, "S2i disabled.");
        }
        return new BuildServiceApplicablility(true, "S2i build service is applicable.");
    }

    public BuildServiceApplicablility checkApplicablility(Project project, ConfigurationSupplier<ImageConfiguration> supplier) {
        if (supplier.isExplicit()) {
            return new BuildServiceApplicablility(true, "S2i build service is applicable.");
        }
        return this.checkApplicablility(project, (ImageConfiguration)supplier.get());
    }
}

