/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import java.util.UUID;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TaskAttemptContextImpl;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.delta.CheckpointMetaData;
import org.apache.spark.sql.delta.Checkpoints$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.actions.Action$;
import org.apache.spark.sql.delta.actions.SingleAction;
import org.apache.spark.sql.delta.actions.SingleAction$;
import org.apache.spark.sql.delta.util.DeltaFileOperations$;
import org.apache.spark.sql.delta.util.FileNames$;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.util.LongAccumulator;
import org.apache.spark.util.SerializableConfiguration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Checkpoints$ {
    public static final Checkpoints$ MODULE$;

    static {
        new Checkpoints$();
    }

    public CheckpointMetaData writeCheckpoint(SparkSession spark, DeltaLog deltaLog, Snapshot snapshot) {
        boolean renameDone;
        FileSystem fs;
        Path src;
        ParquetFileFormat format = new ParquetFileFormat();
        Job job = Job.getInstance();
        Tuple2 tuple2 = new Tuple2((Object)format.prepareWrite(spark, job, Predef$.MODULE$.Map().empty(), Action$.MODULE$.logSchema()), (Object)new SerializableConfiguration(job.getConfiguration()));
        if (tuple2 != null) {
            Tuple2 tuple22;
            OutputWriterFactory factory = (OutputWriterFactory)tuple2._1();
            SerializableConfiguration serConf = (SerializableConfiguration)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)factory, (Object)serConf);
            OutputWriterFactory factory2 = (OutputWriterFactory)tuple23._1();
            SerializableConfiguration serConf2 = (SerializableConfiguration)tuple23._2();
            boolean useRename = deltaLog.store().isPartialWriteVisible(deltaLog.logPath());
            LongAccumulator checkpointSize = spark.sparkContext().longAccumulator("checkpointSize");
            LongAccumulator numOfFiles = spark.sparkContext().longAccumulator("numOfFiles");
            String path = FileNames$.MODULE$.checkpointFileSingular(snapshot.path(), snapshot.version()).toString();
            RDD qual$1 = snapshot.state().repartition(1).map((Function1)new Serializable(numOfFiles){
                public static final long serialVersionUID = 0L;
                private final LongAccumulator numOfFiles$1;

                public final SingleAction apply(SingleAction action) {
                    if (action.add() != null) {
                        this.numOfFiles$1.add(1L);
                    }
                    return action;
                }
                {
                    this.numOfFiles$1 = numOfFiles$1;
                }
            }, SingleAction$.MODULE$.encoder()).queryExecution().executedPlan().execute();
            Serializable x$7 = new Serializable(factory2, serConf2, useRename, checkpointSize, path){
                public static final long serialVersionUID = 0L;
                private final OutputWriterFactory factory$1;
                private final SerializableConfiguration serConf$1;
                private final boolean useRename$1;
                public final LongAccumulator checkpointSize$1;
                private final String path$1;

                public final Iterator<String> apply(Iterator<InternalRow> iter) {
                    Throwable throwable2;
                    block4: {
                        FileAlreadyExistsException fileAlreadyExistsException;
                        block5: {
                            String string;
                            if (this.useRename$1) {
                                Path p = new Path(this.path$1);
                                Path tempPath = new Path(p.getParent(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{".", ".", ".tmp"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{p.getName(), UUID.randomUUID()})));
                                DeltaFileOperations$.MODULE$.registerTempFileDeletionTaskFailureListener(this.serConf$1.value(), tempPath);
                                string = tempPath.toString();
                            } else {
                                string = this.path$1;
                            }
                            String writtenPath = string;
                            try {
                                OutputWriter writer = this.factory$1.newInstance(writtenPath, Action$.MODULE$.logSchema(), (TaskAttemptContext)new TaskAttemptContextImpl(new JobConf(this.serConf$1.value()), new TaskAttemptID("", 0, TaskType.REDUCE, 0, 0)));
                                iter.foreach((Function1)new Serializable(this, writer){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun.9 $outer;
                                    private final OutputWriter writer$1;

                                    public final void apply(InternalRow row) {
                                        this.$outer.checkpointSize$1.add(1L);
                                        this.writer$1.write(row);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.writer$1 = writer$1;
                                    }
                                });
                                writer.close();
                            }
                            catch (Throwable throwable2) {
                                Throwable throwable3 = throwable2;
                                if (!(throwable3 instanceof FileAlreadyExistsException)) break block4;
                                fileAlreadyExistsException = (FileAlreadyExistsException)throwable3;
                                if (this.useRename$1) break block4;
                                Path p = new Path(writtenPath);
                                if (!p.getFileSystem(this.serConf$1.value()).exists(p)) break block5;
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{writtenPath}));
                        }
                        throw fileAlreadyExistsException;
                    }
                    throw throwable2;
                }
                {
                    this.factory$1 = factory$1;
                    this.serConf$1 = serConf$1;
                    this.useRename$1 = useRename$1;
                    this.checkpointSize$1 = checkpointSize$1;
                    this.path$1 = path$1;
                }
            };
            boolean x$8 = qual$1.mapPartitions$default$2();
            String writtenPath = (String)Predef$.MODULE$.refArrayOps((Object[])qual$1.mapPartitions((Function1)x$7, x$8, ClassTag$.MODULE$.apply(String.class)).collect()).head();
            if (useRename) {
                src = new Path(writtenPath);
                Path dest = new Path(path);
                fs = dest.getFileSystem(spark.sessionState().newHadoopConf());
                renameDone = false;
                if (!fs.rename(src, dest)) {
                    throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot rename ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{src, dest})));
                }
                renameDone = true;
            }
            if (BoxesRunTime.equalsNumObject((Number)numOfFiles.value(), (Object)BoxesRunTime.boxToLong((long)snapshot.numOfFiles()))) {
                return new CheckpointMetaData(snapshot.version(), Predef$.MODULE$.Long2long(checkpointSize.value()), (Option<Object>)None$.MODULE$);
            }
            throw new IllegalStateException("State of the checkpoint doesn't match that of the snapshot.");
        }
        throw new MatchError((Object)tuple2);
        finally {
            if (!renameDone) {
                fs.delete(src, false);
            }
        }
    }

    private Checkpoints$() {
        MODULE$ = this;
    }
}

